/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.service;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.Log;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.android.receiver.PhoneStatus;
import com.aofeng.hybrid.android.receiver.PhoneStatusReceiver;
import com.aofeng.hybrid.android.service.AbstractService;
import com.aofeng.hybrid.android.service.Player;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.service.LogicService;
import com.aofeng.hybrid.util.AndroidIdentification;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickService
extends AbstractService {
    private static final Logger log = LoggerFactory.getLogger(TickService.class);
    private static final int SERVICE_ID = -1001;
    private Player player;
    private boolean shouldStop = false;
    public volatile boolean idle = false;
    private Thread theThread;
    PowerManager.WakeLock wakeLock;
    private boolean loadTimerConfig = false;

    @Override
    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void startAThread(final int alarmInterval) {
        this.theThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PowerManager powerManager = (PowerManager)TickService.this.getSystemService("power");
                    TickService.this.wakeLock = powerManager.newWakeLock(1, "alarmLock");
                    TickService.this.wakeLock.acquire();
                    TickService.this.work(alarmInterval);
                }
                finally {
                    TickService.this.wakeLock.release();
                }
            }
        });
        this.theThread.start();
        AFApplication cfr_ignored_0 = (AFApplication)this.getApplication();
        AFApplication.service = this;
    }

    private void work(int alarmInterval) {
        Date day;
        long n = 0L;
        Date preDay = day = new Date();
        while (true) {
            try {
                while (true) {
                    File file1;
                    File file;
                    if ((file = new File("/data/data/com.aofeng.hybridwork/files/www/static/config.json")) != null && file.exists() && !this.loadTimerConfig) {
                        this.readTimerConfig();
                    }
                    if ((file1 = new File("/data/data/com.aofeng.hybridwork/files/www/static/workflow_apply.json")) != null && file1.exists() && CommUtil.getSharedPreference((Context)this, "f_apply_flow_names").equals("")) {
                        this.readApplyConfig();
                    }
                    if (this.shouldStop) {
                        this.stopPlayer();
                        return;
                    }
                    boolean voiceSwitch = CommUtil.getSharedPreference((Context)this, "f_voiceSwitch").equals("true");
                    System.out.println(voiceSwitch);
                    boolean notLoggedIn = CommUtil.getSharedPreference((Context)this, "f_repairman_id").equals("x");
                    if (CommUtil.getSharedPreference((Context)this, "posReportState").toLowerCase().equals("true") && ++n % (long)AFApplication.POS_STATUS_COUNTER == 0L && !this.shouldStop) {
                        this.reportPosStatus(day, notLoggedIn);
                    }
                    if (notLoggedIn) {
                        LogUtil.e("Not logged in yet", "stay idle......");
                    } else if (!this.idle) {
                        LogUtil.e("cycle " + n, "start timer task");
                        String str = CommUtil.getSharedPreference((Context)this, "timer");
                        if (!"".equals(str)) {
                            JSONArray array = new JSONArray(str);
                            JSONObject item = null;
                            for (int i = 0; i < array.length(); ++i) {
                                int times;
                                item = array.getJSONObject(i);
                                if (!item.has("used") || !item.getString("used").trim().equals("true") || !item.has("alias") || n % (long)(times = item.has("interval") && !item.isNull("interval") && !item.getString("interval").trim().equals("") ? Integer.parseInt(item.getString("interval").trim()) : 3) != 0L || this.shouldStop) continue;
                                if (!item.isNull("hasParams") && item.getString("hasParams").equals("true") && !item.isNull("paramType") && item.getString("paramType").equals("workflow_names")) {
                                    JSONObject obj = new JSONObject();
                                    obj.put("workflow_names", (Object)CommUtil.getSharedPreference((Context)this, "f_apply_flow_names"));
                                    this.invokeKnownLogicWithParam(item.getString("alias"), obj);
                                    continue;
                                }
                                this.invokeKnownLogic(item.getString("alias"), 1, voiceSwitch);
                            }
                        } else if (n % 30L == 0L && !this.shouldStop) {
                            this.invokeKnownLogic("\u5b9a\u65f6\u63d0\u53d6", 0, voiceSwitch);
                        }
                        LogUtil.e("cycle " + n, "timer task completed");
                    }
                    Thread.sleep(alarmInterval);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopPlayer();
                continue;
            }
            break;
        }
    }

    private void invokeKnownLogic(String aliasName, int version, boolean voiceSwitch) {
        try {
            int a;
            LogicService logicService = new LogicService((Context)this);
            boolean dinging = false;
            if (version == 0) {
                JSONObject jo = (JSONObject)logicService.run(aliasName, null);
                CommUtil.setSharedPreference((Context)this, jo);
                if (jo.has("hasNew") && jo.getInt("hasNew") == 1) {
                    dinging |= true;
                }
                if (jo.has("hasNewMsg") && jo.getInt("hasNewMsg") == 1) {
                    dinging |= true;
                }
            } else if (version == 1 && (a = ((Integer)logicService.run(aliasName, null)).intValue()) == 1) {
                dinging |= true;
            }
            if (dinging && voiceSwitch) {
                this.player.play((Context)this, R.raw.ding);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void invokeKnownLogicWithParam(String aliasName, JSONObject param) {
        try {
            LogicService logicService = new LogicService((Context)this);
            boolean dinging = false;
            int a = (Integer)logicService.run(aliasName, param);
            if (a == 1) {
                dinging |= true;
            }
            if (dinging) {
                this.player.play((Context)this, R.raw.ding);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkGpsEnabled() {
        PhoneStatusReceiver.setupGPSReceiver((Context)this);
    }

    private void stopPlayer() {
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    private boolean reportDailyStatus(Date yesterday) {
        return true;
    }

    private void reportMinuteStatus(Date timestamp) {
        try {
            JSONObject data = new JSONObject();
            LogicService logicService = new LogicService((Context)this);
            JSONObject jSONObject = (JSONObject)logicService.run("UpPhoneStatus", data);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.e("\u5b89\u68c0\u5458\u72b6\u6001", "\u4e0a\u4f20\u5b9e\u65f6\u72b6\u6001\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u3002");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportMinuteStatusToLocal(Date timestamp) {
        try {
            JSONObject pref = CommUtil.getHybridContext((Context)this);
            if (!pref.has("f_repairman_id")) {
                return;
            }
            String f_user_name = pref.getString("f_repairman_name");
            String f_subcompany = pref.getString("f_subcompany");
            String f_user_id = pref.get("f_repairman_id") + "";
            JSONObject jo = PhoneStatus.getPhoneStatus((Context)this, timestamp);
            if (jo.getString("f_longitude").equals("0.0")) {
                jo.put("f_longitude", (Object)"0");
            }
            if (jo.getString("f_latitude").equals("0.0")) {
                jo.put("f_latitude", (Object)"0");
            }
            if (!jo.getString("f_longitude").equals("0") && this.getResources().getString(R.string.geo).equals("baidu")) {
                HttpGet httpGet = new HttpGet("http://api.map.baidu.com/geoconv/v1/?coords=" + jo.get("f_longitude") + "," + jo.get("f_latitude") + "&ak=CAErfbr2DatVA6rHdoUELPynrdPh9A6S&output=json");
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                try (BufferedReader rd = null;){
                    rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                    String line = rd.readLine();
                    JSONObject jr = new JSONObject(line);
                    jr = jr.getJSONArray("result").getJSONObject(0);
                    jo.put("f_longitude", (Object)jr.getString("x"));
                    jo.put("f_latitude", (Object)jr.getString("y"));
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            jo.put("f_user_name", (Object)f_user_name);
            jo.put("f_user_id", (Object)f_user_id);
            jo.put("f_realtime", (Object)sdf.format(timestamp));
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:00");
            jo.put("f_datetime", (Object)sdf.format(timestamp));
            jo.put("f_period", (Object)"\u5206");
            JSONObject config = CommUtil.getHybridContext((Context)this);
            jo.put("f_subcompany", (Object)f_subcompany);
            if (MainActivity.beginGps == "\u5f00\u59cb") {
                jo.put("f_is_start", 1);
            }
            JSONObject data = new JSONObject();
            LogicService logicService = new LogicService((Context)this);
            JSONObject result = (JSONObject)logicService.run("LocalPhoneStatus", jo);
            LogUtil.d("result=====>", result + "");
            if (Integer.parseInt(result.getString("code")) == 200 && MainActivity.beginGps == "\u5f00\u59cb") {
                MainActivity.beginGps = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.e("\u5b89\u68c0\u5458\u72b6\u6001", "\u4e0a\u4f20\u5b9e\u65f6\u72b6\u6001\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u3002");
        }
    }

    private String getSN(Context context) {
        if (!"true".equals(CommUtil.getSharedPreference(context, "pos").toLowerCase())) {
            return AndroidIdentification.getUniqueId();
        }
        if (AFApplication.device == null) {
            try {
                AFApplication.initPos(context);
            }
            catch (Exception e) {
                Log.e((String)"error", (String)("NativeBaseMethod\uff0c\u521d\u59cb\u5316pos\u5931\u8d25" + e.getMessage()));
            }
        }
        return AFApplication.device.getSN();
    }

    private void reportPosStatus(Date day, Boolean notLoggedIn) {
        LogUtil.i("reportPosStatus", "\u51c6\u5907\u4e0a\u4f20pos\u72b6\u6001\u3002");
        try {
            JSONObject posStatus = new JSONObject();
            posStatus.put("f_terminal_number", (Object)this.getSN((Context)this));
            posStatus.put("f_battery_level", (Object)String.valueOf(PhoneStatus.getBatteryLevel((Context)this)));
            posStatus.put("f_is_login", (Object)String.valueOf(notLoggedIn == false));
            posStatus.put("f_hybrid_version", (Object)CommUtil.getSharedPreference((Context)this, "f_hybrid_version"));
            posStatus.put("f_appVer", (Object)CommUtil.getSharedPreference((Context)this, "f_appVer"));
            posStatus.put("f_report_date", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(day));
            HttpPost httpPost = new HttpPost(CommUtil.getSharedPreference((Context)this, "cc_base_url") + "/rs/logic/PosStatus");
            httpPost.setEntity((HttpEntity)new StringEntity(String.format("%s", posStatus.toString()), "UTF8"));
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            LogUtil.e("pos\u72b6\u6001", "\u4e0a\u4f20pos\u72b6\u6001\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u3002");
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.e((String)"MyService", (String)("Received start id " + startId + ": " + intent));
        if (Build.VERSION.SDK_INT < 18) {
            this.startForeground(-1001, new Notification());
        } else {
            Intent innerIntent = new Intent((Context)this, TickShadowService.class);
            if (Build.VERSION.SDK_INT >= 26) {
                this.startForegroundService(innerIntent);
            } else {
                this.startService(innerIntent);
            }
            this.startForeground(-1001, new Notification());
        }
        return super.onStartCommand(intent, flags, startId);
    }

    private void readTimerConfig() throws IOException {
        LogUtil.e("\u65b0\u5efaservice\u5bf9\u8c61", "\u521b\u5efa\u670d\u52a1\u5bf9\u8c61\u5e76\u542f\u52a8\u670d\u52a1");
        try (BufferedReader reader = null;){
            File file = new File("/data/data/com.aofeng.hybridwork/files/www/static/config.json");
            if (file != null && file.exists()) {
                String mLine;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String str = "";
                while ((mLine = reader.readLine()) != null) {
                    str = str + mLine;
                }
                if (!"".equals(str)) {
                    JSONObject json = new JSONObject(str);
                    Iterator keys = json.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        Object value = json.get(key);
                        if (value instanceof String) {
                            CommUtil.setSharedPreference((Context)this, key, (String)value);
                            continue;
                        }
                        if (!(value instanceof JSONArray)) continue;
                        str = TickService.toString((JSONArray)value);
                        CommUtil.setSharedPreference((Context)this, key, str);
                    }
                }
                this.loadTimerConfig = true;
            }
        }
    }

    private void readApplyConfig() throws IOException {
        try (BufferedReader reader = null;){
            File file = new File("/data/data/com.aofeng.hybridwork/files/www/static/workflow_apply.json");
            if (file != null && file.exists()) {
                String mLine;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String str = "";
                while ((mLine = reader.readLine()) != null) {
                    str = str + mLine;
                }
                if (!"".equals(str)) {
                    JSONArray array = new JSONArray(new JSONObject(str).getString("activitys"));
                    JSONObject item = null;
                    StringBuffer sb = new StringBuffer("");
                    for (int i = 0; i < array.length(); ++i) {
                        item = array.getJSONObject(i);
                        if (item.isNull("mobile") || !"true".equals(item.getString("mobile").toLowerCase())) continue;
                        if (sb.toString().length() <= 0) {
                            sb.append("'" + item.getString("title") + "'");
                            continue;
                        }
                        sb.append(",'" + item.getString("title") + "'");
                    }
                    CommUtil.setSharedPreference((Context)this, "f_apply_flow_names", sb.toString());
                }
            }
        }
    }

    @Override
    public void onStartService() {
        LogUtil.e("\u65b0\u5efaservice\u5bf9\u8c61", "\u521b\u5efa\u670d\u52a1\u5bf9\u8c61\u5e76\u542f\u52a8\u670d\u52a1");
        this.player = new Player();
        this.startAThread(AFApplication.BASE_INTERVAL);
    }

    private static String toString(JSONArray array) {
        String result = "";
        for (int i = 0; i < array.length(); ++i) {
            if (!result.equals("")) {
                result = result + ",";
            }
            try {
                String s = array.getString(i);
                result = result + s.toString();
                continue;
            }
            catch (JSONException var4) {
                throw new RuntimeException(var4);
            }
        }
        result = "[" + result + "]";
        return result;
    }

    @Override
    public void onStopService() {
        this.stopPlayer();
        this.shouldStop = true;
        this.loadTimerConfig = false;
        AFApplication cfr_ignored_0 = (AFApplication)this.getApplication();
        AFApplication.service = null;
    }

    public void mute() {
        this.player.stop();
    }

    @Override
    public void onReceiveMessage(Message msg) {
    }

    public static class TickShadowService
    extends Service {
        public int onStartCommand(Intent intent, int flags, int startId) {
            this.startForeground(-1001, new Notification());
            this.stopForeground(true);
            this.stopSelf();
            return super.onStartCommand(intent, flags, startId);
        }

        @Nullable
        public IBinder onBind(Intent intent) {
            return null;
        }
    }
}

