/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.plugin;

import android.app.Activity;
import android.webkit.WebView;
import com.aofeng.hybrid.util.LogUtil;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

public class NativeCallJS {
    private static final String CALLBACK_JS_FORMAT = "javascript:%s.callback(%d, %d %s);";
    private int mIndex;
    private boolean mCouldCallAgain = true;
    private WeakReference<WebView> mWebViewRef;
    private int mIsSticky;
    private String mInjectedName;

    public NativeCallJS(WebView view, String injectedName, int index) {
        this.mWebViewRef = new WeakReference<WebView>(view);
        this.mInjectedName = injectedName;
        this.mIndex = index;
    }

    public void apply(Object ... args) throws JsCallbackException {
        if (this.mWebViewRef.get() == null) {
            throw new JsCallbackException("\u5f31\u5f15\u7528\u5931\u6548\u3002");
        }
        if (!this.mCouldCallAgain) {
            throw new JsCallbackException("\u4e0d\u80fd\u591a\u6b21\u8c03\u7528\u3002");
        }
        StringBuilder sb = new StringBuilder();
        for (Object arg : args) {
            sb.append(",");
            boolean isStrArg = arg instanceof String;
            if (isStrArg) {
                sb.append("\"");
            }
            if (arg instanceof JSONObject) {
                sb.append(JSONObject.quote((String)((JSONObject)arg).toString()));
            } else {
                sb.append(String.valueOf(arg));
            }
            if (!isStrArg) continue;
            sb.append("\"");
        }
        final String execJs = String.format(CALLBACK_JS_FORMAT, this.mInjectedName, this.mIndex, this.mIsSticky, sb.toString());
        LogUtil.d("JsCallBack", execJs);
        this.mCouldCallAgain = this.mIsSticky > 0;
        ((Activity)((WebView)this.mWebViewRef.get()).getContext()).runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ((WebView)NativeCallJS.this.mWebViewRef.get()).loadUrl(execJs);
            }
        });
    }

    public void setPermanent(boolean value) {
        this.mIsSticky = value ? 1 : 0;
    }

    public static class JsCallbackException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public JsCallbackException(String msg) {
            super(msg);
        }
    }
}

