/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.orm;

import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.aofeng.hybrid.android.db.QueryExecutor;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseManager {
    private static final Logger log = LoggerFactory.getLogger(DatabaseManager.class);
    private AtomicInteger mOpenCounter = new AtomicInteger();
    private static DatabaseManager instance;
    private SQLiteOpenHelper mDatabaseHelper;
    private SQLiteDatabase mDatabase;

    private DatabaseManager(SQLiteOpenHelper helper) {
        this.mDatabaseHelper = helper;
    }

    public static synchronized void initializeInstance(SQLiteOpenHelper helper) {
        if (instance == null) {
            instance = new DatabaseManager(helper);
        }
    }

    public static synchronized DatabaseManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException(DatabaseManager.class.getSimpleName() + " is not initialized, call initializeInstance(..) method first.");
        }
        return instance;
    }

    private synchronized SQLiteDatabase openDatabase() {
        if (this.mOpenCounter.incrementAndGet() == 1) {
            this.mDatabase = this.mDatabaseHelper.getWritableDatabase();
        }
        log.debug("Database open counter: " + this.mOpenCounter.get());
        return this.mDatabase;
    }

    private synchronized void closeDatabase() {
        if (this.mOpenCounter.decrementAndGet() == 0) {
            this.mDatabase.close();
        }
        log.debug("Database open counter: " + this.mOpenCounter.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeQuery(QueryExecutor executor) throws Exception {
        SQLiteDatabase database = this.openDatabase();
        try {
            Object object = executor.run(database);
            return object;
        }
        finally {
            this.closeDatabase();
        }
    }
}

