/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.sign;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import com.aofeng.hybrid.android.sign.BasePenExtend;
import com.aofeng.hybrid.android.sign.BrushPen;
import com.aofeng.hybrid.android.sign.IPenConfig;
import com.aofeng.hybrid.android.sign.SteelPen;
import com.aofeng.hybrid.util.CommUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class SignatureView
extends View {
    private static final String TAG = "DrawPenView";
    private Paint mPaint;
    private Canvas mCanvas;
    private Bitmap mBitmap;
    private Context mContext;
    public static int mCanvasCode = 1;
    private BasePenExtend mStokeBrushPen;
    private boolean mIsCanvasDraw;
    private int mPenconfig;
    public TimeListener mGetTimeListner;
    private int mBackColor = 0;

    public SignatureView(Context context) {
        super(context);
        this.initParameter(context);
    }

    public SignatureView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initParameter(context);
    }

    public SignatureView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initParameter(context);
    }

    private void initParameter(Context context) {
        this.mContext = context;
        DisplayMetrics dm = new DisplayMetrics();
        ((Activity)this.mContext).getWindowManager().getDefaultDisplay().getMetrics(dm);
        String SCREEN_ORIENTATION = CommUtil.getSharedPreference(context, "SCREEN_ORIENTATION");
        SCREEN_ORIENTATION = SCREEN_ORIENTATION == "" ? "1" : SCREEN_ORIENTATION;
        this.mBitmap = SCREEN_ORIENTATION.equals("1") ? Bitmap.createBitmap((int)Math.min(dm.widthPixels, dm.heightPixels), (int)Math.max(dm.widthPixels, dm.heightPixels), (Bitmap.Config)Bitmap.Config.ARGB_8888) : Bitmap.createBitmap((int)Math.max(dm.widthPixels, dm.heightPixels), (int)Math.min(dm.widthPixels, dm.heightPixels), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mStokeBrushPen = new SteelPen(context);
        this.initPaint();
        this.initCanvas();
    }

    private void initPaint() {
        this.mPaint = new Paint();
        this.mPaint.setColor(IPenConfig.PEN_CORLOUR);
        this.mPaint.setStrokeWidth(60.0f);
        this.mPaint.setStyle(Paint.Style.STROKE);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setAlpha(255);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeMiter(1.0f);
        this.mStokeBrushPen.setPaint(this.mPaint);
    }

    private void initCanvas() {
        this.mCanvas = new Canvas(this.mBitmap);
        this.mCanvas.drawColor(-1);
    }

    protected void onDraw(Canvas canvas) {
        try {
            canvas.drawBitmap(this.mBitmap, 0.0f, 0.0f, this.mPaint);
            switch (mCanvasCode) {
                case 1: 
                case 2: {
                    this.mStokeBrushPen.draw(canvas);
                    break;
                }
                case 0: {
                    this.reset();
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("onDraw" + Integer.toString(mCanvasCode)));
                }
            }
            super.onDraw(canvas);
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
    }

    public void setCanvasCode(int canvasCode) {
        mCanvasCode = canvasCode;
        switch (mCanvasCode) {
            case 1: {
                this.mStokeBrushPen = new SteelPen(this.mContext);
                break;
            }
            case 2: {
                this.mStokeBrushPen = new BrushPen(this.mContext);
            }
        }
        if (this.mStokeBrushPen.isNull()) {
            this.mStokeBrushPen.setPaint(this.mPaint);
        }
        this.invalidate();
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.mIsCanvasDraw = true;
        MotionEvent event2 = MotionEvent.obtain((MotionEvent)event);
        this.mStokeBrushPen.onTouchEvent(event2, this.mCanvas);
        switch (event2.getActionMasked()) {
            case 0: {
                if (this.mGetTimeListner == null) break;
                this.mGetTimeListner.stopTime();
                break;
            }
            case 2: {
                if (this.mGetTimeListner == null) break;
                this.mGetTimeListner.stopTime();
                break;
            }
            case 1: {
                long time = System.currentTimeMillis();
                if (this.mGetTimeListner == null) break;
                this.mGetTimeListner.getTime(time);
                break;
            }
        }
        this.invalidate();
        return true;
    }

    public boolean getHasDraw() {
        return this.mIsCanvasDraw;
    }

    public void reset() {
        this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.mCanvas.drawPaint(this.mPaint);
        this.mPaint.setXfermode(null);
        this.mIsCanvasDraw = false;
        this.mStokeBrushPen.clear();
        mCanvasCode = this.mPenconfig;
    }

    public void setGetTimeListener(TimeListener l) {
        this.mGetTimeListner = l;
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setPenconfig(int penconfig) {
        this.mPenconfig = penconfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBiography(String id2) {
        if (!this.getHasDraw()) {
            return;
        }
        FileOutputStream out = null;
        File target = new File(id2);
        Bitmap bt = this.getBitmap();
        try {
            out = new FileOutputStream(target);
            bt.compress(Bitmap.CompressFormat.PNG, 50, (OutputStream)out);
            bt.recycle();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public Bitmap clearBlank(int blank) {
        if (this.mBitmap != null) {
            int x;
            boolean isStop;
            int y;
            int HEIGHT = this.mBitmap.getHeight();
            int WIDTH = this.mBitmap.getWidth();
            int top = 0;
            int left = 0;
            int right = 0;
            int bottom = 0;
            int[] pixs = new int[WIDTH];
            for (y = 0; y < HEIGHT; ++y) {
                this.mBitmap.getPixels(pixs, 0, WIDTH, 0, y, WIDTH, 1);
                isStop = false;
                for (int pix : pixs) {
                    if (pix == this.mBackColor) continue;
                    top = y;
                    isStop = true;
                    break;
                }
                if (isStop) break;
            }
            for (y = HEIGHT - 1; y >= 0; --y) {
                this.mBitmap.getPixels(pixs, 0, WIDTH, 0, y, WIDTH, 1);
                isStop = false;
                for (int pix : pixs) {
                    if (pix == this.mBackColor) continue;
                    bottom = y;
                    isStop = true;
                    break;
                }
                if (isStop) break;
            }
            pixs = new int[HEIGHT];
            for (x = 0; x < WIDTH; ++x) {
                this.mBitmap.getPixels(pixs, 0, 1, x, 0, 1, HEIGHT);
                isStop = false;
                for (int pix : pixs) {
                    if (pix == this.mBackColor) continue;
                    left = x;
                    isStop = true;
                    break;
                }
                if (isStop) break;
            }
            for (x = WIDTH - 1; x > 0; --x) {
                this.mBitmap.getPixels(pixs, 0, 1, x, 0, 1, HEIGHT);
                isStop = false;
                for (int pix : pixs) {
                    if (pix == this.mBackColor) continue;
                    right = x;
                    isStop = true;
                    break;
                }
                if (isStop) break;
            }
            if (blank < 0) {
                blank = 0;
            }
            left = left - blank > 0 ? left - blank : 0;
            top = top - blank > 0 ? top - blank : 0;
            right = right + blank > WIDTH - 1 ? WIDTH - 1 : right + blank;
            bottom = bottom + blank > HEIGHT - 1 ? HEIGHT - 1 : bottom + blank;
            return Bitmap.createBitmap((Bitmap)this.mBitmap, (int)left, (int)top, (int)(right - left), (int)(bottom - top));
        }
        return null;
    }

    public static interface TimeListener {
        public void getTime(long var1);

        public void stopTime();
    }
}

