/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.util;

import android.text.TextUtils;
import android.util.Log;
import org.json.JSONArray;
import org.json.JSONObject;

public class LogUtil {
    public static void v(String tag, String info) {
        if (LogUtil.isDebug()) {
            Log.v((String)tag, (String)info);
        }
    }

    public static void v(String tag, String msg, Object ... args) {
        if (args != null && args.length > 0) {
            msg = String.format(msg, args);
        }
        LogUtil.v(tag, msg);
    }

    public static void d(String tag, String info) {
        if (LogUtil.isDebug()) {
            Log.d((String)tag, (String)info);
        }
    }

    public static void d(String tag, String msg, Object ... args) {
        if (args != null && args.length > 0) {
            msg = String.format(msg, args);
        }
        if (LogUtil.isDebug()) {
            LogUtil.d(tag, msg);
        }
    }

    public static void i(String tag, String info) {
        if (LogUtil.isDebug()) {
            Log.i((String)tag, (String)info);
        }
    }

    public static void i(String tag, String msg, Object ... args) {
        if (args != null && args.length > 0) {
            msg = String.format(msg, args);
        }
        if (LogUtil.isDebug()) {
            LogUtil.i(tag, msg);
        }
    }

    public static void w(String tag, String info) {
        if (LogUtil.isDebug()) {
            Log.w((String)tag, (String)info);
        }
    }

    public static void w(String tag, String msg, Object ... args) {
        if (args != null && args.length > 0) {
            msg = String.format(msg, args);
        }
        if (LogUtil.isDebug()) {
            LogUtil.w(tag, msg);
        }
    }

    public static void e(String tag, String info) {
        if (LogUtil.isDebug()) {
            Log.e((String)tag, (String)info);
        }
    }

    public static void e(String tag, String msg, Object ... args) {
        if (args != null && args.length > 0) {
            msg = String.format(msg, args);
        }
        if (LogUtil.isDebug()) {
            LogUtil.e(tag, msg);
        }
    }

    public static void e(String tag, String info, Throwable throwable) {
        if (LogUtil.isDebug()) {
            Log.e((String)tag, (String)info, (Throwable)throwable);
        }
    }

    public static boolean isDebug() {
        return true;
    }

    public static String formatJson(String json) {
        String message = json;
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                if (json.startsWith("{")) {
                    JSONObject jsonObject = new JSONObject(json);
                    message = jsonObject.toString(4);
                }
                if (json.startsWith("[")) {
                    JSONArray jsonArray = new JSONArray(json);
                    message = jsonArray.toString(4);
                }
            }
            catch (Exception e) {
                LogUtil.e("formatJson", e.getMessage(), e);
            }
        }
        return message;
    }
}

