/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.sync;

import android.util.Log;
import com.aofeng.hybrid.sync.MD5Manager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class SyncFileHelper {
    public static void processFile(String localDirPrefix, String path, long timestamp, String remoteDir, String fileDownloadUrl) throws Exception {
        long lastModifedTime;
        path = path.replace("\\", "/");
        File file = new File(localDirPrefix + path);
        int pos = path.lastIndexOf("/");
        if (!file.exists()) {
            if (pos != -1) {
                File fullPath = new File(localDirPrefix + path.substring(0, pos));
                fullPath.mkdirs();
            }
            file.createNewFile();
        }
        if (Math.abs((lastModifedTime = file.lastModified()) - timestamp) > 1000L) {
            file.createNewFile();
            SyncFileHelper.downloadFile(fileDownloadUrl, file, remoteDir + path.replace("/", "\\"));
            file.setLastModified(timestamp);
        }
    }

    public static void processFile2(String localDirPrefix, String path, String md5, String remoteDir, String fileDownloadUrl) throws Exception {
        String lastMd5;
        path = (path = path.replace("\\", "/")).startsWith("/") ? path.substring(1, path.length()) : path;
        File file = new File(localDirPrefix + path);
        int pos = path.lastIndexOf("/");
        if (!file.exists()) {
            File fullPath;
            if (pos != -1 && !(fullPath = new File(localDirPrefix + path.substring(0, pos))).exists() && !fullPath.mkdirs()) {
                throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u8def\u5f84\u5931\u8d25!" + fullPath.getAbsolutePath());
            }
            file.createNewFile();
        }
        if (!md5.equals(lastMd5 = MD5Manager.getInstance().getMd5(path))) {
            file.createNewFile();
            SyncFileHelper.downloadFile(fileDownloadUrl, file, path);
        }
    }

    private static void downloadFile(String fileDownloadUrl, File file, String path) throws Exception {
        int numread;
        URL url = new URL(fileDownloadUrl);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoOutput(true);
        conn.setRequestMethod("POST");
        conn.getOutputStream().write(path.getBytes("UTF-8"));
        InputStream is = conn.getInputStream();
        FileOutputStream os = new FileOutputStream(file);
        Log.d((String)"download and safe file:", (String)file.getAbsolutePath());
        byte[] buf = new byte[1024];
        while ((numread = is.read(buf)) != -1) {
            ((OutputStream)os).write(buf, 0, numread);
        }
        is.close();
        ((OutputStream)os).close();
    }

    public static void makeRootDir(String localDirPrefix) {
        File fullPath = new File(localDirPrefix);
        if (!fullPath.exists()) {
            fullPath.mkdirs();
        }
    }
}

