/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import com.af.plugins.android.ZTchagnan.SlotCard;
import com.aofeng.hybrid.pos.device.ZTDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import com.szzt.sdk.device.card.SmartCardSlotInfo;

public class ZTChangAnReader
implements ICardReader {
    private static int SLOT = 0;
    private static int TIMEOUT = 60000;

    @Override
    public boolean openDevice(Chip chip) {
        return ZTChangAnReader.openReader();
    }

    @Override
    public boolean closeDevice(Chip chip) {
        return ZTChangAnReader.closeReader();
    }

    @Override
    public boolean read(Chip chip) {
        try {
            if (chip.chipName == 1) {
                return ZTChangAnReader.read4442(0, 256, chip.buf);
            }
            if (chip.chipName == 0) {
                if (chip.secret != null) {
                    for (int i = 0; i < chip.secret.length(); i += 4) {
                        String pwd = chip.secret.substring(i, i + 4);
                        if (!ZTChangAnReader.verify102Pwd(HexDump.hexStringToByteArray(pwd))) continue;
                        chip.secret = pwd;
                        return ZTChangAnReader.read102(0, 178, chip.buf, null);
                    }
                    return false;
                }
                return ZTChangAnReader.read102(0, 178, chip.buf, null);
            }
            if (chip.chipName == 3) {
                return ZTChangAnReader.read24C02(0, 256, chip.buf);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 0) {
            return ZTChangAnReader.write102(offset, len, buf, secret);
        }
        if (chip.chipName == 1) {
            return ZTChangAnReader.write4442(offset, len, buf, secret);
        }
        if (chip.chipName == 6) {
            return ZTChangAnReader.write1608(block, offset, len, buf, secret);
        }
        return false;
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!ZTChangAnReader.verify102Pwd(new byte[]{secret[i], secret[i + 1]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!ZTChangAnReader.verify4442Pwd(new byte[]{secret[i], secret[i + 1], secret[i + 2]})) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 6) {
            return ZTChangAnReader.verify1608Pwd(block, secret);
        }
        return true;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return ZTChangAnReader.change102Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 1) {
            return ZTChangAnReader.change4442Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 6) {
            return ZTChangAnReader.change1608Pwd(block, oldSecret, newSecret);
        }
        return true;
    }

    @Override
    public Chip getNvlChip() {
        SlotCard sc = ZTDevice.careader.findTheSlotThatHasCardOn();
        if (sc.slot < 0) {
            if (sc.slot == -1) {
                return new Chip(-1);
            }
            if (sc.slot == -2) {
                return new Chip(-2);
            }
            return new Chip(-3);
        }
        if (sc.slot == 1 && sc.cardType == 0 || sc.slot == 0 && sc.cardType == 0) {
            return new Chip(9);
        }
        int ct = ZTChangAnReader.getCardType();
        if (ct == 1) {
            return new Chip(1);
        }
        if (ct == 4) {
            return new Chip(0);
        }
        if (ct == 3) {
            return new Chip(3);
        }
        if (ct == 6) {
            return new Chip(6);
        }
        return null;
    }

    @Override
    public boolean hasCard() {
        ZTChangAnReader.openReader();
        boolean hascard = false;
        int res = ZTDevice.nativeReader.queryPresence(SLOT);
        if (res > 0) {
            hascard = true;
        }
        return hascard;
    }

    public static boolean openReader() {
        int ret = ZTDevice.nativeReader.open(SLOT, null);
        if (ret < 0) {
            return false;
        }
        byte[] buf = new byte[4];
        ZTDevice.nativeReader.powerOn(SLOT, buf);
        return true;
    }

    public static boolean closeReader() {
        ZTDevice.nativeReader.powerOff(SLOT);
        return ZTDevice.nativeReader.close(SLOT) >= 0;
    }

    public static int getCardType() {
        if (!ZTChangAnReader.openReader()) {
            return -1;
        }
        try {
            SmartCardSlotInfo slot = new SmartCardSlotInfo();
            slot.power = (byte)2;
            ZTDevice.nativeReader.setSlotInfo(SLOT, slot);
            int ret = ZTDevice.nativeReader.queryPresence(SLOT);
            if (ret <= 0) {
                int n = -1;
                return n;
            }
            ret = ZTDevice.nativeReader.waitForCard(SLOT, TIMEOUT);
            if (ret != 0) {
                int n = -1;
                return n;
            }
            int n = ZTDevice.nativeReader.getCardType(SLOT);
            return n;
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            ZTChangAnReader.closeReader();
        }
    }

    public static boolean verify4442Pwd(byte[] key) {
        int ret = ZTDevice.nativeReader.verify(SLOT, key, 18);
        return ret == 0;
    }

    public static boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        if (ZTChangAnReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !ZTChangAnReader.verify4442Pwd(oldKey)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 2, 1, newKey);
        return ret == 0;
    }

    public static int get4442PwdAttemptCnt() {
        byte[] count = new byte[1];
        int ret = ZTDevice.nativeReader.read(SLOT, 2, 0, count);
        if (ret > 0) {
            if ((count[0] & 7) == 7) {
                return 3;
            }
            if ((count[0] & 6) == 6) {
                return 2;
            }
            if ((count[0] & 4) == 4) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public static boolean read4442(int offset, int len, byte[] buf) {
        if (ZTChangAnReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        int lockstate = ZTDevice.nativeReader.lock(SLOT);
        int ret = ZTDevice.nativeReader.read(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean write4442(int offset, int len, byte[] buf, byte[] key) {
        if (ZTChangAnReader.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !ZTChangAnReader.verify4442Pwd(key)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean read24C02(int offset, int len, byte[] buf) {
        int ret = ZTDevice.nativeReader.read(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean write24C02(int offset, int len, byte[] buf) {
        int ret = ZTDevice.nativeReader.write(SLOT, 0, offset, buf);
        return ret >= 0;
    }

    public static boolean verify102Pwd(byte[] key) {
        int ret = ZTDevice.nativeReader.verify(SLOT, key, 18);
        return ret == 0;
    }

    public static boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        if (ZTChangAnReader.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !ZTChangAnReader.verify102Pwd(oldKey)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 0, 80, newKey);
        return ret == 0;
    }

    public static int get102PwdAttemptCnt() {
        byte[] count = new byte[4];
        int ret = ZTDevice.nativeReader.read(SLOT, 0, 12, count);
        if (ret > 0) {
            if ((count[0] & 0xF0) == 240) {
                return 4;
            }
            if ((count[0] & 0xF0) == 112) {
                return 3;
            }
            if ((count[0] & 0xF0) == 48) {
                return 2;
            }
            if ((count[0] & 0xF0) == 16) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public static boolean read102(int offset, int len, byte[] buf, byte[] key) {
        int ret = ZTChangAnReader.get102PwdAttemptCnt();
        if (ret <= 0) {
            return false;
        }
        if (key != null && !ZTChangAnReader.verify102Pwd(key)) {
            return false;
        }
        ret = ZTDevice.nativeReader.read(SLOT, 0, offset * 8, buf);
        return ret >= 0;
    }

    public static boolean write102(int offset, int len, byte[] buf, byte[] key) {
        if (ZTChangAnReader.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !ZTChangAnReader.verify102Pwd(key)) {
            return false;
        }
        int ret = ZTDevice.nativeReader.write(SLOT, 0, offset * 8, buf);
        return ret >= 0;
    }

    public static boolean read1608(int block, int offset, int len, byte[] buf, byte[] key) {
        int area = block + 4 - 8;
        int ret = ZTDevice.nativeReader.verify(SLOT, key, block);
        if (ret != 0) {
            return false;
        }
        ret = ZTDevice.nativeReader.read(SLOT, area, offset, buf);
        return ret >= 0;
    }

    public static boolean write1608(int block, int offset, int len, byte[] buf, byte[] key) {
        if (ZTChangAnReader.get1608PwdAttemptCnt(block) <= 0) {
            return false;
        }
        int area = block + 4;
        int ret = ZTDevice.nativeReader.verify(SLOT, key, block);
        if (ret != 0) {
            return false;
        }
        ret = ZTDevice.nativeReader.write(SLOT, area, offset, buf);
        return ret >= 0;
    }

    public static int get1608PwdAttemptCnt(int block) {
        byte[] count;
        int address = block > 7 ? (block - 8) * 8 + 68 : block * 8 + 64;
        int ret = ZTDevice.nativeReader.read(SLOT, 3, address, count = new byte[1]);
        if (ret > 0) {
            return count[0];
        }
        return 0;
    }

    public static boolean verify1608Pwd(int block, byte[] key) {
        int ret = ZTDevice.nativeReader.verify(SLOT, key, block);
        return ret == 0;
    }

    public static boolean change1608Pwd(int block, byte[] oldKey, byte[] key) {
        int ret;
        if (oldKey != null && (ret = ZTDevice.nativeReader.verify(SLOT, oldKey, block)) != 0) {
            return false;
        }
        int address = block > 7 ? (block - 8) * 8 + 69 : block * 8 + 65;
        ret = ZTDevice.nativeReader.read(SLOT, 3, address, key);
        return ret >= 0;
    }

    @Override
    public byte[] resetCPUCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] resetPSAMCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] CPUsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }
}

