/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.widget.Toast;
import blesps.BluetoothUtils;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.pos.device.BlueDevice;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.util.HexDump;
import java.util.ArrayList;
import java.util.List;

public class PrmtReader
implements ICardReader {
    public BluetoothUtils mBluetoothUtils;
    private List<BlueDevice> devices = new ArrayList<BlueDevice>();
    public BluetoothDevice device;
    private Context mContext;
    public static String bluePrefix;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (3 == msg.what) {
                PrmtReader.this.devices.clear();
                for (int i = 0; i < PrmtReader.this.mBluetoothUtils.mLeDevices.size(); ++i) {
                    if (((BluetoothDevice)PrmtReader.this.mBluetoothUtils.mLeDevices.get(i)).getName() == null || !((BluetoothDevice)PrmtReader.this.mBluetoothUtils.mLeDevices.get(i)).getName().startsWith(bluePrefix)) continue;
                    PrmtReader.this.devices.add(new BlueDevice(((BluetoothDevice)PrmtReader.this.mBluetoothUtils.mLeDevices.get(i)).getName(), ((BluetoothDevice)PrmtReader.this.mBluetoothUtils.mLeDevices.get(i)).getAddress(), (BluetoothDevice)PrmtReader.this.mBluetoothUtils.mLeDevices.get(i)));
                }
                if (PrmtReader.this.devices.size() > 0) {
                    PrmtReader.this.device = ((BlueDevice)PrmtReader.this.devices.get(0)).getBtd();
                    Toast.makeText((Context)MainActivity.context, (CharSequence)"\u84dd\u7259\u641c\u7d22\u6210\u529f\uff0c\u8bf7\u57281\u5206\u949f\u5185\u64cd\u4f5c\u5361", (int)1).show();
                }
            }
        }
    };

    public void ScanBluetooth(Context mContext, String bluePrefix) {
        this.mContext = mContext;
        PrmtReader.bluePrefix = bluePrefix;
        this.mBluetoothUtils = new BluetoothUtils();
        this.mBluetoothUtils.initialize(this.mContext, this.mHandler);
        this.mBluetoothUtils.scanBleDevice(true);
    }

    @Override
    public boolean openDevice(Chip chip) {
        int type;
        if (chip.chipName == 0) {
            type = 0;
        } else if (chip.chipName == 1) {
            type = 19;
        } else {
            return false;
        }
        if (0 != this.mBluetoothUtils.power_onRW()) {
            this.mBluetoothUtils.checkGattConnected();
            return false;
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (0 != this.mBluetoothUtils.CardTyRW(type)) {
            this.mBluetoothUtils.checkGattConnected();
            return false;
        }
        return true;
    }

    @Override
    public boolean closeDevice(Chip chip) {
        this.mBluetoothUtils.power_offRW();
        this.mBluetoothUtils.checkGattConnected();
        return true;
    }

    @Override
    public boolean hasCard() {
        return true;
    }

    @Override
    public boolean read(Chip chip) {
        if (chip.chipName == 1) {
            return this.read4442(2, 0, 256, chip.buf);
        }
        if (chip.chipName == 0) {
            if (chip.secret != null) {
                for (int i = 0; i < chip.secret.length(); i += 4) {
                    String pwd = chip.secret.substring(i, i + 4);
                    if (!this.verify102Pwd(pwd)) continue;
                    chip.secret = pwd;
                    return this.read102(178, chip.buf, null);
                }
                return false;
            }
            return this.read102(178, chip.buf, null);
        }
        return false;
    }

    @Override
    public boolean write(Chip chip, int block, int offset, int len, byte[] buf, byte[] secret) {
        if (chip.chipName == 0) {
            return this.write102(block, offset, len, buf, HexDump.toHexString(secret));
        }
        if (chip.chipName == 1) {
            return this.write4442(2, offset, len, buf, HexDump.toHexString(secret));
        }
        return false;
    }

    public boolean write4442(int block, int offset, int len, byte[] buf, String key) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !key.equals("null") && !this.verify4442Pwd(key)) {
            return false;
        }
        return this.writecard(block, offset, len, buf, 1);
    }

    public boolean write102(int block, int offset, int len, byte[] buf, String key) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !key.equals("null") && !this.verify102Pwd(key)) {
            return false;
        }
        return this.writecard(block, offset, len, buf, 0);
    }

    public boolean writecard(int block, int offset, int len, byte[] buf, int type) {
        if (len > 30) {
            byte[] bytes;
            int a = len / 30;
            int b = len % 30;
            for (int i = 0; i < a; ++i) {
                bytes = new byte[32];
                bytes[0] = -1;
                bytes[bytes.length - 1] = -1;
                System.arraycopy(buf, 30 * i, bytes, 1, 30);
                if (0 == type) {
                    if (0 == this.mBluetoothUtils.wr_datRW(block, offset + 32 * i, 30, bytes)) continue;
                    return false;
                }
                if (1 == type) {
                    if (0 == this.mBluetoothUtils.wr_dat4442RW(block, offset + 32 * i, 30, bytes)) continue;
                    return false;
                }
                return false;
            }
            if (b != 0) {
                bytes = new byte[b + 2];
                bytes[0] = -1;
                bytes[bytes.length - 1] = -1;
                System.arraycopy(buf, 30 * a, bytes, 1, b);
                if (0 == type) {
                    if (0 != this.mBluetoothUtils.wr_datRW(block, offset + 32 * a, b, bytes)) {
                        return false;
                    }
                } else if (1 == type) {
                    if (0 != this.mBluetoothUtils.wr_dat4442RW(block, offset + 32 * a, b, bytes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            return true;
        }
        byte[] data = new byte[buf.length + 2];
        data[0] = -1;
        data[data.length - 1] = -1;
        System.arraycopy(buf, 0, data, 1, buf.length);
        if (0 == type) {
            int ret = this.mBluetoothUtils.wr_datRW(block, offset, len, data);
            return ret == 0;
        }
        if (1 == type) {
            int ret = this.mBluetoothUtils.wr_dat4442RW(block, offset, len, data);
            return ret == 0;
        }
        return false;
    }

    @Override
    public boolean verifyPwd(Chip chip, int block, byte[] secret) {
        if (chip.chipName == 0) {
            for (int i = 0; i < secret.length; i += 2) {
                if (!this.verify102Pwd(HexDump.toHexString(new byte[]{secret[i], secret[i + 1]}))) continue;
                return true;
            }
            return false;
        }
        if (chip.chipName == 1) {
            for (int i = 0; i < secret.length; i += 3) {
                if (!this.verify4442Pwd(HexDump.toHexString(new byte[]{secret[i], secret[i + 1], secret[i + 2]}))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean changePwd(Chip chip, int block, byte[] oldSecret, byte[] newSecret) {
        if (chip.chipName == 0) {
            return this.change102Pwd(oldSecret, newSecret);
        }
        if (chip.chipName == 1) {
            return this.change4442Pwd(oldSecret, newSecret);
        }
        return true;
    }

    public boolean change102Pwd(byte[] oldKey, byte[] newKey) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !this.verify102Pwd(HexDump.toHexString(oldKey))) {
            return false;
        }
        return this.writecard(0, 10, 2, newKey, 0);
    }

    public boolean change4442Pwd(byte[] oldKey, byte[] newKey) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        if (oldKey != null && !this.verify4442Pwd(HexDump.toHexString(oldKey))) {
            return false;
        }
        return this.writecard(0, 1, 3, newKey, 1);
    }

    @Override
    public Chip getNvlChip() {
        Chip chip = null;
        if (1 != this.mBluetoothUtils.Connect(this.device)) {
            return null;
        }
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int ct = this.mBluetoothUtils.IsCardTyRW();
        if (ct == 11) {
            chip = new Chip(1);
        } else if (ct == 12) {
            chip = new Chip(0);
        }
        if (chip != null) {
            return chip;
        }
        return null;
    }

    public boolean read4442(int zone, int start, int length, byte[] buf) {
        if (this.get4442PwdAttemptCnt() <= 0) {
            return false;
        }
        byte[] bt = this.readcard(zone, start, length);
        if (bt != null) {
            System.arraycopy(bt, 0, buf, 0, bt.length);
            return true;
        }
        return false;
    }

    public boolean read102(int length, byte[] buf, String key) {
        if (this.get102PwdAttemptCnt() <= 0) {
            return false;
        }
        if (key != null && !this.verify102Pwd(key)) {
            return false;
        }
        byte[] bt = new byte[length];
        byte[] bytes = this.readcard(0, 0, 22);
        if (bytes == null) {
            return false;
        }
        System.arraycopy(bytes, 0, bt, 0, 22);
        bytes = this.readcard(1, 22, 70);
        if (bytes == null) {
            return false;
        }
        System.arraycopy(bytes, 0, bt, 22, 70);
        bytes = this.readcard(2, 92, 86);
        if (bytes == null) {
            return false;
        }
        System.arraycopy(bytes, 0, bt, 92, 86);
        if (bt != null) {
            System.arraycopy(bt, 0, buf, 0, bt.length);
            return true;
        }
        return false;
    }

    public byte[] readcard(int zone, int start, int length) {
        byte[] buf = new byte[length];
        if (length > 32) {
            byte[] bytes;
            int a = length / 32;
            int b = length % 32;
            for (int i = 0; i < a; ++i) {
                bytes = this.mBluetoothUtils.rd_datRW(zone, start + 32 * i, 32);
                if (bytes == null && bytes.length != 32) {
                    return null;
                }
                System.arraycopy(bytes, 0, buf, 0 + 32 * i, 32);
            }
            if (b != 0) {
                bytes = this.mBluetoothUtils.rd_datRW(zone, length - 32 * a, b);
                if (bytes == null && bytes.length != b) {
                    return null;
                }
                System.arraycopy(bytes, 0, buf, 32 * a, b);
            }
            return buf;
        }
        buf = this.mBluetoothUtils.rd_datRW(zone, start, length);
        if (buf == null && buf.length != length) {
            return null;
        }
        return buf;
    }

    public boolean verify102Pwd(String key) {
        int ret = this.mBluetoothUtils.cmp_scRW(0, key);
        return ret == 0;
    }

    public boolean verify4442Pwd(String key) {
        int ret = this.mBluetoothUtils.cmp_sc4442RW(0, key);
        return ret == 0;
    }

    public int get4442PwdAttemptCnt() {
        byte[] count = this.mBluetoothUtils.rd_datRW(0, 0, 1);
        if (count.length == 1) {
            if ((count[0] & 7) == 7) {
                return 3;
            }
            if ((count[0] & 6) == 6) {
                return 2;
            }
            if ((count[0] & 4) == 4) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public int get102PwdAttemptCnt() {
        byte[] count = this.mBluetoothUtils.rd_datRW(0, 12, 1);
        if (count.length == 1) {
            if ((count[0] & 0xF0) == 240) {
                return 4;
            }
            if ((count[0] & 0xF0) == 112) {
                return 3;
            }
            if ((count[0] & 0xF0) == 48) {
                return 2;
            }
            if ((count[0] & 0xF0) == 16) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    @Override
    public byte[] resetCPUCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] resetPSAMCard() {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] CPUsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }

    @Override
    public byte[] PSAMsendAPDU(byte[] apdu) {
        byte[] data = new byte[8];
        return data;
    }
}

