/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

public class Chip {
    public static final int CHIP_UNKNWN = -1;
    public static final int CHIP_ERROR_DOUBLE = -2;
    public static final int CHIP_ERROR_WRONG = -3;
    public static final int CHIP_RF = 9;
    public static final int CHIP_102 = 0;
    public static final int CHIP_24C01 = 2;
    public static final int CHIP_24C02 = 3;
    public static final int CHIP_24C16 = 4;
    public static final int CHIP_4442 = 1;
    public static final int CHIP_1608 = 6;
    public static final int CHIP_m1card = 8;
    public static final int CHIP_iccard = 7;
    public static final int CHIP_psam1 = 10;
    public static final int CHIP_psam2 = 11;
    public static final int CHIP_psam3 = 12;
    public static final int BUF_102_SIZE = 178;
    public static final int BUF_4442_SIZE = 256;
    public static final int BUF_24C01_SIZE = 128;
    public static final int BUF_24C02_SIZE = 256;
    public static final int BUF_24C16_SIZE = 256;
    public static final int BUF_1608_SIZE = 640;
    public static final int BUF_m1card_SIZE = 128;
    public static final int BUF_iccard_SIZE = 9;
    public static final int BUF_psam1_SIZE = 8;
    public static final int BUF_psam2_SIZE = 8;
    public static final int BUF_psam3_SIZE = 8;
    public static final int BUF_RF_SIZE = 8;
    public static final int BUF_UNKNWN_SIZE = 8;
    public static final int BUF_DOUBLE_SIZE = 8;
    public static final int BUF_WRONG_SIZE = 8;
    public static final int MAX_BUF_SIZE = 2304;
    public int state;
    public int chipName;
    public String secret = "";
    public String newSecret = "";
    public byte[] buf;
    public int addid;
    public static final int CHIP_4442_PWD_AREA = 0;
    public static final int CHIP_4442_PWD_BYTE = 1;
    public static final int CHIP_4442_PWD_LENGTH = 3;
    public static final int CHIP_4442_CWJS_AREA = 0;
    public static final int CHIP_4442_CWJS_BYTE = 0;
    public static final int CHIP_4442_CWJS_LENGTH = 1;
    public static final int CHIP_4442_MSG_AREA = 2;
    public static final int CHIP_4442_MSG_BYTE = 0;
    public static final int CHIP_102_PWD_AREA = 0;
    public static final int CHIP_102_PWD_BYTE = 10;
    public static final int CHIP_102_PWD_LENGTH = 2;
    public static final int CHIP_102_CWJS_AREA = 0;
    public static final int CHIP_102_CWJS_BYTE = 12;
    public static final int CHIP_102_CWJS_LENGTH = 1;
    public static final int CHIP_102_MSG1_AREA = 0;
    public static final int CHIP_102_MSG1_BYTE = 0;
    public static final int CHIP_102_MSG1_LENGTH = 22;
    public static final int CHIP_102_MSG2_AREA = 1;
    public static final int CHIP_102_MSG2_BYTE = 22;
    public static final int CHIP_102_MSG2_LENGTH = 70;
    public static final int CHIP_102_MSG3_AREA = 2;
    public static final int CHIP_102_MSG3_BYTE = 92;
    public static final int CHIP_102_MSG3_LENGTH = 86;

    public Chip(int chipName) {
        this.chipName = chipName;
        this.secret = null;
        this.newSecret = null;
        if (chipName == 0) {
            this.buf = new byte[178];
        } else if (chipName == 1) {
            this.buf = new byte[256];
        } else if (chipName == 2) {
            this.buf = new byte[128];
        } else if (chipName == 3) {
            this.buf = new byte[256];
        } else if (chipName == 6) {
            this.buf = new byte[640];
        } else if (chipName == 4) {
            this.buf = new byte[256];
        } else if (chipName == 9) {
            this.buf = new byte[8];
        } else if (chipName == -1) {
            this.buf = new byte[8];
        } else if (chipName == -2) {
            this.buf = new byte[8];
        } else if (chipName == -3) {
            this.buf = new byte[8];
        } else if (chipName == 8) {
            this.buf = new byte[128];
        } else if (chipName == 7) {
            this.buf = new byte[9];
        } else if (chipName == 10) {
            this.buf = new byte[8];
        } else if (chipName == 11) {
            this.buf = new byte[8];
        } else if (chipName == 12) {
            this.buf = new byte[8];
        }
    }

    public boolean isBlankChip() {
        if (this.chipName == 0) {
            return this.isEmpty(this.buf, 10, 10);
        }
        if (this.chipName == 1) {
            return this.isEmpty(this.buf, 32, 224);
        }
        if (this.chipName == 2) {
            return this.isEmpty(this.buf, 0, 128);
        }
        if (this.chipName == 3) {
            return this.isEmpty(this.buf, 0, 256);
        }
        if (this.chipName == 4) {
            return this.isEmpty(this.buf, 0, 256);
        }
        if (this.chipName == 6) {
            return this.isEmpty(this.buf, 0, 640);
        }
        if (this.chipName == 8) {
            return this.isEmpty(this.buf, 0, 128);
        }
        return false;
    }

    private boolean isEmpty(byte[] buf, int offset, int len) {
        for (int i = offset; i < offset + len; ++i) {
            if (buf[i] == 255) continue;
            return false;
        }
        return true;
    }

    public static void hexStr2Bytes(byte[] pass, String cscKmm) {
        int i;
        for (i = 0; i < pass.length; ++i) {
            pass[i] = 0;
        }
        cscKmm = cscKmm.toUpperCase();
        for (i = 0; i < cscKmm.length(); ++i) {
            int n = i / 2;
            pass[n] = (byte)(pass[n] + (pass[i / 2] * 16 + Chip.hexChar2Decimal(cscKmm.charAt(i))));
        }
    }

    private static byte hexChar2Decimal(char c) {
        if (c > '9') {
            return (byte)(c - 65 + 10);
        }
        return (byte)(c - 48);
    }

    public String bytes2HexStr(int offset, int len) {
        String s = "";
        for (int i = offset; i < offset + len; ++i) {
            int b = this.buf[i];
            if (b < 0) {
                b += 256;
            }
            s = s + this.dec2HexChr(b / 16) + "" + this.dec2HexChr(b & 0xF);
        }
        return s;
    }

    private char dec2HexChr(int b) {
        if (b > 9) {
            return (char)(b - 10 + 65);
        }
        return (char)(b + 48);
    }

    public String getRegisters() {
        if (this.chipName == 0) {
            return this.bytes2HexStr(0, 178);
        }
        if (this.chipName == 1) {
            return this.bytes2HexStr(0, 256);
        }
        if (this.chipName == 2) {
            return this.bytes2HexStr(0, 128);
        }
        if (this.chipName == 3) {
            return this.bytes2HexStr(0, 256);
        }
        if (this.chipName == 4) {
            return this.bytes2HexStr(0, 256);
        }
        if (this.chipName == 6) {
            return this.bytes2HexStr(0, 128) + "|23272b2f33373b3f|||" + this.bytes2HexStr(384, 256) + "|||||" + this.bytes2HexStr(128, 256) + "|00";
        }
        if (this.chipName == 8) {
            return this.bytes2HexStr(0, 16) + "|" + this.bytes2HexStr(16, 16) + "|" + this.bytes2HexStr(32, 16) + "|" + this.bytes2HexStr(48, 16) + "|" + this.bytes2HexStr(64, 16) + "|" + this.bytes2HexStr(80, 16) + "|" + this.bytes2HexStr(96, 16) + "|" + this.bytes2HexStr(112, 16);
        }
        if (this.chipName == 7) {
            return "";
        }
        throw new IllegalStateException("\u7cfb\u7edf\u72b6\u6001\u9519\u8bef!");
    }

    public String removeDuplicatePass(String cscKmm) {
        if (!(this.chipName != 0 && this.chipName != 1 && this.chipName != 6 || cscKmm.contains("|"))) {
            int keySize = this.chipName == 0 ? 4 : 6;
            String s = "";
            for (int i = 0; i < cscKmm.length(); i += keySize) {
                String pwd = cscKmm.substring(i, i + keySize);
                boolean hasDup = false;
                for (int j = 0; j < s.length(); j += keySize) {
                    String key = s.substring(j, j + keySize);
                    if (!key.equals(pwd)) continue;
                    hasDup = true;
                    break;
                }
                if (hasDup) continue;
                s = s + pwd;
            }
            return s;
        }
        return cscKmm;
    }
}

