/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.reader;

import com.af.plugins.android.ZTchagnan.ReadCard;
import com.af.plugins.android.ZTchagnan.WriCard;
import com.aofeng.hybrid.activity.PreludeActivity;
import com.aofeng.hybrid.pos.device.LDDevice;
import com.aofeng.hybrid.pos.device.ZTDevice;
import com.aofeng.hybrid.pos.reader.CPUSocket;
import com.aofeng.hybrid.pos.reader.Chip;
import com.aofeng.hybrid.pos.reader.Fragment;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.pos.reader.LDNativeReader;
import com.aofeng.hybrid.pos.reader.ZTChangAnReader;
import com.aofeng.hybrid.util.HexDump;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class CardAgent {
    public static final int ERROR_READ_CARD = -1;
    public static final int ERROR_PWD_VERIFY_FAIL = -2;
    public static final int ERROR_BLANK_CARD = -3;
    public static final int ERROR_NETWORK = -4;
    public static final int ERROR_WRITE_CARD = -5;
    public static final int ERROR_NOT_SUPPORTED = -6;
    public static final int ERROR_CLOUD_ERROR = -7;
    public static final int ERROR_PWD_CHANGE_FAIL = -8;
    public static final int ERROR_DOUBLE_CARD = -9;
    public static final int ERROR_NOERROR = 0;
    public static final int ERROR_NOT_USER_CARD = 5;
    public static final int ERROR_HAS_GAS = 7;
    public static final int ERROR_SECRET_BACK = 17;
    public static final int ERROR_LOGIN = -10;
    public static final HashMap<Integer, String> errorMap = new HashMap();
    private byte[] bufPwd = new byte[100];
    private ICardReader reader;
    private String cloudUrl;
    private String socketUrl;

    public void setReader(ICardReader reader) {
        this.reader = reader;
    }

    public ICardReader getReader() {
        return this.reader;
    }

    public String getCloudUrl() {
        return this.cloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.cloudUrl = cloudUrl;
    }

    public String getSocketUrl() {
        return this.socketUrl;
    }

    public void setSocketUrl(String socketUrl) {
        this.socketUrl = socketUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read() {
        if (PreludeActivity.card.getReader() instanceof LDNativeReader && !LDDevice.login()) {
            return this.getReadErrMsg(-10);
        }
        Chip chip = this.reader.getNvlChip();
        if (chip == null) {
            return this.getReadErrMsg(-6);
        }
        if (!this.reader.openDevice(chip)) {
            return this.getReadErrMsg(-6);
        }
        if (chip.chipName == -1) {
            return this.getReadErrMsg(-1);
        }
        if (chip.chipName == -3) {
            return this.getReadErrMsg(-6);
        }
        if (chip.chipName == -2) {
            return this.getReadErrMsg(-9);
        }
        if (chip.chipName == 9 && PreludeActivity.card.getReader() instanceof ZTChangAnReader) {
            return this.readCaCpu();
        }
        try {
            String result;
            String pass;
            chip.addid = 16;
            boolean ret = this.reader.read(chip);
            if (!ret) {
                String string2 = this.getReadErrMsg(-1);
                return string2;
            }
            if (chip.isBlankChip()) {
                String string3 = this.getReadErrMsg(-3);
                return string3;
            }
            if (chip.chipName == 0) {
                pass = this.get102Pass(chip, 1);
                if (chip.state != 0) {
                    String string4 = this.getReadErrMsg(chip.state);
                    return string4;
                }
                chip.secret = pass;
                ret = this.reader.read(chip);
                if (!ret) {
                    String string5 = this.getReadErrMsg(-1);
                    return string5;
                }
            }
            if (chip.chipName == 6) {
                pass = this.get1608Pass(chip, 1);
                if (chip.state != 0) {
                    String string6 = this.getReadErrMsg(chip.state);
                    return string6;
                }
                chip.secret = pass;
                ret = this.reader.read(chip);
                if (!ret) {
                    String string7 = this.getReadErrMsg(-1);
                    return string7;
                }
            }
            if (chip.chipName == 8) {
                pass = this.getM1Pass(chip, 1);
                if (chip.state != 0) {
                    String string8 = this.getReadErrMsg(chip.state);
                    return string8;
                }
                chip.secret = pass;
                chip.addid = 20;
                ret = this.reader.read(chip);
                if (!ret) {
                    String string9 = this.getReadErrMsg(-1);
                    return string9;
                }
            }
            if ((result = this.cloudRead(chip)) == null) {
                String string10 = this.getReadErrMsg(-4);
                return string10;
            }
            String string11 = this.getReadErrMsg(0, result);
            return string11;
        }
        finally {
            this.reader.closeDevice(chip);
            if (PreludeActivity.card.getReader() instanceof LDNativeReader) {
                LDDevice.logout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sell(JSONObject params) {
        if (PreludeActivity.card.getReader() instanceof LDNativeReader && !LDDevice.login()) {
            return this.getWriteErrMsg(-10);
        }
        Chip chip = this.reader.getNvlChip();
        if (chip == null) {
            return this.getWriteErrMsg(-6);
        }
        if (!this.reader.openDevice(chip)) {
            return this.getWriteErrMsg(-6);
        }
        if (chip.chipName == -1) {
            return this.getWriteErrMsg(-1);
        }
        if (chip.chipName == -3) {
            return this.getWriteErrMsg(-6);
        }
        if (chip.chipName == -2) {
            return this.getWriteErrMsg(-9);
        }
        if (chip.chipName == 9 && PreludeActivity.card.getReader() instanceof ZTChangAnReader) {
            return this.writeCaCpu(params);
        }
        try {
            chip.addid = 16;
            boolean ret = this.reader.read(chip);
            if (!ret) {
                String string2 = this.getWriteErrMsg(-1);
                return string2;
            }
            if (chip.isBlankChip()) {
                String string3 = this.getWriteErrMsg(-3);
                return string3;
            }
            if (chip.chipName == 1) {
                params.put("CardType", (Object)"1");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string4 = this.sell(chip, params);
                return string4;
            }
            if (chip.chipName == 0) {
                params.put("CardType", (Object)"0");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string5 = this.sell102(chip, params);
                return string5;
            }
            if (chip.chipName == 2) {
                params.put("CardType", (Object)"2");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string6 = this.sell(chip, params);
                return string6;
            }
            if (chip.chipName == 3) {
                params.put("CardType", (Object)"3");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string7 = this.sell(chip, params);
                return string7;
            }
            if (chip.chipName == 6) {
                params.put("CardType", (Object)"6");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string8 = this.sell1608(chip, params);
                return string8;
            }
            if (chip.chipName == 7) {
                params.put("CardType", (Object)"7");
                params.put("opid", 1);
                params.put("operatetype", 7);
                String string9 = this.sell(chip, params);
                return string9;
            }
            if (chip.chipName == 8) {
                params.put("CardType", (Object)"8");
                params.put("opid", 1);
                params.put("operatetype", 2);
                String string10 = this.sellM1card(chip, params);
                return string10;
            }
            String string11 = this.getWriteErrMsg(-6);
            return string11;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                String string12 = this.getWriteErrMsg(-4);
                return string12;
            }
            String string13 = this.getWriteErrMsg(-5);
            return string13;
        }
        finally {
            this.reader.closeDevice(chip);
        }
    }

    private String readCaCpu() {
        ReadCard rc = new ReadCard();
        ZTDevice.careader.readCard(rc);
        if (rc != null) {
            return "{\"code\":200,\"msg\":{\"CardID\":\"" + rc.cardNum + "\",\"Factory\":\"ChanganCpu\",\"Times\":" + rc.buyCount + ",\"Money\":" + rc.remainAmount + ",\"Gas\":0.0,\"CardType\":\"" + rc.cardType + "\"}}";
        }
        return this.getWriteErrMsg(-6);
    }

    private String writeCaCpu(JSONObject params) {
        ReadCard rc = new ReadCard();
        ZTDevice.careader.readCard(rc);
        if (rc == null) {
            return this.getWriteErrMsg(-6);
        }
        try {
            WriCard wc = new WriCard();
            wc.amount = Integer.parseInt(params.getString("money"));
            wc.buyCount = Integer.parseInt(params.getString("cs"));
            wc.cardNum = params.getString("kh");
            wc.cardType = Integer.parseInt(params.getString("klx"));
            wc.serverIP = params.getString("prmt_server");
            wc.wriParm = params.getString("card_params");
            rc = new ReadCard();
            int ret = ZTDevice.careader.writeCard(rc, wc);
            if (ret == 0) {
                return this.getWriteErrMsg(0, "212");
            }
            if (ret == 17) {
                return this.getWriteErrMsg(-6);
            }
            if (ret == 7) {
                return this.getWriteErrMsg(-6);
            }
            if (ret == 5) {
                return this.getWriteErrMsg(-5);
            }
            return this.getWriteErrMsg(-5);
        }
        catch (Exception e) {
            return this.getWriteErrMsg(-6);
        }
    }

    private String sell1608(Chip chip, JSONObject params) throws Exception {
        String pass = this.get1608Pass(chip, 1);
        if (chip.state != 0) {
            return this.getReadErrMsg(chip.state);
        }
        chip.secret = pass;
        boolean r = this.reader.read(chip);
        if (!r) {
            return this.getWriteErrMsg(-1);
        }
        return this.sell(chip, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String issue(JSONObject params) {
        Chip chip = this.reader.getNvlChip();
        if (chip == null) {
            return this.getWriteErrMsg(-6);
        }
        if (!this.reader.openDevice(chip)) {
            return this.getWriteErrMsg(-6);
        }
        try {
            boolean ret = this.reader.read(chip);
            if (!ret) {
                String string2 = this.getWriteErrMsg(-1);
                return string2;
            }
            if (chip.chipName == 1) {
                params.put("CardType", (Object)"1");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string3 = this.issue(chip, params);
                return string3;
            }
            if (chip.chipName == 0) {
                params.put("CardType", (Object)"0");
                params.put("opid", 1);
                params.put("operatetype", 2);
                params.put("CscKmm", (Object)"F0F0");
                String string4 = this.issue102(chip, params);
                return string4;
            }
            if (chip.chipName == 3) {
                params.put("CardType", (Object)"3");
                params.put("opid", 1);
                params.put("operatetype", 1);
                String string5 = this.issue(chip, params);
                return string5;
            }
            String string6 = this.getWriteErrMsg(-6);
            return string6;
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                String string7 = this.getWriteErrMsg(-4);
                return string7;
            }
            String string8 = this.getWriteErrMsg(-5);
            return string8;
        }
        finally {
            this.reader.closeDevice(chip);
        }
    }

    private String issue102(Chip chip, JSONObject params) throws Exception {
        String pass = this.get102Pass2(chip, 0);
        if (chip.state != 0) {
            return this.getWriteErrMsg(chip.state);
        }
        chip.secret = pass;
        boolean ret = this.reader.read(chip);
        if (!ret) {
            return this.getWriteErrMsg(-1);
        }
        return this.issue(chip, params);
    }

    private String issue(Chip chip, JSONObject params) throws Exception {
        String url = this.cloudUrl + "WriteNewCard/" + params.get("factory") + "/" + params.get("kmm") + "/" + params.get("kzt") + "/" + params.get("kh") + "/" + params.get("dqdm") + "/" + params.get("yhh") + "/" + params.get("tm") + "/" + params.get("ql") + "/" + params.get("csql") + "/" + params.get("ccsql") + "/" + params.get("cs") + "/" + params.get("ljgql") + "/" + params.get("bkcs") + "/" + params.get("ljyql") + "/" + params.get("bjql") + "/" + params.get("czsx") + "/" + params.get("tzed") + "/" + params.get("sqrq") + "/" + params.get("cssqrq") + "/" + params.get("oldprice") + "/" + params.get("newprice") + "/" + params.get("sxrq") + "/" + params.get("sxbj") + "/" + params.get("klx") + "/" + params.get("meterid");
        params.put("CardData", (Object)chip.getRegisters());
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(params.toString().replace("\n", "").replace("\r", "").replace(" ", "").replace("\t", ""), "UTF8"));
        DefaultHttpClient hc = new DefaultHttpClient();
        HttpResponse response = hc.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            return this.getWriteErrMsg(-4);
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        JSONObject obj = new JSONObject(result);
        if (!obj.isNull("Exception")) {
            return this.getWriteErrMsg(-7);
        }
        if (!obj.isNull("Err")) {
            return this.getWriteErrMsg(-4);
        }
        if (obj.isNull("CscKmm")) {
            return this.getWriteErrMsg(-7);
        }
        if (chip.chipName != 0 || chip.secret == null) {
            chip.secret = chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        chip.newSecret = obj.getString("WscKmm");
        String akmm = obj.getString("Kmm");
        if (!(chip.chipName == 0 && chip.secret != null || chip.secret == null || chip.secret.equals("000000") || this.reader.verifyPwd(chip, 0, HexDump.hexStringToByteArray(chip.secret)))) {
            return this.getWriteErrMsg(-2);
        }
        String hexToWrite = obj.getString("Kdata");
        String hexOnCard = chip.getRegisters();
        ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
        for (Fragment f : segments) {
            boolean r = this.reader.write(chip, 0, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), null);
            if (r) continue;
            return this.getWriteErrMsg(-5);
        }
        if (this.needChangePwd(chip) && !this.reader.changePwd(chip, 0, null, HexDump.hexStringToByteArray(this.getNewPwd(chip)))) {
            return this.getWriteErrMsg(-8);
        }
        return this.getWriteErrMsg(0, akmm);
    }

    private String sell102(Chip chip, JSONObject params) throws Exception {
        String pass = this.get102Pass(chip, 0);
        if (chip.state != 0) {
            return this.getWriteErrMsg(chip.state);
        }
        chip.secret = pass;
        boolean ret = this.reader.read(chip);
        if (!ret) {
            return this.getWriteErrMsg(-1);
        }
        return this.sell(chip, params);
    }

    private static String get1608AreaPwd(int area, int type, String[] pwd) {
        if (type == 0) {
            return pwd[(area + 1) * 2 - 1];
        }
        if (type == 1) {
            return pwd[(area + 1) * 2 - 2];
        }
        return null;
    }

    private String writeWX1608(JSONObject obj, Chip chip) throws Exception {
        String[] writeDatas = obj.getString("Kdata").toUpperCase().split("\\|");
        String[] cardDatas = chip.getRegisters().split("\\|");
        String[] secrets = chip.secret.split("\\|");
        for (int i = 7; i >= 0; --i) {
            String hexToWrite = writeDatas[i + 2];
            String hexOnCard = cardDatas[i + 2];
            String secret = CardAgent.get1608AreaPwd(i, 1, secrets);
            if (hexToWrite.equals("") || hexOnCard.equals("") || secret.equals("")) continue;
            ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
            for (Fragment f : segments) {
                boolean r = this.reader.write(chip, i, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), HexDump.hexStringToByteArray(chip.removeDuplicatePass(secret)));
                if (r) continue;
                return this.getWriteErrMsg(-5);
            }
        }
        return this.getWriteErrMsg(0, obj.getString("Kmm"));
    }

    private String get1608Pass(Chip chip, int opid) {
        try {
            chip.state = 0;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\" : \"6\",\"operatetype\":\"0\",\"cardinfo\" :\"2CAA55A070F8F7281608FFFF5719369223272B2F33373B3FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF0000000000000000FFFFFFFFFFFFFFFFFF000000FF000000FF000000FF000000FF000000FC000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000FF000000|23272b2f33373b3f||||||||" + chip.bytes2HexStr(0, 256) + "|00\",\"opid\":\"" + opid + "\", \"Wsckmm\":\"f0f0\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF8"));
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(result);
            if (obj.isNull("CscKmm")) {
                chip.state = -7;
                return null;
            }
            return obj.getString("CscKmm");
        }
        catch (Exception e) {
            chip.state = -4;
            return null;
        }
    }

    private String sell(Chip chip, JSONObject params) throws Exception {
        String url = this.cloudUrl;
        if (!params.has("ulen") || params.getInt("ulen") == 25) {
            url = url + "WriteGasCard/" + params.get("factory") + "/" + params.get("kmm") + "/" + params.get("kzt") + "/" + params.get("kh") + "/" + params.get("dqdm") + "/" + params.get("yhh") + "/" + params.get("tm") + "/" + params.get("ql") + "/" + params.get("csql") + "/" + params.get("ccsql") + "/" + params.get("cs") + "/" + params.get("ljgql") + "/" + params.get("bkcs") + "/" + params.get("ljyql") + "/" + params.get("bjql") + "/" + params.get("czsx") + "/" + params.get("tzed") + "/" + params.get("sqrq") + "/" + params.get("cssqrq") + "/" + params.get("oldprice") + "/" + params.get("newprice") + "/" + params.get("sxrq") + "/" + params.get("sxbj") + "/" + params.get("klx") + "/" + params.get("meterid");
        } else if (params.getInt("ulen") == 18) {
            url = url + "WriteGasCard/" + params.get("factory") + "/" + params.get("kmm") + "/" + params.get("kh") + "/" + params.get("dqdm") + "/" + params.get("ql") + "/" + params.get("csql") + "/" + params.get("ccsql") + "/" + params.get("cs") + "/" + params.get("ljgql") + "/" + params.get("bjql") + "/" + params.get("czsx") + "/" + params.get("tzed") + "/" + params.get("sqrq") + "/" + params.get("cssqrq") + "/" + params.get("oldprice") + "/" + params.get("newprice") + "/" + params.get("sxrq") + "/" + params.get("sxbj");
        }
        params.put("CardData", (Object)chip.getRegisters());
        if (chip.chipName == 7) {
            params.put("GUID", (Object)UUID.randomUUID());
            params.put("socket_url", (Object)this.getSocketUrl());
            CPUSocket CPUSocket2 = new CPUSocket(params.toString());
            CPUSocket2.start();
        }
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)new StringEntity(params.toString().replace("\n", "").replace("\r", "").replace(" ", "").replace("\t", ""), "UTF8"));
        DefaultHttpClient hc = new DefaultHttpClient();
        HttpResponse response = hc.execute((HttpUriRequest)httpPost);
        if (response.getStatusLine().getStatusCode() != 200) {
            return this.getWriteErrMsg(-4);
        }
        String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
        JSONObject obj = new JSONObject(result);
        if (!obj.isNull("Exception")) {
            return this.getWriteErrMsg(-7);
        }
        if (!obj.isNull("Err")) {
            return this.getWriteErrMsg(-4);
        }
        if (obj.isNull("CscKmm")) {
            return this.getWriteErrMsg(-7);
        }
        if (chip.chipName != 8) {
            chip.secret = chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        chip.newSecret = obj.getString("WscKmm");
        String akmm = obj.getString("Kmm");
        if (chip.chipName == 6) {
            return this.writeWX1608(obj, chip);
        }
        if (chip.chipName == 8) {
            return this.writeM1card(obj, chip);
        }
        if (chip.chipName == 3 || chip.chipName == 2) {
            boolean r = this.reader.write(chip, 0, 0, chip.buf.length, HexDump.hexStringToByteArray(obj.getString("Kdata").substring(0, chip.buf.length * 2)), null);
            if (!r) {
                return this.getWriteErrMsg(-5);
            }
            return this.getWriteErrMsg(0, akmm);
        }
        if (!(chip.secret == null || chip.secret.equals("000000") || chip.secret.equals("") || this.reader.verifyPwd(chip, 0, HexDump.hexStringToByteArray(chip.secret)))) {
            return this.getWriteErrMsg(-2);
        }
        String hexToWrite = obj.getString("Kdata");
        String hexOnCard = chip.getRegisters();
        ArrayList<Fragment> segments = Fragment.FindFragment(hexToWrite, hexOnCard);
        for (Fragment f : segments) {
            boolean r = this.reader.write(chip, 0, f.offset, f.length, HexDump.hexStringToByteArray(hexToWrite.substring(f.offset * 2, (f.offset + f.length) * 2)), null);
            if (r) continue;
            return this.getWriteErrMsg(-5);
        }
        if (this.needChangePwd(chip) && !this.reader.changePwd(chip, 0, null, HexDump.hexStringToByteArray(this.getNewPwd(chip)))) {
            return this.getWriteErrMsg(-8);
        }
        return this.getWriteErrMsg(0, akmm);
    }

    private String getNewPwd(Chip chip) {
        if (chip.chipName == 1) {
            return chip.newSecret.substring(0, 6);
        }
        if (chip.chipName == 0) {
            return chip.newSecret.substring(0, 4);
        }
        return chip.newSecret;
    }

    private boolean needChangePwd(Chip chip) {
        if (chip.newSecret != null && !chip.newSecret.equals("") && !chip.newSecret.equals("nn")) {
            if (chip.chipName == 1) {
                return chip.newSecret.length() >= 6 && !chip.newSecret.startsWith("000000");
            }
            if (chip.chipName == 0) {
                return chip.newSecret.length() >= 4 && !chip.newSecret.startsWith("0000");
            }
            return false;
        }
        return false;
    }

    private String getWriteErrMsg(int errCode) {
        return this.getWriteErrMsg(errCode, null);
    }

    private String getWriteErrMsg(int errCode, String kmm) {
        if (PreludeActivity.card.getReader() instanceof LDNativeReader) {
            LDDevice.logout();
        }
        if (errCode == 0) {
            return "{\"code\":200, \"msg\":{\"Err\":null,\"Exception\":null,\"Kmm\":\"" + kmm + "\"}}";
        }
        String json = "{\"code\":500, \"msg\":{\"Err\":\"";
        String msg = "\u672a\u77e5\u9519\u8bef\uff01";
        if (errorMap.containsKey(errCode)) {
            msg = errorMap.get(errCode);
        }
        json = json + msg + "\",\"Exception\":\"" + msg + "\"}}";
        return json;
    }

    public String getReadErrMsg(int errCode) {
        return this.getReadErrMsg(errCode, null);
    }

    public String getReadErrMsg(int errCode, String result) {
        if (PreludeActivity.card.getReader() instanceof LDNativeReader) {
            LDDevice.logout();
        }
        if (errCode == 0) {
            return "{\"code\":200, \"msg\":" + result + "}";
        }
        String json = "{\"code\":500, \"msg\":";
        json = errorMap.containsKey(errCode) ? json + "\"" + errorMap.get(errCode) + "\"}" : json + "\"\u672a\u77e5\u9519\u8bef\uff01\"}";
        return json;
    }

    private String get102Pass(Chip chip, int opid) {
        try {
            chip.state = 0;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\" : \"0\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 22) + "\",\"opid\":\"" + opid + "\", \"Wsckmm\":\"f0f0\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF8"));
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(result);
            if (obj.isNull("CscKmm")) {
                chip.state = -7;
                return null;
            }
            return chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        catch (Exception e) {
            chip.state = -4;
            return null;
        }
    }

    private String get102Pass2(Chip chip, int opid) {
        try {
            chip.state = 0;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\" : \"0\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 22) + "\",\"opid\":\"" + opid + "\", \"Wsckmm\":\"f0f0\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF8"));
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(result);
            if (obj.isNull("CscKmm")) {
                obj.put("CscKmm", (Object)"f0f0");
            }
            return chip.removeDuplicatePass(obj.getString("CscKmm"));
        }
        catch (Exception e) {
            chip.state = -4;
            return null;
        }
    }

    private String cloudRead(Chip chip) {
        try {
            DefaultHttpClient hc;
            HttpResponse response;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\":\"" + chip.chipName + "\",\"operatetype\":\"" + (chip.chipName == 0 ? 2 : 1) + "\",\"cardinfo\":\"" + chip.getRegisters() + "\",\"opid\":\"1\"";
            if (0 == chip.chipName) {
                body = body + ", \"Wsckmm\":\"f0f0\"";
            }
            if (chip.chipName == 7) {
                body = body + ",\"GUID\" :\"" + UUID.randomUUID() + "\"";
                body = body + ",\"socket_url\" :\"" + this.getSocketUrl() + "\"";
            }
            body = body + "}";
            httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF8"));
            if (chip.chipName == 7) {
                CPUSocket CPUSocket2 = new CPUSocket(body);
                CPUSocket2.start();
            }
            if ((response = (hc = new DefaultHttpClient()).execute((HttpUriRequest)httpPost)).getStatusLine().getStatusCode() != 200) {
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(result);
            if (!obj.isNull("Err")) {
                return null;
            }
            if (!obj.isNull("Exception")) {
                return null;
            }
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getM1Pass(Chip chip, int opid) {
        try {
            chip.state = 0;
            HttpPost httpPost = new HttpPost(this.cloudUrl + "ReadCard");
            String body = "{\"CardType\" : \"8\",\"operatetype\":\"0\",\"cardinfo\" :\"" + chip.bytes2HexStr(0, 16) + "|" + chip.bytes2HexStr(16, 16) + "|" + chip.bytes2HexStr(32, 16) + "|" + chip.bytes2HexStr(48, 16) + "\",\"opid\":\"" + opid + "\", \"Wsckmm\":\"fffffffffffff\"}";
            httpPost.setEntity((HttpEntity)new StringEntity(body, "UTF8"));
            DefaultHttpClient hc = new DefaultHttpClient();
            HttpResponse response = hc.execute((HttpUriRequest)httpPost);
            if (response.getStatusLine().getStatusCode() != 200) {
                chip.state = -4;
                return null;
            }
            String result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF8");
            JSONObject obj = new JSONObject(result);
            if (obj.isNull("CscKmm")) {
                chip.state = -7;
                return null;
            }
            return obj.getString("CscKmm");
        }
        catch (Exception e) {
            chip.state = -4;
            return null;
        }
    }

    private String sellM1card(Chip chip, JSONObject params) throws Exception {
        String pass = this.getM1Pass(chip, 1);
        if (chip.state != 0) {
            return this.getReadErrMsg(chip.state);
        }
        chip.secret = pass;
        chip.addid = 20;
        boolean r = this.reader.read(chip);
        if (!r) {
            return this.getWriteErrMsg(-1);
        }
        return this.sell(chip, params);
    }

    private String writeM1card(JSONObject obj, Chip chip) throws Exception {
        String[] writeDatas = obj.getString("Kdata").toUpperCase().split("\\|");
        int i = 0;
        int block = 4;
        int keyoffset = 0;
        for (String f : writeDatas) {
            block = 4;
            if (i == 3 || i == 7) {
                block = 3;
            }
            if (i < 4) {
                chip.addid = 16 + i;
                keyoffset = 4;
            } else {
                chip.addid = 16 + i;
                keyoffset = 5;
            }
            boolean r = this.reader.write(chip, block, keyoffset, 0, HexDump.hexStringToByteArray(f), null);
            if (!r) {
                return this.getWriteErrMsg(-5);
            }
            ++i;
        }
        return this.getWriteErrMsg(0, obj.getString("Kmm"));
    }

    static {
        errorMap.put(-1, "\u8bfb\u5361\u9519\uff01");
        errorMap.put(-2, "\u5bc6\u7801\u6821\u9a8c\u9519\uff01");
        errorMap.put(-3, "\u7a7a\u767d\u5361\uff01");
        errorMap.put(-4, "\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u71c3\u6c14\u5361\uff0c\u6216\u68c0\u67e5\u7f51\u7edc\u8fde\u63a5\uff01");
        errorMap.put(-5, "\u5199\u5361\u9519\uff01");
        errorMap.put(-6, "\u5361\u672a\u63d2\u597d\u6216\u4e0d\u652f\u6301\u7684\u5361\u578b\uff01");
        errorMap.put(-7, "\u5361\u4e91\u670d\u52a1\u51fa\u9519\uff01");
        errorMap.put(-8, "\u4fee\u6539\u5bc6\u7801\u9519\u8bef\uff01");
        errorMap.put(-9, "\u68c0\u6d4b\u5230\u4e24\u5f20\u5361\uff0c\u8bf7\u786e\u8ba4\u786e\u8ba4\u71c3\u6c14\u5361\u5e76\u79fb\u9664\u53e6\u4e00\u5f20\u5361\u7247\uff01");
        errorMap.put(5, "\u4e0d\u662f\u7528\u6237\u5361");
        errorMap.put(7, "\u5361\u4e0a\u6709\u5269\u4f59\u6c14\u91cf\uff01");
        errorMap.put(17, "\u52a0\u5bc6\u673a\u8fd4\u56de\u9519\u8bef");
        errorMap.put(-10, "\u8bbe\u5907\u767b\u9646\u5931\u8d25");
    }
}

