/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import com.aofeng.hybrid.pos.device.ZTDevice;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.szzt.sdk.device.aidl.IPrinterListener;
import org.json.JSONArray;
import org.json.JSONObject;

public class ZTPrinter
implements AfPrinter {
    public static int OK = 1;
    public static int NO_PAPER = 0;
    public static int LOWVOL = 4;
    public static int OVERHEAT = 3;

    @Override
    public boolean openPrinter() {
        int ret = ZTDevice.mPrinter.open();
        return ret >= 0;
    }

    @Override
    public boolean closePrinter() {
        int ret = ZTDevice.mPrinter.close();
        return ret >= 0;
    }

    @Override
    public int getPrinterState() {
        int status = ZTDevice.mPrinter.getStatus();
        return status;
    }

    private static int ConvertFontSize(JSONObject json) {
        try {
            if (json.has("fontsize")) {
                int fonzise = json.getInt("fontsize");
                if (fonzise == 1) {
                    return 1;
                }
                if (fonzise == 2) {
                    return 2;
                }
                if (fonzise == 3) {
                    return 3;
                }
                if (fonzise == 4) {
                    return 4;
                }
                return 2;
            }
            return 2;
        }
        catch (Exception e) {
            return 2;
        }
    }

    private static int ConvertAlign(JSONObject json) {
        try {
            if (json.has("align")) {
                String align = json.getString("align").toUpperCase();
                if ("CENTER".equals(align)) {
                    return 2;
                }
                if ("RIGHT".equals(align)) {
                    return 4;
                }
                return 1;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    private static boolean ConvertBold(JSONObject json) {
        try {
            if (json.has("isbold")) {
                return json.getBoolean("isbold");
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static int feedPageValue(JSONObject json) {
        try {
            if (json.has("value")) {
                return json.getInt("value");
            }
            return 4;
        }
        catch (Exception e) {
            return 4;
        }
    }

    private static int feedPageUnit(JSONObject json) {
        try {
            if (json.has("unit")) {
                String unit = json.getString("unit").toUpperCase();
                if ("LINE".equals(unit)) {
                    return 0;
                }
                return 1;
            }
            return 1;
        }
        catch (Exception e) {
            return 1;
        }
    }

    @Override
    public int print(String param) {
        int res = 1;
        boolean isopen = this.openPrinter();
        try {
            if (isopen) {
                JSONArray arry = new JSONArray(param);
                if (arry.length() > 0) {
                    for (int i = 0; i < arry.length(); ++i) {
                        JSONObject json = arry.getJSONObject(i);
                        if (json.getInt("type") == 1) {
                            ZTDevice.mPrinter.addBarCode(json.getString("text"));
                            continue;
                        }
                        if (json.getInt("type") == 2) {
                            ZTDevice.mPrinter.addQrCode(json.getString("text"));
                            continue;
                        }
                        if (json.getInt("type") == 3) {
                            ZTDevice.mPrinter.addStr(json.getString("text"), ZTPrinter.ConvertFontSize(json), ZTPrinter.ConvertBold(json), ZTPrinter.ConvertAlign(json));
                            continue;
                        }
                        if (json.getInt("type") == 4) {
                            ZTDevice.mPrinter.addFeedPaper(ZTPrinter.feedPageValue(json), ZTPrinter.feedPageUnit(json));
                            continue;
                        }
                        ZTDevice.mPrinter.addStr(json.getString("text"), ZTPrinter.ConvertFontSize(json), ZTPrinter.ConvertBold(json), ZTPrinter.ConvertAlign(json));
                    }
                    int ret = ZTDevice.mPrinter.start((IPrinterListener)new IPrinterListener.Stub(){

                        public void PrinterNotify(int retCode) {
                        }
                    });
                    if (ret == -1) {
                        res = this.getPrinterState();
                    }
                    if (!this.closePrinter()) {
                        ZTDevice.mPrinter.close();
                    }
                } else {
                    res = -112;
                }
            }
        }
        catch (Exception e) {
            res = -1;
        }
        return res;
    }
}

