/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import com.aofeng.hybrid.pos.device.LDDevice;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.landicorp.android.eptapi.device.Printer;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.utils.QrCode;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LDPrinter
implements AfPrinter {
    private Printer.Progress progress;
    private List<Printer.Step> stepList;

    @Override
    public boolean openPrinter() {
        return true;
    }

    @Override
    public boolean closePrinter() {
        return true;
    }

    @Override
    public int getPrinterState() {
        int status;
        try {
            status = Printer.getInstance().getStatus();
        }
        catch (RequestException e) {
            status = 255;
        }
        return status;
    }

    @Override
    public int print(String param) {
        if (!LDDevice.login()) {
            return -112;
        }
        int ret = this.getPrinterState();
        if (ret != 0) {
            return this.ConvertError(ret);
        }
        this.stepList = new ArrayList<Printer.Step>();
        try {
            JSONArray arry = new JSONArray(param);
            if (arry.length() > 0) {
                for (int i = 0; i < arry.length(); ++i) {
                    JSONObject json = arry.getJSONObject(i);
                    if (json.getInt("type") == 1) {
                        this.addBarcode(json);
                        continue;
                    }
                    if (json.getInt("type") == 2) {
                        this.addQRcode(json);
                        continue;
                    }
                    if (json.getInt("type") == 3) {
                        this.addText(json);
                        continue;
                    }
                    if (json.getInt("type") != 4) continue;
                    this.feedLine(json);
                }
            }
            this.progress = new Printer.Progress(){

                public void doPrint(Printer printer) throws Exception {
                }

                public void onFinish(int error) {
                    LDPrinter.this.stepList.clear();
                }

                public void onCrash() {
                    LDPrinter.this.stepList.clear();
                }
            };
            for (Printer.Step step : this.stepList) {
                this.progress.addStep(step);
            }
            this.progress.start();
            ret = 1;
        }
        catch (JSONException e) {
            ret = -1;
        }
        catch (RequestException e) {
            ret = -100;
        }
        LDDevice.logout();
        return ret;
    }

    private int ConvertError(int error) {
        switch (error) {
            case 248: {
                return 4100;
            }
            case 245: {
                return 4101;
            }
            case 247: {
                return 6;
            }
            case 229: {
                return 4100;
            }
            case 242: {
                return 5;
            }
            case 224: {
                return 7;
            }
            case 227: {
                return 9;
            }
            case 225: {
                return 4;
            }
            case 251: {
                return 2;
            }
            case 246: {
                return 4100;
            }
            case 0: {
                return 1;
            }
            case 243: {
                return 4102;
            }
            case 240: {
                return 0;
            }
            case 244: {
                return 0;
            }
            case 238: {
                return 5;
            }
            case 252: {
                return 2;
            }
            case 230: {
                return 6;
            }
            case 177: {
                return -112;
            }
        }
        return -110;
    }

    public void addText(final JSONObject json) {
        this.stepList.add(new Printer.Step(){

            public void doPrint(Printer printer) throws Exception {
                printer.setAutoTrunc(false);
                Printer.Format format = new Printer.Format();
                Printer.Alignment alignment = Printer.Alignment.LEFT;
                if (json.has("fontsize")) {
                    int fonzise = json.getInt("fontsize");
                    if (fonzise == 1) {
                        format.setAscScale(Printer.Format.ASC_SC1x1);
                        format.setAscSize(Printer.Format.ASC_DOT16x8);
                        format.setHzScale(Printer.Format.HZ_SC1x1);
                        format.setHzSize(Printer.Format.HZ_DOT16x16);
                    } else if (fonzise == 3) {
                        format.setAscScale(Printer.Format.ASC_SC2x2);
                        format.setAscSize(Printer.Format.ASC_DOT16x8);
                        format.setHzScale(Printer.Format.HZ_SC2x2);
                        format.setHzSize(Printer.Format.HZ_DOT16x16);
                    } else if (fonzise == 4) {
                        format.setAscScale(Printer.Format.ASC_SC2x2);
                        format.setAscSize(Printer.Format.ASC_DOT24x12);
                        format.setHzScale(Printer.Format.HZ_SC2x2);
                        format.setHzSize(Printer.Format.HZ_DOT24x24);
                    } else {
                        format.setAscScale(Printer.Format.ASC_SC1x1);
                        format.setAscSize(Printer.Format.ASC_DOT24x12);
                        format.setHzScale(Printer.Format.HZ_SC1x1);
                        format.setHzSize(Printer.Format.HZ_DOT24x24);
                    }
                }
                if (json.has("align")) {
                    String align = json.getString("align").toUpperCase();
                    alignment = "CENTER".equals(align) ? Printer.Alignment.CENTER : ("RIGHT".equals(align) ? Printer.Alignment.RIGHT : Printer.Alignment.LEFT);
                }
                printer.setFormat(format);
                printer.printText(alignment, json.getString("text") + "\n");
            }
        });
    }

    public void addBarcode(final JSONObject json) {
        this.stepList.add(new Printer.Step(){

            public void doPrint(Printer printer) throws Exception {
                printer.printBarCode(json.getString("text"));
            }
        });
    }

    public void addQRcode(final JSONObject json) {
        this.stepList.add(new Printer.Step(){

            public void doPrint(Printer printer) throws Exception {
                printer.printQrCode(Printer.Alignment.CENTER, new QrCode(json.getString("text"), 1), 200);
            }
        });
    }

    public void feedLine(final JSONObject json) {
        this.stepList.add(new Printer.Step(){

            public void doPrint(Printer printer) throws Exception {
                if (json.has("value")) {
                    printer.feedLine(json.getInt("value"));
                } else {
                    printer.feedLine(3);
                }
            }
        });
    }
}

