/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import android.os.RemoteException;
import com.aofeng.hybrid.pos.device.CTDevice;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.centerm.smartpos.aidl.printer.AidlPrinterStateChangeListener;
import com.centerm.smartpos.aidl.printer.PrintDataObject;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CTPrinter
implements AfPrinter {
    private AidlPrinterStateChangeListener callback = new PrinterCallback();

    @Override
    public boolean openPrinter() {
        return true;
    }

    @Override
    public boolean closePrinter() {
        return true;
    }

    @Override
    public int getPrinterState() {
        int state = -1;
        try {
            state = CTDevice.printer.getPrinterState();
        }
        catch (RemoteException e) {
            return -1;
        }
        return state;
    }

    @Override
    public int print(String param) {
        int res = 0;
        ArrayList list = new ArrayList();
        try {
            JSONArray arry = new JSONArray(param);
            if (arry.length() > 0) {
                for (int i = 0; i < arry.length(); ++i) {
                    JSONObject json = arry.getJSONObject(i);
                    if (json.getInt("type") == 1) {
                        res = CTPrinter.printBarCode(json);
                        continue;
                    }
                    if (json.getInt("type") == 2) {
                        res = CTPrinter.printQrCode(json);
                        continue;
                    }
                    if (json.getInt("type") == 3) {
                        res = CTPrinter.printText(json);
                        continue;
                    }
                    if (json.getInt("type") != 4) continue;
                    CTPrinter.feedPage(json);
                }
            }
        }
        catch (Exception e) {
            res = -2;
        }
        return CTPrinter.convertErroCode(res);
    }

    private static int convertErroCode(int res) {
        if (res == 4099) {
            return 6;
        }
        if (res == 4103) {
            return 3;
        }
        if (res == 4104) {
            return 0;
        }
        if (res == 4113) {
            return -1;
        }
        if (res == 4115) {
            return 4;
        }
        if (res == 0) {
            return 1;
        }
        return res;
    }

    private static void feedPage(JSONObject json) throws RemoteException, JSONException {
        if (json.has("value")) {
            CTDevice.printer.spitPaper(json.getInt("value") * 10);
        } else {
            CTDevice.printer.spitPaper(60);
        }
    }

    private static int printText(JSONObject json) throws JSONException, RemoteException {
        PrintDataObject printDataObject = new PrintDataObject(json.getString("text"));
        if (json.has("fontsize")) {
            int fonzise = json.getInt("fontsize");
            if (fonzise == 1) {
                printDataObject.setIsLittleSize(true);
            } else if (fonzise == 3) {
                printDataObject.setSpacing(PrintDataObject.SPACING.DOUBLE_HIGH);
            } else if (fonzise == 4) {
                printDataObject.setSpacing(PrintDataObject.SPACING.DOUBLE_HIGH_WIDTH);
            }
        }
        if (json.has("isbold")) {
            printDataObject.setBold(json.getBoolean("isbold"));
        }
        if (json.has("align")) {
            String align = json.getString("align").toUpperCase();
            if ("CENTER".equals(align)) {
                printDataObject.setAlign(PrintDataObject.ALIGN.CENTER);
            } else if ("RIGHT".equals(align)) {
                printDataObject.setAlign(PrintDataObject.ALIGN.RIGHT);
            }
        }
        ArrayList<PrintDataObject> list = new ArrayList<PrintDataObject>();
        list.add(printDataObject);
        return CTDevice.printer.printTextSync(list);
    }

    private static int printBarCode(JSONObject json) throws JSONException, RemoteException {
        return CTDevice.printer.printBarCodeSync(json.getString("text"));
    }

    private static int printQrCode(JSONObject json) throws JSONException, RemoteException {
        return CTDevice.printer.printQRCodeSync(json.getString("text"), 300, 1);
    }

    private class PrinterCallback
    extends AidlPrinterStateChangeListener.Stub {
        private PrinterCallback() {
        }

        public void onPrintError(int arg0) throws RemoteException {
        }

        public void onPrintFinish() throws RemoteException {
        }

        public void onPrintOutOfPaper() throws RemoteException {
        }
    }
}

