/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.pos.printer;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Handler;
import android.os.Message;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.aofeng.hybrid.util.BluetoothService;
import com.aofeng.hybrid.util.command.PrintPicture;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import zj.com.customize.sdk.Other;

public class BTPrint
implements AfPrinter {
    private BluetoothAdapter mBtAdapter;
    private BluetoothService mService;
    @SuppressLint(value={"HandlerLeak"})
    private final Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
        }
    };

    public static byte translate(int i) {
        switch (i) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
        }
        return 0;
    }

    public BTPrint() {
        this.mBtAdapter = BluetoothAdapter.getDefaultAdapter();
        this.mService = new BluetoothService(this.mHandler);
    }

    @Override
    public boolean openPrinter() {
        if (!this.mBtAdapter.isEnabled()) {
            this.mBtAdapter.enable();
        }
        if (this.mService != null && this.mService.getState() == 0) {
            this.mService.start();
        }
        return true;
    }

    public Set<BluetoothDevice> getBondedDevices() {
        if (this.mBtAdapter != null) {
            return this.mBtAdapter.getBondedDevices();
        }
        return null;
    }

    public void connect(String macAddress) {
        this.mBtAdapter.cancelDiscovery();
        if (BluetoothAdapter.checkBluetoothAddress((String)macAddress)) {
            BluetoothDevice device = this.mBtAdapter.getRemoteDevice(macAddress);
            this.mService.connect(device);
        }
    }

    @Override
    public int getPrinterState() {
        int statusCode = 0;
        try {
            statusCode = this.mService.getState();
        }
        catch (Exception e) {
            return statusCode;
        }
        return statusCode;
    }

    @Override
    public int print(String msg) {
        this.openPrinter();
        Set<BluetoothDevice> binds = this.getBondedDevices();
        String address = "";
        for (BluetoothDevice device : binds) {
            address = device.getAddress();
        }
        this.connect(address);
        int res = 1;
        try {
            Thread.sleep(2000L);
            JSONArray arry = new JSONArray(msg);
            if (arry.length() > 0) {
                for (int i = 0; i < arry.length(); ++i) {
                    JSONObject json = arry.getJSONObject(i);
                    if (json.getInt("type") == 1) {
                        this.mService.write(json.getString("text").getBytes("GBK"));
                        this.mService.write(new byte[]{29, 107, 65, 12});
                        continue;
                    }
                    if (json.getInt("type") == 2) {
                        this.mService.write(json.getString("text").getBytes("GBK"));
                        this.mService.write(new byte[]{27, 90, 3, 3, 8, 0, 0});
                        continue;
                    }
                    if (json.getInt("type") == 3) {
                        if (json.has("isbold")) {
                            boolean result = json.getBoolean("isbold");
                            if (result) {
                                this.mService.write(new byte[]{27, 69, 1});
                            } else {
                                this.mService.write(new byte[]{27, 69, 0});
                            }
                        }
                        this.mService.write(json.getString("text").getBytes("GBK"));
                        if (json.has("fontsize")) {
                            int fonzise = json.getInt("fontsize");
                            this.mService.write(new byte[]{27, 77, BTPrint.translate(fonzise)});
                        }
                        if (json.has("align")) {
                            String align = json.getString("align");
                            if (align.equals("center")) {
                                this.mService.write(new byte[]{27, 97, 1});
                            } else if (align.equals("left")) {
                                this.mService.write(new byte[]{27, 97, 0});
                            } else if (align.equals("right")) {
                                this.mService.write(new byte[]{27, 97, 2});
                            }
                        }
                        this.mService.write(new byte[]{10});
                        continue;
                    }
                    if (json.getInt("type") == 4) {
                        String unit = json.getString("unit");
                        if (unit.equals("pixel")) {
                            char n = (char)json.getInt("value");
                            this.mService.write(new byte[]{27, 74, BTPrint.translate(n)});
                            continue;
                        }
                        if (!unit.equals("line")) continue;
                        char n = (char)json.getInt("value");
                        this.mService.write(new byte[]{27, 100, BTPrint.translate(n)});
                        continue;
                    }
                    if (json.getInt("type") != 5) continue;
                    if (json.has("align")) {
                        String align = json.getString("align");
                        if (align.equals("center")) {
                            this.mService.write(new byte[]{27, 97, 1});
                        } else if (align.equals("left")) {
                            this.mService.write(new byte[]{27, 97, 0});
                        } else if (align.equals("right")) {
                            this.mService.write(new byte[]{27, 97, 2});
                        }
                    }
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = false;
                    String filePath = json.getString("url").substring(7);
                    Bitmap bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options).copy(Bitmap.Config.ARGB_8888, true);
                    Bitmap bmp = Other.createAppIconText((Bitmap)bitmap, (String)"", (float)25.0f, (boolean)true, (int)200);
                    this.mService.write(PrintPicture.POS_PrintBMP(bitmap, 384, 0));
                }
                this.mService.write(new byte[]{29, 86, 66, 0});
            }
            Thread.sleep(2000L);
            this.closePrinter();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    @Override
    public boolean closePrinter() {
        if (this.mService != null) {
            this.mService.stop();
        }
        if (this.mBtAdapter != null) {
            this.mBtAdapter.cancelDiscovery();
        }
        return true;
    }
}

