/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.task;

import android.content.Context;
import android.os.AsyncTask;
import android.util.Log;
import com.aofeng.hybrid.activity.HybridActivity;
import com.aofeng.hybrid.android.task.HintPlugin;
import com.aofeng.hybrid.service.LogicService;
import org.json.JSONObject;

public class GenericAsyncTask
extends AsyncTask<String, String, JSONObject> {
    protected HybridActivity hybridActivity;
    protected String callback;
    protected String logic;

    public GenericAsyncTask(HybridActivity hybridActivity, String logic, String callback) {
        this.hybridActivity = hybridActivity;
        this.callback = callback;
        this.logic = logic;
    }

    protected JSONObject doInBackground(String ... params) {
        try {
            LogicService logicService = new LogicService((Context)this.hybridActivity);
            HintPlugin plugin = new HintPlugin(this);
            logicService.addService("hint", plugin);
            JSONObject result = (JSONObject)logicService.run(this.logic, new JSONObject(params[0]));
            Log.d((String)"\u8c03\u7528\u4e1a\u52a1\u8fd4\u56de\u503c", (String)result.toString());
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void hint(String msg) {
        this.publishProgress(new String[]{msg});
    }

    protected void onPreExecute() {
        super.onPreExecute();
        this.hybridActivity.createProgressDialog(0);
    }

    protected void onPostExecute(JSONObject result) {
        super.onPostExecute((Object)result);
        this.hybridActivity.closeProgress();
        if (this.callback != null && result != null && result.has("params")) {
            try {
                String js = "javascript:" + String.format(this.callback, result.getString("params")) + ";";
                this.hybridActivity.mWebView.loadUrl(js);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void onProgressUpdate(String ... values) {
        super.onProgressUpdate((Object[])values);
        this.hybridActivity.setMessage(values[0]);
    }
}

