/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android.service;

import android.app.Notification;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.support.annotation.Nullable;
import android.util.Log;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.android.receiver.PhoneStatus;
import com.aofeng.hybrid.android.receiver.PhoneStatusReceiver;
import com.aofeng.hybrid.android.service.AbstractService;
import com.aofeng.hybrid.android.service.Player;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.service.LogicService;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TickService
extends AbstractService {
    private static final Logger log = LoggerFactory.getLogger(TickService.class);
    private static final int SERVICE_ID = -1001;
    private Player player;
    private boolean shouldStop = false;
    public volatile boolean idle = false;
    private Thread theThread;
    PowerManager.WakeLock wakeLock;

    @Override
    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    private void startAThread(final int alarmInterval) {
        this.theThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PowerManager powerManager = (PowerManager)TickService.this.getSystemService("power");
                    TickService.this.wakeLock = powerManager.newWakeLock(1, "alarmLock");
                    TickService.this.wakeLock.acquire();
                    TickService.this.work(alarmInterval);
                }
                finally {
                    TickService.this.wakeLock.release();
                }
            }
        });
        this.theThread.start();
        AFApplication cfr_ignored_0 = (AFApplication)this.getApplication();
        AFApplication.service = this;
    }

    private void work(int alarmInterval) {
        Date day;
        long n = 0L;
        Date preDay = day = new Date();
        while (true) {
            try {
                while (true) {
                    if (this.shouldStop) {
                        this.stopPlayer();
                        return;
                    }
                    boolean notLoggedIn = CommUtil.getSharedPreference((Context)this, "f_repairman_id").equals("x");
                    if (notLoggedIn) {
                        LogUtil.e("Not logged in yet", "stay idle......");
                    } else {
                        ++n;
                        if (!this.idle) {
                            if (n % (long)AFApplication.STATUS_COUNTER == 0L && !this.shouldStop) {
                                this.checkGpsEnabled();
                                day = new Date();
                                if (day.getDay() != preDay.getDay() && this.reportDailyStatus(preDay)) {
                                    preDay = day;
                                }
                                this.reportMinuteStatus(day);
                            }
                            if (!this.shouldStop) {
                                this.invokeKnownLogic();
                            }
                            LogUtil.e("cycle " + n, "mission completed");
                        }
                    }
                    Thread.sleep(alarmInterval);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.stopPlayer();
                continue;
            }
            break;
        }
    }

    private void invokeKnownLogic() {
        try {
            LogicService logicService = new LogicService((Context)this);
            JSONObject jo = (JSONObject)logicService.run("\u5b9a\u65f6\u63d0\u53d6", null);
            CommUtil.setSharedPreference((Context)this, jo);
            boolean dinging = false;
            if (jo.has("hasNew") && jo.getInt("hasNew") == 1) {
                dinging |= true;
            }
            if (jo.has("hasNewMsg") && jo.getInt("hasNewMsg") == 1) {
                dinging |= true;
            }
            if (dinging) {
                this.player.play((Context)this, R.raw.ding);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkGpsEnabled() {
        PhoneStatusReceiver.setupGPSReceiver((Context)this);
    }

    private void stopPlayer() {
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    private boolean reportDailyStatus(Date yesterday) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportMinuteStatus(Date timestamp) {
        try {
            JSONObject pref = CommUtil.getHybridContext((Context)this);
            if (!pref.has("f_repairman_id")) {
                return;
            }
            String f_user_name = pref.getString("f_repairman_id");
            String f_user_id = pref.get("f_repairman_id") + "";
            JSONObject jo = PhoneStatus.getPhoneStatus((Context)this, timestamp);
            if (jo.getString("f_longitude").equals("0.0")) {
                jo.put("f_longitude", (Object)"0");
            }
            if (jo.getString("f_latitude").equals("0.0")) {
                jo.put("f_latitude", (Object)"0");
            }
            if (!jo.getString("f_longitude").equals("0") && this.getResources().getString(R.string.geo).equals("baidu")) {
                HttpGet httpGet = new HttpGet("http://api.map.baidu.com/geoconv/v1/?coords=" + jo.get("f_longitude") + "," + jo.get("f_latitude") + "&ak=CAErfbr2DatVA6rHdoUELPynrdPh9A6S&output=json");
                DefaultHttpClient httpClient = new DefaultHttpClient();
                HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
                try (BufferedReader rd = null;){
                    rd = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                    String line = rd.readLine();
                    JSONObject jr = new JSONObject(line);
                    jr = jr.getJSONArray("result").getJSONObject(0);
                    jo.put("f_longitude", (Object)jr.getString("x"));
                    jo.put("f_latitude", (Object)jr.getString("y"));
                }
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            jo.put("f_user_name", (Object)f_user_name);
            jo.put("f_user_id", (Object)f_user_id);
            jo.put("f_realtime", (Object)sdf.format(timestamp));
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:00");
            jo.put("f_datetime", (Object)sdf.format(timestamp));
            jo.put("f_period", (Object)"\u5206");
            JSONObject config = CommUtil.getHybridContext((Context)this);
            jo.put("f_subcompany", (Object)config.getString("f_subcompany"));
            JSONObject data = new JSONObject();
            data.put("data", (Object)jo);
            String LOGIC_SERVICE_URL = config.getString("cc_base_url") + "/logic/";
            HttpPost httpPost = new HttpPost(LOGIC_SERVICE_URL + URLEncoder.encode("\u4e0a\u62a5\u624b\u673a\u72b6\u6001", "UTF-8"));
            httpPost.setEntity((HttpEntity)new StringEntity(String.format("%s", data.toString()), "UTF8"));
            DefaultHttpClient httpClient = new DefaultHttpClient();
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogUtil.e("\u5b89\u68c0\u5458\u72b6\u6001", "\u4e0a\u4f20\u5b9e\u65f6\u72b6\u6001\u6570\u636e\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u3002");
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.e((String)"MyService", (String)("Received start id " + startId + ": " + intent));
        if (Build.VERSION.SDK_INT < 18) {
            this.startForeground(-1001, new Notification());
        } else {
            Intent innerIntent = new Intent((Context)this, TickShadowService.class);
            this.startService(innerIntent);
            this.startForeground(-1001, new Notification());
        }
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onStartService() {
        LogUtil.e("\u65b0\u5efaservice\u5bf9\u8c61", "\u521b\u5efa\u670d\u52a1\u5bf9\u8c61\u5e76\u542f\u52a8\u670d\u52a1");
        this.player = new Player();
        this.startAThread(AFApplication.BASE_INTERVAL);
    }

    @Override
    public void onStopService() {
        this.stopPlayer();
        this.shouldStop = true;
        AFApplication cfr_ignored_0 = (AFApplication)this.getApplication();
        AFApplication.service = null;
    }

    public void mute() {
        this.player.stop();
    }

    @Override
    public void onReceiveMessage(Message msg) {
    }

    public static class TickShadowService
    extends Service {
        public int onStartCommand(Intent intent, int flags, int startId) {
            this.startForeground(-1001, new Notification());
            this.stopForeground(true);
            this.stopSelf();
            return super.onStartCommand(intent, flags, startId);
        }

        @Nullable
        public IBinder onBind(Intent intent) {
            return null;
        }
    }
}

