/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.android;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.webkit.WebView;
import android.widget.Toast;
import com.aofeng.hybrid.activity.HybridActivity;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.activity.PayTransferActivity;
import com.aofeng.hybrid.activity.PreludeActivity;
import com.aofeng.hybrid.android.peripheral.SignActivity;
import com.aofeng.hybrid.android.receiver.PhoneStatus;
import com.aofeng.hybrid.android.task.GenericAsyncTask;
import com.aofeng.hybrid.android.task.HintPlugin;
import com.aofeng.hybrid.android.task.SimpleAsyncTask;
import com.aofeng.hybrid.application.AFApplication;
import com.aofeng.hybrid.plugin.H5Param;
import com.aofeng.hybrid.plugin.NativeCallJS;
import com.aofeng.hybrid.plugin.TaskExecutor;
import com.aofeng.hybrid.service.GenericService;
import com.aofeng.hybrid.service.LogicService;
import com.aofeng.hybrid.service.PathService;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeBaseMethod {
    private static Map<String, Object> services = new HashMap<String, Object>();
    private static int NOTIFICATION_ID;

    public static void notify2(WebView webView, String title, String msg, String insistent) throws Exception {
        NativeBaseMethod.notify(webView, title, msg, insistent, "ic_launcher", "ic_launcher", "ding");
    }

    public static void notify(WebView webView, String title, String msg, String insistent, String smallIconName, String largeIconName, String soundRawName) throws Exception {
        Context ctx = webView.getContext();
        Resources res = ctx.getResources();
        int smallIconId = res.getIdentifier(smallIconName, "drawable", ctx.getPackageName());
        int largeIconId = res.getIdentifier(largeIconName, "drawable", ctx.getPackageName());
        int soundId = res.getIdentifier(soundRawName, "raw", ctx.getPackageName());
        CommUtil.notify(webView.getContext(), NOTIFICATION_ID++, title, msg, insistent.equals("true"), smallIconId, largeIconId, soundId);
    }

    public static void setPreference(WebView webView, String key, String value) {
        CommUtil.setSharedPreference(webView.getContext(), key, value);
    }

    public static String getPreference(WebView webView, String key) {
        return CommUtil.getSharedPreference(webView.getContext(), key);
    }

    public static int getAppVersion(WebView webView) {
        return CommUtil.getVersionCode(webView.getContext());
    }

    public static JSONObject getPhoneStatus(WebView webView) throws Exception {
        Context context = webView.getContext();
        Date date = new Date();
        return PhoneStatus.getPhoneStatus(context, date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupDatabase(WebView webView) {
        AbstractInterruptibleChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            File dbFile = webView.getContext().getDatabasePath("hybrid.db");
            File exportDir = new File(Environment.getExternalStorageDirectory(), "dbBackup");
            if (!exportDir.exists()) {
                exportDir.mkdirs();
            }
            File backup = new File(exportDir, "hybrid.db");
            backup.createNewFile();
            inChannel = new FileInputStream(dbFile).getChannel();
            outChannel = new FileOutputStream(backup).getChannel();
            ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), (WritableByteChannel)((Object)outChannel));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static JSONObject getAppContext(WebView webView) throws JSONException {
        Context ctx = webView.getContext();
        return CommUtil.getHybridContext(ctx);
    }

    public static void logicWithHint(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            String callback = jo.getString("callback");
            jo.remove("logic");
            jo.remove("callback");
            GenericAsyncTask dat = new GenericAsyncTask((HybridActivity)webView.getContext(), logic, callback);
            dat.execute(new String[]{jo.toString()});
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6267\u884c\u5e26\u8fdb\u5ea6\u7684\u903b\u8f91\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static JSONObject logic(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            jo.remove("logic");
            LogicService ls = new LogicService(webView.getContext());
            ls.addService("hint", new HintPlugin(null));
            return (JSONObject)ls.run(logic, jo);
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6267\u884c\u903b\u8f91\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static JSONObject bzLogic(WebView webView, JSONObject jo) throws Exception {
        try {
            String logic = jo.getString("logic");
            jo.remove("logic");
            LogicService ls = new LogicService(webView.getContext());
            ls.addService("hint", new HintPlugin(null));
            return (JSONObject)ls.run(logic, jo.getJSONObject("data"));
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6267\u884c\u903b\u8f91\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static JSONObject path(WebView webView, JSONObject jo) throws Exception {
        try {
            PathService ps = new PathService(webView.getContext());
            return ps.action(jo);
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6267\u884c\u903b\u8f91\u51fa\u9519\u3002");
            throw e;
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    public static void _open_a_page(WebView webView, JSONObject jo) throws Exception {
        try {
            Context context = webView.getContext();
            String pageType = jo.getString("type").toLowerCase();
            if (pageType.equals("native")) {
                NativeBaseMethod.startupNativePage(jo.getString("page"), jo.getJSONObject("param"), context);
            } else if (pageType.equals("h5")) {
                NativeBaseMethod.startupH5Page(jo.getString("page"), jo.getString("method"), context);
            } else if (pageType.equals("boomerang")) {
                NativeBaseMethod.startupBoomerangPage(jo.getString("page"), jo.getJSONObject("param"), context);
            }
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6253\u5f00\u65b0\u9875\u9762\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static JSONObject print(WebView view, String params) throws JSONException {
        return new JSONObject(PreludeActivity.printer.print(params));
    }

    public static String getSN(WebView view) {
        return PreludeActivity.device.getSN();
    }

    public static String getPosSN(WebView view) {
        return PreludeActivity.SN;
    }

    public static void pay(WebView view, JSONObject json) throws ClassNotFoundException {
        Context context = view.getContext();
        Intent intent = new Intent(context, PayTransferActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("params", json.toString());
        intent.putExtras(bundle);
        ((Activity)context).startActivityForResult(intent, 555);
    }

    public static String getSellId(WebView view) {
        return PayTransferActivity.getsellSId();
    }

    public static JSONObject read(WebView view) throws JSONException {
        String json = PreludeActivity.card.read();
        JSONObject jo = new JSONObject(json);
        return jo;
    }

    public static JSONObject sell(WebView view, String params) throws JSONException {
        String result = PreludeActivity.card.sell(new JSONObject(params));
        return new JSONObject(result);
    }

    public static void searchPRMT(WebView view) {
        MainActivity.searchBluetooh();
    }

    public static JSONObject issue(WebView view, String params) throws JSONException {
        return new JSONObject(PreludeActivity.card.issue(new JSONObject(params)));
    }

    public static void toSet(WebView webView) throws ClassNotFoundException {
        Context context = webView.getContext();
        String page = "com.aofeng.hybrid.activity.SetActivity";
        Intent intent = new Intent(context, Class.forName(page));
        Bundle bundle = new Bundle();
        bundle.putString("SCREEN_ORIENTATION", HybridActivity.SCREEN_ORIENTATION);
        intent.putExtras(bundle);
        ((Activity)context).startActivity(intent);
    }

    public static void _executeAsyncTask(WebView webView, final JSONObject jo, final NativeCallJS jsCallback) throws Exception {
        try {
            Object service;
            String className = jo.getString("type");
            if (!services.containsKey(className)) {
                String mangledName = "com.aofeng.hybrid.service." + className.substring(0, 1).toUpperCase() + className.substring(1) + "Service";
                Class<?> clazz = Class.forName(mangledName);
                Constructor<?> ctor = clazz.getConstructor(Context.class);
                service = ctor.newInstance(webView.getContext().getApplicationContext());
                services.put(className, service);
            } else {
                service = services.get(className);
            }
            TaskExecutor.scheduleTaskOnUiThread(0L, new Runnable(){

                @Override
                public void run() {
                    try {
                        jsCallback.apply(((GenericService)service).action(jo.getJSONObject("data")));
                    }
                    catch (Exception e) {
                        LogUtil.d("NativeBaseMethod", "\u8c03\u7528\u670d\u52a1\u51fa\u9519\u3002");
                    }
                }
            });
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u8c03\u7528\u670d\u52a1\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static void simpleTask(WebView webView, JSONObject jo) throws Exception {
        try {
            SimpleAsyncTask dat = new SimpleAsyncTask((HybridActivity)webView.getContext(), jo);
            String callback = null;
            if (jo.has("callback") && !jo.isNull("callback")) {
                callback = jo.getString("callback");
            }
            dat.execute(new String[]{callback});
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u6267\u884c\u7b80\u5355\u5f02\u6b65\u4efb\u52a1\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static JSONObject _executeTask(WebView webView, JSONObject jo) throws Exception {
        try {
            Object service;
            String className = jo.getString("type");
            if (!services.containsKey(className)) {
                String mangledName = "com.aofeng.hybrid.service." + className.substring(0, 1).toUpperCase() + className.substring(1) + "Service";
                Class<?> clazz = Class.forName(mangledName);
                Constructor<?> ctor = clazz.getConstructor(Context.class);
                service = ctor.newInstance(webView.getContext().getApplicationContext());
                services.put(className, service);
            } else {
                service = services.get(className);
            }
            return ((GenericService)service).action(jo.getJSONObject("data"));
        }
        catch (Exception e) {
            LogUtil.d("NativeBaseMethod", "\u8c03\u7528\u670d\u52a1\u51fa\u9519\u3002");
            throw e;
        }
    }

    public static void alert(WebView webView, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(webView.getContext());
        builder.setTitle((CharSequence)"\u7cfb\u7edf\u63d0\u793a");
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.setCancelable(false);
        builder.create();
        builder.show();
    }

    public static void alert(WebView webView, int msg) {
        NativeBaseMethod.alert(webView, String.valueOf(msg));
    }

    public static void alert(WebView webView, boolean msg) {
        NativeBaseMethod.alert(webView, String.valueOf(msg));
    }

    public static void toast(WebView webView, String message) {
        Toast.makeText((Context)webView.getContext(), (CharSequence)message, (int)0).show();
    }

    public static void toast(WebView webView, JSONObject jo) {
        Toast.makeText((Context)webView.getContext(), (CharSequence)jo.toString(), (int)0).show();
    }

    public static void toast(WebView webView, String message, int isShowLong) {
        Toast.makeText((Context)webView.getContext(), (CharSequence)message, (int)isShowLong).show();
    }

    public static void goBack(WebView view) {
        if (view.getContext() instanceof Activity) {
            ((Activity)view.getContext()).finish();
        }
    }

    private static void startupNativePage(String page, JSONObject param, Context context) throws Exception {
        LogUtil.d("NativeBaseMethod", page);
        Intent intent = new Intent(context, Class.forName(page));
        Bundle bundle = new Bundle();
        bundle.putString("param", param.toString());
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    private static void startupBoomerangPage(String page, JSONObject param, Context context) throws Exception {
        LogUtil.d("NativeBaseMethod", page);
        Intent intent = new Intent(context, Class.forName(page));
        Bundle bundle = new Bundle();
        bundle.putString("param", param.toString());
        intent.putExtras(bundle);
        ((Activity)context).startActivityForResult(intent, param.getInt("requestCode"));
    }

    private static void startupH5Page(String page, String method, Context context) {
        Intent intent = new Intent(context, HybridActivity.class);
        Bundle bundle = new Bundle();
        if (!page.startsWith("http://")) {
            page = "file://" + context.getFilesDir().getAbsolutePath() + File.separator + "www/" + page;
        }
        LogUtil.d("NativeBaseMethod", page);
        bundle.putSerializable("param", (Serializable)new H5Param(page, method));
        intent.putExtras(bundle);
        context.startActivity(intent);
    }

    public static void makeAPhoneCall(WebView webView, String phoneNumber) {
        Intent callIntent = new Intent("android.intent.action.CALL");
        callIntent.setData(Uri.parse((String)("tel:" + phoneNumber)));
        ((HybridActivity)webView.getContext()).startActivity(callIntent);
    }

    public static void delfile(WebView webView, String path) {
        int n;
        if (path.startsWith("file://")) {
            path = path.substring("file://".length());
        }
        if ((n = path.indexOf("?")) > 0) {
            path = path.substring(0, n);
        }
        File file = new File(path);
        file.delete();
    }

    public static void viewPic(WebView webView, String path) {
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setDataAndType(Uri.parse((String)path), "image/*");
        webView.getContext().startActivity(intent);
    }

    public static void confirm(final WebView webView, String msg, final String js) throws Exception {
        AlertDialog.Builder builder = new AlertDialog.Builder(webView.getContext());
        builder.setTitle((CharSequence)"\u7cfb\u7edf\u786e\u8ba4");
        builder.setMessage((CharSequence)msg);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                webView.loadUrl(js);
            }
        });
        builder.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        });
        builder.setCancelable(false);
        builder.create();
        builder.show();
    }

    public static void getSignature(WebView webView, JSONObject jo) throws Exception {
        Context context = webView.getContext();
        Intent intent = new Intent(context, SignActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("param", jo.toString());
        intent.putExtras(bundle);
        ((Activity)context).startActivityForResult(intent, 421);
    }

    public static String getProxyUrl(WebView webView) throws Exception {
        Context context = webView.getContext();
        JSONObject config = CommUtil.getHybridContext(context);
        String result = config.getString("cc_base_url");
        return result;
    }

    public static String getFullFileName(WebView webView, String fileName) throws Exception {
        String fullFillName = "";
        if (fileName.trim().length() > 0) {
            fullFillName = "file://" + Environment.getExternalStorageDirectory() + File.separator + "safecheck" + File.separator + fileName;
        }
        return fullFillName;
    }

    public static void delFileName(WebView webView, String FileName) throws Exception {
        File file;
        String Path2 = AFApplication.APP_DATA + FileName;
        if (Path2.trim().length() > 0 && (file = new File(Path2)).exists() && file.isFile()) {
            file.delete();
        }
    }
}

