/*
 * Decompiled with CFR 0.152.
 */
package com.aofeng.hybrid.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.TextView;
import com.aofeng.hybrid.R;
import com.aofeng.hybrid.activity.MainActivity;
import com.aofeng.hybrid.activity.SetActivity;
import com.aofeng.hybrid.android.service.TickService;
import com.aofeng.hybrid.plugin.H5Param;
import com.aofeng.hybrid.pos.device.Device;
import com.aofeng.hybrid.pos.printer.AfPrinter;
import com.aofeng.hybrid.pos.printer.PrintAgent;
import com.aofeng.hybrid.pos.reader.CardAgent;
import com.aofeng.hybrid.pos.reader.ICardReader;
import com.aofeng.hybrid.sync.IProgressNotifier;
import com.aofeng.hybrid.sync.MD5Manager;
import com.aofeng.hybrid.sync.SyncDBAndPagesTask;
import com.aofeng.hybrid.sync.SyncParam;
import com.aofeng.hybrid.util.CommUtil;
import com.aofeng.hybrid.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PreludeActivity
extends Activity
implements IProgressNotifier {
    private static final String TAG = PreludeActivity.class.getCanonicalName();
    ProgressDialog pd;
    TextView hint;
    public static String SN;
    public static Device device;
    public static CardAgent card;
    public static PrintAgent printer;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.guide);
        this.setRequestedOrientation(-1);
        this.pd = new ProgressDialog((Context)this);
        this.pd.setProgressStyle(1);
        this.pd.setCancelable(false);
        this.hint = (TextView)this.findViewById(R.id.tvHint);
        this.findViewById(R.id.tvHint).setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                PreludeActivity.this.toSet();
                return false;
            }
        });
    }

    protected void onResume() {
        super.onResume();
        this.hint.setText((CharSequence)"");
        if (!"".equals(CommUtil.getSharedPreference((Context)this, "sync_url")) && CommUtil.hasConfig((Context)this) && this.loadContext((Context)this)) {
            this.updateSystem();
        } else {
            this.toSet();
        }
    }

    private void toSet() {
        Intent intent = new Intent((Context)this, SetActivity.class);
        Bundle bundle = new Bundle();
        bundle.putString("SCREEN_ORIENTATION", "-1");
        intent.putExtras(bundle);
        this.startActivity(intent);
    }

    private void initPos(JSONObject config) throws Exception {
        card = new CardAgent();
        printer = new PrintAgent();
        if (config.has("pos") && "true".equals(config.getString("pos").toLowerCase()) || config.has("bluetooth") && "true".equals(config.getString("bluetooth").toLowerCase())) {
            card.setCloudUrl(config.getString("cloud_url"));
            ICardReader cr = (ICardReader)Class.forName(config.getString("reader")).getConstructor(new Class[0]).newInstance(new Object[0]);
            AfPrinter ap = (AfPrinter)Class.forName(config.getString("printer")).getConstructor(new Class[0]).newInstance(new Object[0]);
            String socket_url = config.has("socket_url") ? config.getString("socket_url") : "";
            card.setSocketUrl(socket_url);
            card.setReader(cr);
            printer.setPrinter(ap);
        }
        if (config.has("pos") && "true".equals(config.getString("pos").toLowerCase())) {
            device = (Device)Class.forName(config.getString("device")).getConstructor(new Class[0]).newInstance(new Object[0]);
            device.initDevice((Context)this);
            SN = device.getSN();
        }
    }

    private void updateSystem() {
        String APP_ID = this.getApplicationContext().getPackageName();
        String strDt = CommUtil.getPreference((Context)this, APP_ID, SyncDBAndPagesTask.UPDATE_MOST_RECENT_TIME);
        SyncDBAndPagesTask task = new SyncDBAndPagesTask((Context)this, this);
        try {
            JSONObject config = CommUtil.getHybridContext((Context)this);
            this.initPos(config);
            this.initMd5(config);
            if ("true".equals(config.getString("startService").toLowerCase())) {
                this.startService();
            }
            String WWW_BASE = config.getString("sync_url");
            String BASE_URL = WWW_BASE + "/rs";
            String REMOTE_WWW_PREFIX = config.getString("REMOTE_WWW_PREFIX");
            String LOCAL_PATH_PREFIX = this.getFilesDir().getAbsolutePath() + File.separator;
            String REMOTE_BZ_PREFIX = config.getString("REMOTE_BZ_PREFIX");
            String UPDATE_SERVICE_URL = BASE_URL + "/dir/version";
            String entities = config.has("entities") ? config.getString("entities") : "";
            SyncParam sp = new SyncParam(APP_ID, BASE_URL + "/db/meta2/", entities, BASE_URL + "/dir?path=", REMOTE_WWW_PREFIX, LOCAL_PATH_PREFIX, REMOTE_BZ_PREFIX, BASE_URL + "/dir/", UPDATE_SERVICE_URL, strDt, WWW_BASE);
            Object[] params = new SyncParam[]{sp};
            task.execute(params);
        }
        catch (Exception var14) {
            throw new RuntimeException(var14);
        }
    }

    private void initMd5(JSONObject config) {
        MD5Manager md5 = MD5Manager.getInstance();
        md5.config = config;
        md5.loadMd5();
    }

    @Override
    public void notifyProgress(int progress) {
        this.pd.setProgress(progress);
    }

    @Override
    public void notifyDone(boolean done) {
        this.pd.hide();
        Log.d((String)TAG, (String)("\u7cfb\u7edf\u66f4\u65b0" + (done ? "\u6210\u529f" : "\u5931\u8d25")));
        String APP_ID = this.getApplicationContext().getPackageName();
        String strDt = CommUtil.getPreference((Context)this, APP_ID, SyncDBAndPagesTask.UPDATE_MOST_RECENT_TIME);
        if (!done) {
            this.hint.setText((CharSequence)"\u7cfb\u7edf\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u7f51\u7edc\u662f\u5426\u6b63\u5e38\u3002");
        }
        if (strDt != null) {
            Intent intent = new Intent((Context)this, MainActivity.class);
            Bundle bundle = new Bundle();
            try {
                JSONObject config = CommUtil.getHybridContext((Context)this);
                String ProjectNativeMethod = config.getString("ProjectNativeMethod");
                bundle.putSerializable("param", (Serializable)new H5Param("file://" + this.getFilesDir().getAbsolutePath() + "/www/index.html", ProjectNativeMethod));
                bundle.putString("SCREEN_ORIENTATION", config.getString("SCREEN_ORIENTATION"));
                bundle.putString("full_screen", config.has("full_screen") ? config.getString("full_screen") : "false");
                intent.putExtras(bundle);
                this.startActivity(intent);
            }
            catch (JSONException var8) {
                throw new RuntimeException(var8);
            }
        }
    }

    public void startService() {
        LogUtil.e("\u5e94\u7528", "\u542f\u52a8\u80cc\u666f\u670d\u52a1");
        Intent intent = new Intent((Context)this, TickService.class);
        this.startService(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadContext(Context context) {
        BufferedReader reader = null;
        String globalPath = context.getFilesDir().toString() + "/globals.txt";
        File global = new File(globalPath);
        try {
            String mLine;
            JSONObject jo = CommUtil.getHybridContext(context);
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(global)));
            String str = "";
            while ((mLine = reader.readLine()) != null) {
                str = str + mLine;
            }
            if ("".equals(str)) {
                global.delete();
                boolean bl = false;
                return bl;
            }
            JSONObject json = new JSONObject(str);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = json.get(key);
                if (value instanceof String) {
                    CommUtil.setSharedPreference(context, key, (String)value);
                    continue;
                }
                if (!(value instanceof JSONArray)) continue;
                str = PreludeActivity.toString((JSONArray)value);
                CommUtil.setSharedPreference(context, key, str);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static String toString(JSONArray array) {
        String result = "";
        for (int i = 0; i < array.length(); ++i) {
            if (!result.equals("")) {
                result = result + ",";
            }
            try {
                String s = array.getString(i);
                result = result + s.toString();
                continue;
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    @Override
    public void prelude() {
        this.pd.setMessage((CharSequence)"\u68c0\u67e5\u7cfb\u7edf\u66f4\u65b0......");
        this.pd.setProgress(0);
        this.pd.show();
    }
}

