/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.core.exception.LogicException;
import com.af.v4.system.common.core.proxy.excel.IExcelServiceProxy;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.logic.service.LogicService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/crud"})
public class CrudController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CrudController.class);
    private final EntityService entityService;
    private final LogicService logicService;
    private final LiuLiConfigService liuLiConfigService;
    private final IExcelServiceProxy excelService;

    public CrudController(EntityService entityService, LogicService logicService, LiuLiConfigService liuLiConfigService, IExcelServiceProxy excelService) {
        this.entityService = entityService;
        this.logicService = logicService;
        this.liuLiConfigService = liuLiConfigService;
        this.excelService = excelService;
    }

    @Log(title="\u901a\u8fc7excel\u5bfc\u5165\u6570\u636e", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/importDataByExcel"}, produces={"application/json"})
    public R<Object> importDataByExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="queryParamsName") String queryParamsName, @RequestParam(value="userData", required=false) String userDataString) {
        try {
            JSONObject config = this.liuLiConfigService.get(queryParamsName, Boolean.valueOf(true));
            JSONObject resultObj = new JSONObject();
            JSONArray excelImportTemplate = config.optJSONArray("excelImportTemplate");
            if (excelImportTemplate == null || excelImportTemplate.isEmpty()) {
                return R.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6ca1\u6709\u914d\u7f6e\u5bfc\u5165\u5217");
            }
            JSONObject apiSlot = config.optJSONObject("apiSlot");
            JSONArray titles = new JSONArray();
            JSONArray columns = new JSONArray();
            JSONObject userData = new JSONObject();
            if (userDataString != null && !userDataString.isEmpty()) {
                try {
                    userData = new JSONObject(userDataString);
                }
                catch (JSONException ignored) {
                    LOGGER.warn("\u64cd\u4f5c\u4eba\u4fe1\u606f\u89e3\u6790\u9519\u8bef\u3002");
                }
            }
            excelImportTemplate.forEach(item -> {
                JSONObject itemObj = (JSONObject)item;
                titles.putAll(itemObj.get("title"));
                columns.putAll(itemObj.get("column"));
            });
            List dataList = this.excelService.importExcel(file.getInputStream(), titles);
            resultObj.put("successLen", dataList.size());
            JSONArray datas = new JSONArray();
            dataList.forEach(data -> {
                JSONObject entity = new JSONObject();
                for (int i = 0; i < columns.length(); ++i) {
                    entity.put(columns.getString(i), data.get(i));
                }
                datas.put((Object)entity);
            });
            JSONObject SlotData = new JSONObject();
            if (apiSlot != null && !apiSlot.isEmpty()) {
                SlotData.put("config", (Object)config).put("datas", (Object)datas).put("userData", (Object)userData);
            }
            if (apiSlot != null && apiSlot.has("excelImportTemplateBefore") && (resultObj = new JSONObject(this.logicService.run(apiSlot.getString("excelImportTemplateBefore"), SlotData).toString())).get("status").toString().equals("1")) {
                return R.fail((String)resultObj.optString("msg", "\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\u6821\u9a8c\u5931\u8d25"));
            }
            if (apiSlot != null && apiSlot.has("excelImportTemplateLogic")) {
                resultObj = new JSONObject(this.logicService.run(apiSlot.getString("excelImportTemplateLogic"), SlotData).toString());
            } else {
                HashMap<String, String> fieldMapping = new HashMap<String, String>();
                fieldMapping.put("f_orgid", "orgId");
                fieldMapping.put("f_orgname", "orgName");
                fieldMapping.put("f_depid", "depId");
                fieldMapping.put("f_depname", "depName");
                fieldMapping.put("f_operatorid", "currUserId");
                fieldMapping.put("f_operator", "currUserName");
                JSONObject finalUserData = userData;
                excelImportTemplate.forEach(importTable -> {
                    JSONObject importTableObj = (JSONObject)importTable;
                    String tableName = importTableObj.getString("tableName");
                    LOGGER.info("\u5bfc\u5165\u8868\u540d\uff1a{}", (Object)tableName);
                    datas.forEach(data -> {
                        try {
                            JSONObject savaData = (JSONObject)data;
                            for (Map.Entry entry : fieldMapping.entrySet()) {
                                if (savaData.has((String)entry.getKey())) continue;
                                savaData.put((String)entry.getKey(), finalUserData.get((String)entry.getValue()));
                            }
                            this.entityService.partialSave(tableName, savaData);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                });
            }
            if (apiSlot != null && apiSlot.has("excelImportTemplateAfter")) {
                this.logicService.run(apiSlot.getString("excelImportTemplateAfter"), SlotData);
            }
            return R.ok((Object)resultObj.toMap(), (String)"\u5bfc\u5165\u6570\u636e\u6210\u529f");
        }
        catch (LogicException le) {
            LOGGER.error("\u5bfc\u5165\u6570\u636e\u5931\u8d25\uff1a{}", (Object)le.getStack());
            return R.fail((String)le.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            return R.fail((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25");
        }
    }
}

