/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.upgrade;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.runtime.dto.UpgradeField;
import java.util.List;
import org.json.JSONArray;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public abstract class UpgradePathExecutor {
    protected final LogicService logicService = (LogicService)SpringUtils.getBean(LogicService.class);
    protected final SqlService sqlService = (SqlService)SpringUtils.getBean(SqlService.class);
    protected final ApplicationUtils applicationUtils = (ApplicationUtils)SpringUtils.getBean(ApplicationUtils.class);
    protected final LiuLiConfigService liuLiConfigService = (LiuLiConfigService)SpringUtils.getBean(LiuLiConfigService.class);

    protected UpgradePathExecutor() {
    }

    @Transactional(rollbackFor={Exception.class})
    public abstract void upgrade();

    public abstract String targetVersion();

    public final int targetVersionCode() {
        return ApplicationUtils.buildVersionCode((String)this.targetVersion());
    }

    protected void removeCacheKeys(List<String> cacheKeys) {
        String namespaceName = this.applicationUtils.getApplicationName();
        this.liuLiConfigService.removeCacheKeys(namespaceName, "prod", cacheKeys);
    }

    protected void addFields(List<UpgradeField> fields) {
        for (UpgradeField field : fields) {
            String searchSql = field.getSearchSql();
            JSONArray searchResult = this.sqlService.querySQL("UpgradeField", searchSql);
            if (!searchResult.isEmpty()) continue;
            String addSql = field.getAddSql();
            this.sqlService.execSQL("UpgradeField", addSql);
        }
    }
}

