/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.service;

import com.af.v4.system.api.RemoteAppService;
import com.af.v4.system.api.factory.DynamicFeignClientFactory;
import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
public class AppService {
    private final ApplicationUtils applicationUtils;
    private final DynamicFeignClientFactory<RemoteAppService> remoteAppServiceFactory;

    public AppService(ApplicationUtils applicationUtils, DynamicFeignClientFactory<RemoteAppService> remoteAppServiceFactory) {
        this.applicationUtils = applicationUtils;
        this.remoteAppServiceFactory = remoteAppServiceFactory;
    }

    public JSONObject getAppInfo() {
        return this.applicationUtils.getValues();
    }

    public Integer compareAppVersion(String version) {
        int currVersionCode = ApplicationUtils.buildVersionCode((String)version);
        int targetVersionCode = ApplicationUtils.getAppVersionCode();
        return Integer.compare(currVersionCode, targetVersionCode);
    }

    public Integer compareLiuLiVersion(String version) {
        int currVersionCode = ApplicationUtils.buildVersionCode((String)version);
        int targetVersionCode = ApplicationUtils.getSystemV4VersionCode();
        return Integer.compare(currVersionCode, targetVersionCode);
    }

    public JSONObject getRemoteAppInfo(String serviceName) {
        RemoteAppService remoteAppService = (RemoteAppService)this.remoteAppServiceFactory.getFeignClient(RemoteAppService.class, serviceName);
        R result = remoteAppService.getAppInfo(serviceName);
        return result.getCode() == 200 ? new JSONObject((Map)result.getData()) : null;
    }

    public Integer compareRemoteAppVersion(String serviceName, String version) {
        RemoteAppService remoteAppService = (RemoteAppService)this.remoteAppServiceFactory.getFeignClient(RemoteAppService.class, serviceName);
        R result = remoteAppService.compareAppVersion(serviceName, version);
        return result.getCode() == 200 ? (Integer)result.getData() : null;
    }

    public Integer compareRemoteLiuLiVersion(String serviceName, String version) {
        RemoteAppService remoteAppService = (RemoteAppService)this.remoteAppServiceFactory.getFeignClient(RemoteAppService.class, serviceName);
        R result = remoteAppService.compareLiuLiVersion(serviceName, version);
        return result.getCode() == 200 ? (Integer)result.getData() : null;
    }
}

