package com.af.v4.system.runtime.dto;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.datasource.enums.DbType;

/**
 * @Classname UpgradeField
 * @Description TODO 升级补丁添加字段
 * @Date 2024/8/13 下午2:09
 * @Created by 张振宇
 */
public class UpgradeField {
    private String tableName;
    private String field;
    private String type;

    public UpgradeField(String tableName, String field, String type) {
        this.tableName = tableName;
        this.field = field;
        this.type = type;
    }

    public String getSearchSql() {
        if (DynamicDataSource.getDbType() == DbType.oracle){
            return "select 1 from user_tab_columns where table_name = '" + tableName.toUpperCase() + "' and column_name = '" + field.toUpperCase() + "'";
        }
        return "select 1 from syscolumns where id = object_id('" + tableName + "') and name = '" + field + "'";
    }

    public String getAddSql() {
        if (DynamicDataSource.getDbType() == DbType.oracle){
            if (type.contains("datetime")) {
                type = type.replace("datetime", "timestamp");
            }
            if (type.contains("getdate()")) {
                type = type.replace("getdate()", "sysdate");
            }
            if (type.contains("varchar(")) {
                type = type.replace("varchar(", "varchar2(");
            }
            if (type.contains("numeric(")) {
                type = type.replace("numeric(", "NUMBER(");
            }
            if (type.contains("int")) {
                type = type.replace("int", "number(10)");
            }
            if (type.contains("bigint")) {
                type = type.replace("bigint", "number(19)");
            }
            return "alter table " +  tableName.toUpperCase()  + " add " + field.toUpperCase() + " " + type;
        }
        return "alter table " + tableName + " add " + field + " " + type;
    }

}
