/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.workflow.perform;

import com.af.v4.system.common.expression.core.Delegate;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.v3.workflow.perform.ActivityInstance;
import com.af.v4.v3.workflow.perform.ProcessDef;
import com.af.v4.v3.workflow.perform.ProcessDefManager;
import com.af.v4.v3.workflow.perform.VarDef;
import com.af.v4.v3.workflow.perform.VarInstance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONObject;

public class ProcessInstance {
    private Set<ActivityInstance> activities = new HashSet<ActivityInstance>();
    private Set<VarInstance> vars = new HashSet<VarInstance>();
    private String name;
    private ProcessDef define;
    private String state = "";
    private String id;
    private String handUpReason = "\u65e0";

    public ProcessInstance() {
    }

    public ProcessInstance(ProcessDef define, String id) {
        this.id = id;
        String name = define.getName();
        this.setName(name);
        this.initVar();
    }

    public Set<VarInstance> getVars() {
        return this.vars;
    }

    public void setVars(Set<VarInstance> vars) {
        this.vars = vars;
    }

    private void initVar() {
        for (VarDef var : this.getDefine().getVars()) {
            VarInstance varIns = new VarInstance(var.getName(), null);
            this.vars.add(varIns);
        }
    }

    public void putVar(JSONObject vars) {
        for (VarInstance var : this.vars) {
            try {
                if (!vars.has(var.getName())) continue;
                String value = vars.getString(var.getName());
                var.setValue(value);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getVarValue(String name) {
        for (VarInstance var : this.vars) {
            try {
                if (!name.equals(var.getName())) continue;
                return var.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public ProcessDef getDefine() {
        if (this.define != null) {
            return this.define;
        }
        String name = this.getName();
        this.define = ProcessDefManager.getInstance().getProcessDef(name);
        if (this.define == null) {
            throw new RuntimeException("\u6d41\u7a0b\u5b9e\u4f8b\u627e\u4e0d\u5230\u5b9a\u4e49\uff1a\u5b9a\u4e49\u540d=" + name);
        }
        return this.define;
    }

    public Set<ActivityInstance> getAllActivities() {
        return this.activities;
    }

    public String toString() {
        return this.name;
    }

    public String getHandUpReason() {
        return this.handUpReason;
    }

    public void setHandUpReason(String reason) {
        this.handUpReason = reason;
    }

    public void add(ActivityInstance ai) {
        this.activities.add(ai);
    }

    public ActivityInstance getFirstActivity() {
        for (ActivityInstance act : this.getActivities()) {
            if (act.getForeActivityInstance() != null) continue;
            return act;
        }
        return null;
    }

    public void stop() {
        this.setState("\u7ed3\u675f");
    }

    public void suspend() {
        if (this.getState().equals("\u7b49\u5f85")) {
            this.setState("\u6302\u8d77");
        }
    }

    public void resume() {
        if (this.getState().equals("\u6302\u8d77")) {
            this.setState("\u7b49\u5f85");
        }
    }

    public Set<ActivityInstance> getActivities() {
        return this.activities;
    }

    public void setActivities(Set<ActivityInstance> activities) {
        this.activities = activities;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getExpressionValue(String expression) {
        Program prog = new Program(expression);
        Delegate d = prog.parse();
        HashMap<String, String> params = new HashMap<String, String>();
        for (VarInstance var : this.vars) {
            params.put(var.getName(), var.getValue());
        }
        return d.invoke(params);
    }

    public ActivityInstance getActivitiesByDefid(String defid) {
        ActivityInstance activity;
        String actDefid;
        ActivityInstance act = null;
        Iterator<ActivityInstance> iterator = this.activities.iterator();
        while (iterator.hasNext() && !(actDefid = (act = (activity = iterator.next())).getDefid()).equals(defid)) {
        }
        return act;
    }

    public ActivityInstance getActivitiesByActid(int actid) {
        ActivityInstance activity;
        int id;
        ActivityInstance act = null;
        Iterator<ActivityInstance> iterator = this.activities.iterator();
        while (iterator.hasNext() && (id = (act = (activity = iterator.next())).getId()) != actid) {
        }
        return act;
    }

    public List<ActivityInstance> getActivitiesByState(String state) {
        LinkedList<ActivityInstance> result = new LinkedList<ActivityInstance>();
        for (ActivityInstance act : this.activities) {
            String actState = act.getState();
            if (!actState.equals(state)) continue;
            result.add(act);
        }
        return result;
    }
}

