/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.workflow.perform;

import com.af.v4.v3.workflow.perform.ActivityDef;
import com.af.v4.v3.workflow.perform.ActorDef;
import com.af.v4.v3.workflow.perform.Diagram;
import com.af.v4.v3.workflow.perform.DiversionDef;
import com.af.v4.v3.workflow.perform.FlowDef;
import com.af.v4.v3.workflow.perform.InvalidActivityInstanceException;
import com.af.v4.v3.workflow.perform.ProcessInstance;
import com.af.v4.v3.workflow.perform.VarDef;
import com.af.v4.v3.workflow.perform.VarInstance;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ProcessDef
extends FlowDef
implements Serializable {
    private static final long serialVersionUID = -8854627878683187720L;
    static Logger log = LoggerFactory.getLogger(ProcessDef.class);
    private final ArrayList<ActivityDef> activities = new ArrayList();
    private final ArrayList<DiversionDef> diversions = new ArrayList();
    private final ArrayList<ActorDef> actors = new ArrayList();
    private final List<VarDef> vars = new ArrayList<VarDef>();

    public ProcessDef(Diagram diagram) {
        this.name = diagram.getName();
        this.setDiagram(diagram);
    }

    public List<VarDef> getVars() {
        return this.vars;
    }

    public ActivityDef getActivity(String ID) {
        for (ActivityDef activity : this.activities) {
            if (!activity.getID().equals(ID)) continue;
            return activity;
        }
        throw new InvalidActivityInstanceException("\u6d41\u7a0b\u5b9a\u4e49\u91cc\u6ca1\u6709\u7ed9\u5b9a\u53f7\u7684\u6d3b\u52a8\u5b9a\u4e49\uff1a\u6d41\u7a0b\u5b9a\u4e49=" + this.name + "\u6d3b\u52a8\u5b9a\u4e49\u53f7=" + ID);
    }

    public ProcessInstance createInstance(Session session, String id) {
        ProcessInstance ins = new ProcessInstance(this, id);
        ins.setState("\u5f00\u59cb");
        session.persist((Object)ins);
        VarInstance vi = ins.getVars().iterator().next();
        session.persist((Object)vi);
        return ins;
    }

    public ActivityDef getStartActivity() {
        return this.activities.getFirst();
    }

    public List<DiversionDef> getDiversions() {
        return this.diversions;
    }

    public DiversionDef getDiverison(ActivityDef head, ActivityDef tail) {
        for (DiversionDef diversion : this.diversions) {
            if (!diversion.getHead().getID().equals(head.getID()) || !diversion.getTail().getID().equals(tail.getID()) || diversion.getType().equals("\u7ed3\u675f")) continue;
            return diversion;
        }
        return null;
    }

    public DiversionDef getDiversionDefById(String id) {
        for (int i = 0; i < this.getDiversions().size(); ++i) {
            DiversionDef diversionDef = this.getDiversions().get(i);
            if (!diversionDef.getID().equals(id)) continue;
            return diversionDef;
        }
        return null;
    }

    public void setDiagram(Diagram diagram) {
        try {
            Document document;
            this.clearList();
            String context = diagram.getContext();
            try (StringReader reader = new StringReader(context);){
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = builder.parse(new InputSource(reader));
            }
            NodeList wnl = document.getElementsByTagName("WorkflowDiagram");
            Element e = (Element)wnl.item(0);
            this.setElement(e);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d41\u7a0b\u6587\u4ef6" + diagram.getName() + "\u751f\u6210Document\u65f6\u51fa\u73b0\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public void setElement(Element e) {
        List oldActors = (List)this.actors.clone();
        this.actors.clear();
        List oldActivities = (List)this.activities.clone();
        this.activities.clear();
        List oldDiversions = (List)this.diversions.clone();
        this.diversions.clear();
        this.vars.clear();
        this.loadItems(e, oldActors, oldActivities, oldDiversions);
    }

    private void loadItems(Element e, List<ActorDef> oldActors, List<ActivityDef> oldActivities, List<DiversionDef> oldDiversions) {
        Element ee;
        int i;
        NodeList nl = e.getElementsByTagName("Actor");
        for (i = 0; i < nl.getLength(); ++i) {
            ee = (Element)nl.item(i);
            ActorDef actor = (ActorDef)this.getDefByID(oldActors.iterator(), ee.getAttribute("id"));
            if (e.getTagName().equals("invalids")) {
                log.debug("load actor:{}", (Object)ee.getAttribute("id"));
            }
            if (actor == null) {
                actor = new ActorDef(ee);
            } else {
                actor.setElement(ee);
            }
            this.actors.add(actor);
            NodeList children = ee.getElementsByTagName("Activity");
            for (int j = 0; j < children.getLength(); ++j) {
                Element child = (Element)children.item(j);
                ActivityDef activity = (ActivityDef)this.getDefByID(oldActivities.iterator(), child.getAttribute("id"));
                if (e.getTagName().equals("invalids")) {
                    log.debug("load activity:{}", (Object)child.getAttribute("id"));
                }
                if (activity == null) {
                    activity = new ActivityDef(actor, this, child);
                } else {
                    activity.setElement(child);
                }
                if (child.hasAttribute("personexpression")) {
                    String personExpression = child.getAttribute("personexpression");
                    activity.setPersonExpression(personExpression);
                }
                if (child.hasAttribute("timeout")) {
                    String timeout = child.getAttribute("timeout");
                    activity.setTimeout(timeout);
                }
                if (child.hasAttribute("nodetype")) {
                    String nodetype = child.getAttribute("nodetype");
                    activity.setNodetype(nodetype);
                }
                actor.setActivities(activity);
                this.activities.add(activity);
            }
        }
        log.debug("actors end.");
        nl = e.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("Diversion")) continue;
            ee = (Element)nl.item(i);
            try {
                ActivityDef headDef = this.getActivity(ee.getAttribute("head"));
                ActivityDef tailDef = this.getActivity(ee.getAttribute("tail"));
                DiversionDef def = (DiversionDef)this.getDefByID(oldDiversions.iterator(), ee.getAttribute("id"));
                if (def == null) {
                    def = new DiversionDef(headDef, tailDef, ee);
                } else {
                    def.setElement(ee);
                }
                this.diversions.add(def);
                continue;
            }
            catch (InvalidActivityInstanceException ex) {
                log.error("error diversion is: {}", (Object)ee.getAttribute("id"));
                throw ex;
            }
        }
        log.debug("diversions end.");
        nl = e.getChildNodes();
        for (i = 0; i < nl.getLength(); ++i) {
            if (!nl.item(i).getNodeName().equals("Var")) continue;
            ee = (Element)nl.item(i);
            VarDef varDef = new VarDef(ee);
            this.vars.add(varDef);
        }
        log.debug("diversions end.");
    }

    private FlowDef getDefByID(Iterator<? extends FlowDef> v, String ID) {
        while (v.hasNext()) {
            FlowDef def = v.next();
            if (!def.getID().equals(ID)) continue;
            return def;
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void clearList() {
        this.activities.clear();
        this.actors.clear();
        this.diversions.clear();
    }

    public ActivityDef getActivityByName(String name) {
        for (ActivityDef activity : this.activities) {
            if (!activity.name.equals(name)) continue;
            return activity;
        }
        return null;
    }

    public List<ActivityDef> getActivities() {
        return this.activities;
    }

    public List<ActorDef> getActors() {
        return this.actors;
    }

    public ActorDef getActorByActivityId(String id) {
        for (ActorDef actor : this.actors) {
            for (ActivityDef act : actor.getActivities()) {
                if (!act.ID.equals(id)) continue;
                return actor;
            }
        }
        return null;
    }
}

