/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.workflow.perform;

import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.v3.apply.plugin.ApplyUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class PersonService {
    public static void Run(String organization, String personExpression, Session session, String username, String userid) {
        if ("".equals(personExpression)) {
            return;
        }
        String realPerson = PersonService.getActorid(personExpression);
        PersonService.sessionDel(session, realPerson, organization);
        HashSet<Map<String, Object>> persons = new HashSet();
        String name = "";
        Map<String, HashSet<Map<String, Object>>> actor = (HashMap<String, String>)session.get("t_actor", (Object)realPerson);
        if (actor != null) {
            session.evict((Object)actor);
            actor = (Map)session.get("t_actor", (Object)realPerson);
            persons = (Set)actor.get("f_person");
        } else {
            actor = new HashMap<String, String>();
            actor.put("id", (HashSet<Map<String, Object>>)((Object)realPerson));
        }
        if (personExpression.startsWith("PI")) {
            name = personExpression.substring(3, personExpression.length() - 1);
            String str = "{source: 'this', userid: '" + name + "'}";
            PersonService.getPerson(persons, str, organization);
        } else if (personExpression.startsWith("P")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userid", name);
            map.put("userseq", name);
            map.put("org", organization);
            persons.add(map);
        } else if (personExpression.startsWith("D")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String str = "{source: 'this.getParentByName($" + organization + "$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            PersonService.getPerson(persons, str, organization);
        } else if (personExpression.startsWith("I")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String[] ids = name.split(",");
            PersonService.getPersonList(persons, ids);
        } else if (personExpression.startsWith("RS")) {
            String[] roles;
            name = personExpression.substring(3, personExpression.length() - 1);
            for (String role : roles = name.split(",")) {
                String str = "{source: 'this.getParentByName($" + organization + "$).getChildByName($" + role + "$).getChildren()', userid: '" + userid + "'}";
                PersonService.getPerson(persons, str, organization);
            }
        } else if (personExpression.startsWith("R")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String str = "{source: 'this.getParentByName($" + organization + "$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            PersonService.getPerson(persons, str, organization);
        } else {
            personExpression = PersonService.getExpression(personExpression);
            PersonService.getPerson(persons, personExpression, organization);
        }
        actor.put("f_person", persons);
        actor.put("res", (HashSet<Map<String, Object>>)((Object)name));
        session.saveOrUpdate("t_actor", actor);
    }

    public static void Run(String personExpression, Session session, String username, String userid) {
        if ("".equals(personExpression)) {
            return;
        }
        String realPerson = PersonService.getActorid(personExpression);
        HashMap<String, Object> actor = (HashMap<String, Object>)session.get("t_actor", (Object)realPerson);
        if (actor != null) {
            session.remove((Object)actor);
        } else {
            actor = new HashMap<String, Object>();
            actor.put("id", realPerson);
        }
        HashSet<Map<String, Object>> persons = new HashSet<Map<String, Object>>();
        String name = "";
        if (personExpression.startsWith("PI")) {
            name = personExpression.substring(3, personExpression.length() - 1);
            String str = "{source: 'this', userid: '" + name + "'}";
            PersonService.getPerson(persons, str);
        } else if (personExpression.startsWith("P")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userid", name);
            map.put("userseq", name);
            persons.add(map);
        } else if (personExpression.startsWith("D")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String str = "{source: 'this.getParentByType($organization$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            PersonService.getPerson(persons, str);
        } else if (personExpression.startsWith("I")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String[] ids = name.split(",");
            PersonService.getPersonList(persons, ids);
        } else if (personExpression.startsWith("RS")) {
            String[] roles;
            name = personExpression.substring(3, personExpression.length() - 1);
            for (String role : roles = name.split(",")) {
                String str = "{source: 'this.getParentByType($organization$).getChildByName($" + role + "$).getChildren()', userid: '" + userid + "'}";
                PersonService.getPerson(persons, str);
            }
        } else if (personExpression.startsWith("R")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String str = "{source: 'this.getParentByType($organization$).getChildByName($" + name + "$).getChildren()', userid: '" + userid + "'}";
            PersonService.getPerson(persons, str);
        } else {
            personExpression = PersonService.getExpression(personExpression);
            PersonService.getPerson(persons, personExpression);
        }
        actor.put("f_person", persons);
        actor.put("res", name);
        if (session.get("t_actor", (Object)actor.get("id").toString()) != null) {
            session.evict(session.get("t_actor", (Object)actor.get("id").toString()));
        }
        session.saveOrUpdate("t_actor", actor);
    }

    public static void Run(String personExpression, Session session) {
        if ("".equals(personExpression)) {
            return;
        }
        String realPerson = PersonService.getActorid(personExpression);
        HashMap<String, Object> actor = new HashMap<String, Object>();
        actor.put("id", realPerson);
        HashSet<Map<String, Object>> persons = new HashSet<Map<String, Object>>();
        String name = "";
        if (personExpression.startsWith("P")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("userid", name);
            map.put("userseq", name);
            persons.add(map);
        } else if (personExpression.startsWith("D")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String str = "{source: 'tool.getChildrenOfResName($" + name + "$)', userid: ''}";
            PersonService.getPerson(persons, str);
            PersonService.sessionDel(session, personExpression);
        } else if (personExpression.startsWith("I")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String[] ids = name.split(",");
            PersonService.getPersonList(persons, ids);
            PersonService.sessionDel(session, personExpression);
        } else if (personExpression.startsWith("R")) {
            name = personExpression.substring(2, personExpression.length() - 1);
            String str = "{source: 'tool.getChildrenOfResName($" + name + "$)', userid: ''}";
            PersonService.getPerson(persons, str);
            PersonService.sessionDel(session, personExpression);
        } else {
            personExpression = PersonService.getExpression(personExpression);
            PersonService.getPerson(persons, personExpression);
            PersonService.sessionDel(session, realPerson);
        }
        actor.put("f_person", persons);
        actor.put("res", name);
        session.saveOrUpdate("t_actor", actor);
    }

    public static boolean isInteger(String str) {
        Pattern pattern = Pattern.compile("^[-+]?\\d*$");
        return pattern.matcher(str).matches();
    }

    public static void sessionDel(Session session, String str) {
        str = str.replaceAll("'", "''");
        String hql = "DELETE t_actorperson WHERE  actorid='" + str + "'";
        NativeQuery query = session.createNativeQuery(hql);
        query.executeUpdate();
    }

    public static void sessionDel(Session session, String str, String organization) {
        str = str.replaceAll("'", "''");
        String hql = "DELETE t_actorperson WHERE actorid = '" + str + "' and org = '" + organization + "'";
        NativeQuery query = session.createNativeQuery(hql);
        query.executeUpdate();
    }

    public static Set<Map<String, Object>> getPersonList(Set<Map<String, Object>> persons, String[] str) {
        for (String s : str) {
            String resstr = "{source: 'tool.getChildrenOfResId($" + s + "$)', userid: ''}";
            String url = ApplyUtils.getUrl();
            String actual = RestTools.post((String)(url + "/rs/search"), (String)resstr, (String)new JSONObject().toString());
            if (actual.contains("status: ")) continue;
            Object json = new JSONTokener(actual).nextValue();
            if (json instanceof JSONObject) {
                JSONObject obj = (JSONObject)json;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userseq", obj.getString("id"));
                map.put("userid", obj.getString("name"));
                persons.add(map);
                continue;
            }
            if (!(json instanceof JSONArray)) continue;
            JSONArray arr = new JSONArray(actual);
            for (int i = 0; i < arr.length(); ++i) {
                JSONObject obj = arr.getJSONObject(i);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userseq", obj.getString("id"));
                map.put("userid", obj.getString("name"));
                persons.add(map);
            }
        }
        return persons;
    }

    public static Set<Map<String, Object>> getPerson(Set<Map<String, Object>> persons, String str) {
        String url = ApplyUtils.getUrl();
        String actual = RestTools.post((String)(url + "/rs/search"), (String)str, (String)new JSONObject().toString());
        if (!actual.contains("status: ")) {
            Object json = new JSONTokener(actual).nextValue();
            if (json instanceof JSONObject) {
                JSONObject obj = (JSONObject)json;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userseq", obj.getString("id"));
                map.put("userid", obj.getString("name"));
                persons.add(map);
            } else if (json instanceof JSONArray) {
                JSONArray arr = new JSONArray(actual);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("userseq", obj.getString("id"));
                    map.put("userid", obj.getString("name"));
                    persons.add(map);
                }
            }
        }
        return persons;
    }

    public static Set<Map<String, Object>> getPerson(Set<Map<String, Object>> persons, String str, String organization) {
        String url = ApplyUtils.getUrl();
        String actual = RestTools.post((String)(url + "/rs/search"), (String)str, (String)new JSONObject().toString());
        if (!actual.contains("status: ")) {
            Object json = new JSONTokener(actual).nextValue();
            if (json instanceof JSONObject) {
                JSONObject obj = (JSONObject)json;
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userseq", obj.getString("id"));
                map.put("userid", obj.getString("name"));
                map.put("org", organization);
                persons.add(map);
            } else if (json instanceof JSONArray) {
                JSONArray arr = new JSONArray(actual);
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("userseq", obj.getString("id"));
                    map.put("userid", obj.getString("name"));
                    map.put("org", organization);
                    persons.add(map);
                }
            }
        }
        return persons;
    }

    public static String getExpression(String personExpression) {
        String str = "";
        if (personExpression != null) {
            str = personExpression.replace("@lt;", "{");
            str = str.replace("@gt;", "}");
            str = str.replace("@amp;", "$");
        }
        return PersonService.getUserid(str, 1);
    }

    public static String getFixEXpression(String personExpression) {
        return PersonService.getUserid(personExpression, 1);
    }

    public static String getUserid(String str, int i) {
        String userid;
        JSONObject json = new JSONObject(str);
        String olduserid = userid = json.getString("userid");
        if (userid.lastIndexOf(".") == userid.length() - 1) {
            userid = userid.substring(0, userid.length() - 1);
            int index = userid.lastIndexOf(".");
            userid = userid.substring(index + 1);
        } else {
            int index = userid.lastIndexOf(".");
            if (index != -1) {
                userid = userid.substring(index + 1);
            }
        }
        if (i == 0) {
            return userid;
        }
        return str.replace(olduserid, userid);
    }

    public static String getActorid(String str) {
        if (str.isEmpty() || str.startsWith("I") || str.startsWith("R") || str.startsWith("P") || str.startsWith("D")) {
            return str;
        }
        str = str.replace("@lt;", "{");
        str = str.replace("@gt;", "}");
        str = str.replace("@amp;", "$");
        str = PersonService.getFixEXpression(str);
        return str;
    }

    public static String getPath() {
        String string;
        block9: {
            String path = "";
            SAXReader read = new SAXReader();
            InputStream input = PersonService.class.getClassLoader().getResourceAsStream("workflow.xml");
            try {
                Document document = read.read(input);
                Element root = document.getRootElement();
                Iterator it = root.elementIterator("url");
                while (it.hasNext()) {
                    Element elm = (Element)it.next();
                    path = elm.attribute("path").getValue();
                }
                string = path;
                if (input == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            input.close();
        }
        return string;
    }
}

