/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.v3.workflow.perform;

import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.v3.apply.plugin.ApplyUtils;
import com.af.v4.v3.workflow.perform.ActivityDef;
import com.af.v4.v3.workflow.perform.DiversionDef;
import com.af.v4.v3.workflow.perform.PersonService;
import com.af.v4.v3.workflow.perform.ProcessDef;
import com.af.v4.v3.workflow.perform.ProcessDefManager;
import com.af.v4.v3.workflow.perform.ProcessInstance;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivityInstance {
    private static final Logger log = LoggerFactory.getLogger(ActivityInstance.class);
    private int id;
    private ActivityDef define;
    private String defid;
    private String defname;
    private String actorexpression;
    private ProcessInstance process;
    private String processName;
    private String parentprocess = null;
    private String state = "";
    private Date sendTime;
    private String senderId = null;
    private String sender = null;
    private String senderOrgid = null;
    private String senderOrg = null;
    private Date finishTime;
    private String finishOrgid = null;
    private String finishOrg = null;
    private String timeout = null;
    private String nodetype = null;
    private Date deadLine;
    private String userid;
    private String person;
    private ActivityInstance foreActivityInstance = null;
    private Set<ActivityInstance> backActivities = new HashSet<ActivityInstance>();

    public ActivityInstance() {
    }

    public ActivityInstance(ActivityDef define, ProcessInstance process, String actorExpression, String sender, String sendid, ActivityInstance foreActivityIns) {
        this.define = define;
        this.defid = define.getID();
        this.process = process;
        this.actorexpression = actorExpression;
        this.processName = this.process.getName();
        this.defname = this.define.getName();
        this.DealTimeout();
        this.setSender(sender);
        this.setSenderId(sendid);
        this.setSendTime(new Date());
        this.foreActivityInstance = foreActivityIns;
        this.state = "\u5f00\u59cb\u6d3b\u52a8";
        process.add(this);
    }

    public ActivityInstance(ActivityDef define, ProcessInstance process, String actorExpression, String sender, String sendid, String senderOrgid, String senderOrg, String finishOrgid, String finishOrg, ActivityInstance foreActivityIns) {
        this.define = define;
        this.defid = define.getID();
        this.process = process;
        this.actorexpression = actorExpression;
        this.processName = this.process.getName();
        this.defname = this.define.getName();
        this.DealTimeout();
        this.setSender(sender);
        this.setSenderId(sendid);
        this.setSenderOrgid(senderOrgid);
        this.setSenderOrg(senderOrg);
        this.setSendTime(new Date());
        this.setFinishOrgid(finishOrgid);
        this.setFinishOrg(finishOrg);
        this.foreActivityInstance = foreActivityIns;
        this.state = "\u5f00\u59cb\u6d3b\u52a8";
        process.add(this);
    }

    public static JSONObject getOrgs(String organization, String userid) throws Exception {
        JSONObject obj = new JSONObject();
        String str = organization == null ? "{source: 'this.getParentByType($organization$)', userid: '" + userid + "'}" : "{source: 'this.getParentByName($" + organization + "$)', userid: '" + userid + "'}";
        log.debug("\u83b7\u53d6\u516c\u53f8\u8868\u8fbe\u5f0f---{}", (Object)str);
        String url = ApplyUtils.getUrl();
        String actual = RestTools.post((String)(url + "/rs/search"), (String)str, (String)new JSONObject().toString());
        log.debug(actual);
        if (!actual.contains("status: ")) {
            Object json = new JSONTokener(actual).nextValue();
            if (json instanceof JSONObject) {
                obj = (JSONObject)json;
                return obj;
            }
            if (json instanceof JSONArray) {
                throw new Exception("\u67e5\u8be2\u5230\u591a\u4e2a\u516c\u53f8");
            }
        } else {
            throw new Exception("\u8bf7\u6c42\u5931\u8d25");
        }
        return obj;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    public boolean DealTimeout() {
        try {
            String timeflag = this.define.getTimeout();
            if (timeflag != null && !timeflag.isEmpty()) {
                Date date = new Date();
                log.debug("\u53d6\u5f97\u8d85\u65f6\u6807\u5fd7---{}[{}]", (Object)this.define.getName(), (Object)timeflag);
                int i = Integer.parseInt(timeflag.substring(timeflag.indexOf("(") + 1, timeflag.indexOf(")")));
                if (timeflag.startsWith("ss")) {
                    Integer sec = i;
                    long time = (long)sec.intValue() * 1000L;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(sec + "\u79d2");
                } else if (timeflag.startsWith("mm")) {
                    Integer min = i;
                    long time = (long)min.intValue() * 1000L * 60L;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(min + "\u5206\u949f");
                } else if (timeflag.startsWith("HH")) {
                    Integer hour = i;
                    long time = (long)hour.intValue() * 1000L * 60L * 60L;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(hour + "\u5c0f\u65f6");
                } else if (timeflag.startsWith("dd")) {
                    Integer day = i;
                    long time = (long)day.intValue() * 1000L * 60L * 60L * 24L;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(day + "\u5929");
                } else {
                    log.debug("\u65e0\u6cd5\u8bc6\u522b\u8d85\u65f6\u6807\u5fd7---{}[{}]", (Object)this.define.getName(), (Object)timeflag);
                }
            } else {
                log.debug("\u65e0\u8d85\u65f6\u6807\u5fd7\u4f4d---{}", (Object)this.define.getName());
                return false;
            }
            return true;
        }
        catch (Exception e) {
            log.debug("\u5904\u7406\u8d85\u65f6\u76f8\u5173\u51fd\u6570DealTimeout\u51fa\u73b0\u5f02\u5e38---{}", (Object)e.getMessage());
            return false;
        }
    }

    public Set<ActivityInstance> getActivities() {
        return this.backActivities;
    }

    public void add(ActivityInstance activity) {
        this.backActivities.add(activity);
    }

    public ProcessInstance getProcess() {
        return this.process;
    }

    public void setProcess(ProcessInstance process) {
        this.process = process;
    }

    public ActivityDef getDefine() {
        if (this.define != null) {
            return this.define;
        }
        ProcessDef pDef = this.getProcess().getDefine();
        if (pDef == null) {
            throw new RuntimeException("\u6d3b\u52a8\u5b9e\u4f8b\u627e\u4e0d\u5230\u6d41\u7a0b\u5b9a\u4e49");
        }
        return pDef.getActivity(this.defid);
    }

    public void setDefine(ActivityDef define) {
        this.define = define;
    }

    public synchronized JSONObject finish(Session session, String username, String userid) throws Exception {
        String organization = this.process.getVarValue("organization");
        JSONObject finishOrg = ActivityInstance.getOrgs(organization, userid);
        JSONObject senderOrg = ActivityInstance.getOrgs(null, userid);
        JSONObject json = new JSONObject();
        JSONArray next = new JSONArray();
        ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(this.processName);
        ActivityDef actDef = procDef.getActivity(this.defid);
        List<DiversionDef> linkedList = actDef.getSplits();
        if (!linkedList.isEmpty()) {
            boolean transe = false;
            for (DiversionDef divDef : linkedList) {
                List<ActivityInstance> list;
                ActivityDef tailDef = divDef.getTail();
                String expression = divDef.getExpression();
                if (expression != null && !expression.isEmpty() && this.process.getExpressionValue(expression).equals(Boolean.FALSE)) continue;
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("\u4f1a\u7b7e") && tailDef.getJoins().size() > 1 && (list = this.process.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")).size() > 1) {
                    json.put("f_service_acitivity_id", this.getId());
                    json.put("next", (Object)next);
                    this.state = "\u7ed3\u675f";
                    this.setPerson(username);
                    this.setUserid(userid);
                    this.setFinishTime(new Date());
                    session.merge((Object)this);
                    continue;
                }
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("\u5408\u5e76") && tailDef.getJoins().size() > 1 && (list = this.process.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")).size() > 1) {
                    for (ActivityInstance o : list) {
                        o.setState("\u7ed3\u675f");
                        o.setPerson(username);
                        o.setUserid(userid);
                        o.setFinishTime(new Date());
                        session.merge((Object)o);
                    }
                }
                String exp = tailDef.getPersonExpression();
                exp = (String)this.process.getExpressionValue("$" + exp);
                PersonService.Run(finishOrg.getString("name"), exp, session, username, userid);
                String actorExp = PersonService.getActorid(exp);
                ActivityInstance actIns = new ActivityInstance(tailDef, this.process, actorExp, username, userid, senderOrg.getString("id"), senderOrg.getString("name"), finishOrg.getString("id"), finishOrg.getString("name"), this);
                session.persist((Object)actIns);
                next.put((Object)actIns.getJson());
                transe = true;
            }
            if (transe) {
                json.put("f_service_acitivity_id", this.getId());
                json.put("next", (Object)next);
                this.state = "\u7ed3\u675f";
                this.setPerson(username);
                this.setUserid(userid);
                this.setFinishTime(new Date());
                session.merge((Object)this);
                return json;
            }
            return json;
        }
        if (actDef.getNodetype() != null && actDef.getNodetype().equals("\u7ed3\u675f")) {
            json.put("f_service_acitivity_id", this.getId());
            json.put("next", (Object)next);
            this.state = "\u7ed3\u675f";
            this.setPerson(username);
            this.setUserid(userid);
            this.setFinishTime(new Date());
            session.merge((Object)this);
            return json;
        }
        return json;
    }

    public synchronized JSONObject finish(Session session) {
        JSONObject json = new JSONObject();
        JSONArray next = new JSONArray();
        ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(this.processName);
        ActivityDef actDef = procDef.getActivity(this.defid);
        List<DiversionDef> linkedList = actDef.getSplits();
        if (!linkedList.isEmpty()) {
            boolean transe = false;
            for (DiversionDef divDef : linkedList) {
                List<ActivityInstance> list;
                ActivityDef tailDef = divDef.getTail();
                String expression = divDef.getExpression();
                if (expression != null && !expression.isEmpty() && this.process.getExpressionValue(expression).equals(Boolean.FALSE)) continue;
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("\u4f1a\u7b7e") && tailDef.getJoins().size() > 1 && (list = this.process.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")).size() > 1) {
                    json.put("f_service_acitivity_id", this.getId());
                    json.put("next", (Object)next);
                    this.state = "\u7ed3\u675f";
                    this.setFinishTime(new Date());
                    session.merge((Object)this);
                    continue;
                }
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("\u5408\u5e76") && tailDef.getJoins().size() > 1 && (list = this.process.getActivitiesByState("\u5f00\u59cb\u6d3b\u52a8")).size() > 1) {
                    for (ActivityInstance o : list) {
                        o.setState("\u7ed3\u675f");
                        o.setFinishTime(new Date());
                        session.merge((Object)o);
                    }
                }
                String exp = tailDef.getPersonExpression();
                exp = (String)this.process.getExpressionValue("$" + exp);
                PersonService.Run(exp, session);
                String actorExp = PersonService.getActorid(exp);
                ActivityInstance actIns = new ActivityInstance(tailDef, this.process, actorExp, null, null, this);
                session.persist((Object)actIns);
                next.put((Object)actIns.getJson());
                transe = true;
            }
            if (transe) {
                json.put("f_service_acitivity_id", this.getId());
                json.put("next", (Object)next);
                this.state = "\u7ed3\u675f";
                this.setFinishTime(new Date());
                session.merge((Object)this);
                return json;
            }
            return json;
        }
        if (actDef.getNodetype() != null && actDef.getNodetype().equals("\u7ed3\u675f")) {
            json.put("f_service_acitivity_id", this.getId());
            json.put("next", (Object)next);
            this.state = "\u7ed3\u675f";
            this.setFinishTime(new Date());
            session.merge((Object)this);
            return json;
        }
        return json;
    }

    public synchronized void finish(Session session, String personExpression, String username, String userid) {
        JSONArray array = new JSONArray(personExpression);
        JSONObject firstObj = array.getJSONObject(0);
        String data = firstObj.getString("data");
        JSONObject dataObj = new JSONObject(data);
        this.state = "\u7ed3\u675f";
        this.setPerson(username);
        this.setUserid(userid);
        this.setFinishTime(new Date());
        ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(this.processName);
        ActivityDef actDef = procDef.getActivity(this.defid);
        for (DiversionDef divDef : actDef.getSplits()) {
            String processid;
            ActivityDef tailDef = divDef.getTail();
            this.process.putVar(dataObj);
            String expression = divDef.getExpression();
            if (expression != null && !expression.isEmpty() && this.process.getExpressionValue(expression).equals(Boolean.FALSE)) continue;
            String dename = tailDef.getName();
            int ct = this.getstate(dename, session, processid = dataObj.get("id").toString());
            if (ct >= 1) {
                log.info("\u6d41\u7a0b\u5df2\u5b58\u5728");
                return;
            }
            log.info("\u6dfb\u52a0\u4e0b\u4e00\u6b65\u6d41\u7a0b");
            String exp = tailDef.getPersonExpression();
            if (dataObj.has(tailDef.getName())) {
                exp = dataObj.getString(tailDef.getName());
            }
            PersonService.Run(exp, session);
            ActivityInstance actIns = new ActivityInstance(tailDef, this.process, PersonService.getActorid(exp), username, userid, this);
            session.persist((Object)actIns);
        }
        session.merge((Object)this);
    }

    public int getstate(String dename, Session session, String acitityid) {
        String Sql = "select id,defname,state count from activityins where defname='%s' and processid='%s' and state = '\u5f00\u59cb\u6d3b\u52a8'".formatted(dename, acitityid);
        return session.createNativeQuery(Sql).list().size();
    }

    public String getName() {
        return this.getDefine().getName();
    }

    public String getProcessName() {
        return this.getDefine().getProcess().getName();
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getFormatTime(String time) {
        Object result = time.length() < 2 ? "0" + time : time;
        return result;
    }

    public void suspend() {
        if (this.getState().equals("\u5f00\u59cb\u6d3b\u52a8")) {
            this.setState("\u6302\u8d77");
        }
    }

    public void resume() {
        if (this.getState().equals("\u6302\u8d77")) {
            this.setState("\u5f00\u59cb\u6d3b\u52a8");
        }
    }

    public void setStateForSynchron(String state) {
        this.state = state;
    }

    public ActivityInstance getForeActivityInstance() {
        return this.foreActivityInstance;
    }

    public void setForeActivityInstance(ActivityInstance foreActivityInstance) {
        this.foreActivityInstance = foreActivityInstance;
    }

    public Date getDeadLine() {
        return this.deadLine;
    }

    public void setDeadLine(Date deadLine) {
        this.deadLine = deadLine;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getNodetype() {
        return this.nodetype;
    }

    public void setNodetype(String nodetype) {
        this.nodetype = nodetype;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<ActivityInstance> getBackActivities() {
        return this.backActivities;
    }

    public void setBackActivities(Set<ActivityInstance> backActivities) {
        this.backActivities = backActivities;
    }

    public String getDefid() {
        return this.defid;
    }

    public void setDefid(String defid) {
        this.defid = defid;
    }

    public String getDefname() {
        return this.defname;
    }

    public void setDefname(String defname) {
        this.defname = defname;
    }

    public String getParentprocess() {
        return this.parentprocess;
    }

    public void setParentprocess(String parentprocess) {
        this.parentprocess = parentprocess;
    }

    public String getActorexpression() {
        return this.actorexpression;
    }

    public void setActorexpression(String actorexpression) {
        this.actorexpression = actorexpression;
    }

    public Date getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Date getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getPerson() {
        return this.person;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public String getUserid() {
        return this.userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getSenderId() {
        return this.senderId;
    }

    public void setSenderId(String sendId) {
        this.senderId = sendId;
    }

    public String getSenderOrgid() {
        return this.senderOrgid;
    }

    public void setSenderOrgid(String senderOrgid) {
        this.senderOrgid = senderOrgid;
    }

    public String getSenderOrg() {
        return this.senderOrg;
    }

    public void setSenderOrg(String senderOrg) {
        this.senderOrg = senderOrg;
    }

    public String getFinishOrgid() {
        return this.finishOrgid;
    }

    public void setFinishOrgid(String finishOrgid) {
        this.finishOrgid = finishOrgid;
    }

    public String getFinishOrg() {
        return this.finishOrg;
    }

    public void setFinishOrg(String finishOrg) {
        this.finishOrg = finishOrg;
    }

    public JSONObject getJson() {
        JSONObject json = new JSONObject();
        json.put("id", this.id);
        json.put("processid", (Object)this.process.getId());
        json.put("defid", (Object)this.defid);
        json.put("defname", (Object)this.defname);
        json.put("sendTime", (Object)this.sendTime);
        json.put("senderId", (Object)this.senderId);
        json.put("sender", (Object)this.sender);
        json.put("deadLine", (Object)this.deadLine);
        json.put("nodetype", (Object)this.nodetype);
        json.put("timeout", (Object)this.timeout);
        json.put("finishTime", (Object)this.finishTime);
        json.put("userid", (Object)this.userid);
        json.put("state", (Object)this.state);
        String previd = "";
        if (this.foreActivityInstance != null) {
            previd = this.foreActivityInstance.getDefid();
        }
        json.put("previd", (Object)previd);
        return json;
    }
}

