package com.af.v4.v3.workflow.perform;

import com.af.v4.system.common.plugins.http.RestTools;
import com.af.v4.v3.apply.plugin.ApplyUtils;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 活动实例
 */
public class ActivityInstance {
    private final static Logger log = LoggerFactory.getLogger(ActivityInstance.class);
    /**
     * 活动ID号
     */
    private int id;

    /**
     * 活动定义
     */
    private ActivityDef define;

    private String defid;

    /**
     * 活动定义名称
     */
    private String defname;

    /**
     * process
     * 执行者表达式
     */
    private String actorexpression;

    /**
     * 流程实例
     */
    private ProcessInstance process;

    /**
     * 流程名称
     */
    private String processName;

    /**
     * 父流程
     */
    private String parentprocess = null;

    /**
     * 活动状态
     */
    private String state = "";

    private Date sendTime;


    /**
     * 发送人id
     */
    private String senderId = null;

    /**
     * 发送人名称
     */
    private String sender = null;

    /**
     * 发送公司
     */
    private String senderOrgid = null;
    private String senderOrg = null;


    private Date finishTime;

    /**
     * 目标公司
     */
    private String finishOrgid = null;
    private String finishOrg = null;

    /**
     * 超时设置
     */
    private String timeout = null;
    /**
     * 节点类型
     */
    private String nodetype = null;

    private Date deadLine;

    /**
     * 活动执行人id
     */
    private String userid;

    /**
     * 活动执行人名称
     */
    private String person;

    /**
     * 上一个活动实例
     */
    private ActivityInstance foreActivityInstance = null;

    /**
     * 后面的活动实例列表
     */
    private Set<ActivityInstance> backActivities = new HashSet<>();

    /**
     * 默认构造，Hibernate必须
     */
    public ActivityInstance() {

    }
    /**
     * 采用活动定义、流程实例以及活动参与者ID号构造
     *
     * @param define          活动定义
     * @param process         流程实例
     * @param actorExpression 活动参与者
     */
    public ActivityInstance(ActivityDef define, ProcessInstance process,
                            String actorExpression, String sender, String sendid,
                            ActivityInstance foreActivityIns) {
        this.define = define;
        this.defid = define.getID();
        this.process = process;
        this.actorexpression = actorExpression;

        this.processName = this.process.getName();
        this.defname = this.define.getName();
        //处理超时相关
        this.DealTimeout();
        // 活动发送人，发送时间
        this.setSender(sender);
        this.setSenderId(sendid);
        this.setSendTime(new Date());

        this.foreActivityInstance = foreActivityIns;
        // 设置活动状态
        state = "开始活动";
        // 添加到流程中
        process.add(this);
    }

    public ActivityInstance(ActivityDef define, ProcessInstance process,
                            String actorExpression, String sender, String sendid,
                            String senderOrgid, String senderOrg, String finishOrgid, String finishOrg,
                            ActivityInstance foreActivityIns) {
        this.define = define;
        this.defid = define.getID();
        this.process = process;
        this.actorexpression = actorExpression;

        this.processName = this.process.getName();
        this.defname = this.define.getName();
        //处理超时相关
        this.DealTimeout();
        // 活动发送人，发送时间
        this.setSender(sender);
        this.setSenderId(sendid);
        this.setSenderOrgid(senderOrgid);
        this.setSenderOrg(senderOrg);
        this.setSendTime(new Date());

        // 目标处理公司
        this.setFinishOrgid(finishOrgid);
        this.setFinishOrg(finishOrg);

        this.foreActivityInstance = foreActivityIns;
        // 设置活动状态
        state = "开始活动";
        // 添加到流程中
        process.add(this);
    }

    public static JSONObject getOrgs(String organization, String userid) throws Exception {
        JSONObject obj = new JSONObject();

        String str;

        if (organization == null) {
            str = "{source: 'this.getParentByType($organization$)', userid: '" + userid + "'}";
        } else {
            str = "{source: 'this.getParentByName($" + organization + "$)', userid: '" + userid + "'}";
        }

        log.debug("获取公司表达式---{}", str);
        String url = ApplyUtils.getUrl();
        String actual = RestTools.post( url + "/rs/search", str, new JSONObject().toString());

        log.debug(actual);
        if (!actual.contains("status: ")) {
            Object json = new JSONTokener(actual).nextValue();
            if (json instanceof JSONObject) {
                obj = (JSONObject) json;
                return obj;
            } else if (json instanceof JSONArray) {
                throw new Exception("查询到多个公司");
            }
        } else {
            throw new Exception("请求失败");
        }
        return obj;
    }

    public String getSender() {
        return sender;
    }

    public void setSender(String sender) {
        this.sender = sender;
    }

    /**
     * 处理超时相关
     */
    public boolean DealTimeout() {
        try {
            //得到超时时间标志位
            String timeflag = this.define.getTimeout();
            if (timeflag != null && !timeflag.isEmpty()) {
                Date date = new Date();
                log.debug("取得超时标志---{}[{}]", this.define.getName(), timeflag);
                int i = Integer.parseInt(timeflag.substring(timeflag.indexOf("(") + 1, timeflag.indexOf(")")));
                if (timeflag.startsWith("ss")) {
                    Integer sec = i;
                    long time = (long) sec * 1000;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(sec + "秒");
                } else if (timeflag.startsWith("mm")) {
                    Integer min = i;
                    long time = (long) min * 1000 * 60;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(min + "分钟");
                } else if (timeflag.startsWith("HH")) {
                    Integer hour = i;
                    long time = (long) hour * 1000 * 60 * 60;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(hour + "小时");

                } else if (timeflag.startsWith("dd")) {
                    Integer day = i;
                    long time = (long) day * 1000 * 60 * 60 * 24;
                    this.setDeadLine(new Date(date.getTime() + time));
                    this.setTimeout(day + "天");
                } else {
                    log.debug("无法识别超时标志---{}[{}]", this.define.getName(), timeflag);
                }
            } else {
                log.debug("无超时标志位---{}", this.define.getName());
                return false;
            }
            return true;
        } catch (Exception e) {
            log.debug("处理超时相关函数DealTimeout出现异常---{}", e.getMessage());
            return false;
        }
    }

    /**
     * 得到后继活动
     *
     * @return 后继活动列表
     */
    public Set<ActivityInstance> getActivities() {
        return backActivities;
    }

    /**
     * 添加后继活动
     *
     * @param activity 后继活动
     */
    public void add(ActivityInstance activity) {
        this.backActivities.add(activity);
    }

    /**
     * 得到流程实例
     */
    public ProcessInstance getProcess() {
        return process;
    }

    public void setProcess(ProcessInstance process) {
        this.process = process;
    }

    /**
     * 得到活动定义
     *
     * @return 活动定义
     */
    public ActivityDef getDefine() {
        if (this.define != null) {
            return this.define;
        }
        // 如果为空重新装在，根据流程定义ｉｄ得到流程定义
        ProcessDef pDef = this.getProcess().getDefine();
        if (pDef == null) {
            throw new RuntimeException("活动实例找不到流程定义");
        }
        return pDef.getActivity(this.defid);
    }

    public void setDefine(ActivityDef define) {
        this.define = define;
    }

    /**
     * 尝试结束活动，只要有一个转移线满足条件，活动就进行转移
     */
    public synchronized JSONObject finish(Session session, String username, String userid) throws Exception {
        String organization = this.process.getVarValue("organization");

        JSONObject finishOrg = getOrgs(organization, userid);
        JSONObject senderOrg = getOrgs(null, userid);

        //创建返回的活动JSON对象
        JSONObject json = new JSONObject();

        JSONArray next = new JSONArray();

        // 根据每个转移创建任务和活动
        ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(processName);
        // 当前活动定义
        ActivityDef actDef = procDef.getActivity(defid);
        // 后续转移活动
        List<DiversionDef> linkedList = actDef.getSplits();

        // 具有后续转移活动
        if (!linkedList.isEmpty()) {
            // 是否往后转移了
            boolean transe = false;
            for (DiversionDef divDef : linkedList) {
                ActivityDef tailDef = divDef.getTail();
                // 如果不满足表达式条件，继续下一个
                String expression = divDef.getExpression();
                if (expression != null && !expression.isEmpty() && this.process.getExpressionValue(expression).equals(Boolean.FALSE)) {
                    continue;
                }

                // 会签
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("会签") && tailDef.getJoins().size() > 1) {
                    List<ActivityInstance> list = this.process.getActivitiesByState("开始活动");
                    if (list.size() > 1) {
                        // 如果还有没有完成的活动，不能转移，将转移交于后面活动
                        // 向返回的JSON对象中添加活动编号属性
                        json.put("f_service_acitivity_id", this.getId());
                        json.put("next", next);
                        state = "结束";
                        // 设置完成人，完成时间
                        this.setPerson(username);
                        this.setUserid(userid);
                        this.setFinishTime(new Date());
                        session.merge(this);
                        continue;
                    }
                }

                // 并行
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("合并") && tailDef.getJoins().size() > 1) {
                    List<ActivityInstance> list = this.process.getActivitiesByState("开始活动");
                    if (list.size() > 1) {
                        for (ActivityInstance o : list) {
                            o.setState("结束");
                            o.setPerson(username);
                            o.setUserid(userid);
                            o.setFinishTime(new Date());
                            session.merge(o);
                        }
                    }
                }
                // 根据人员表达式，产生人员对照表
                String exp = tailDef.getPersonExpression();
                exp = (String) this.process.getExpressionValue("$" + exp);
                PersonService.Run(finishOrg.getString("name"), exp, session, username, userid);
                // 用于计算的表达式与实际保存的不同，当从ldap取人员时，实际保存的简化了
                String actorExp = PersonService.getActorid(exp);
                ActivityInstance actIns = new ActivityInstance(
                        tailDef, process, actorExp, username, userid, senderOrg.getString("id"), senderOrg.getString("name"), finishOrg.getString("id"), finishOrg.getString("name"), this);
                session.persist(actIns);
                next.put(actIns.getJson());
                transe = true;
            }
            // 如果转移了，让当前活动结束
            if (transe) {
                //向返回的JSON对象中添加活动编号属性
                json.put("f_service_acitivity_id", this.getId());
                json.put("next", next);
                state = "结束";
                // 设置完成人，完成时间
                this.setPerson(username);
                this.setUserid(userid);
                this.setFinishTime(new Date());
                session.merge(this);
                return json;
            }
            return json;
        }
        // 当前活动如果没有转移活动且当前活动类型为结束直接结束
        if (actDef.getNodetype() != null && actDef.getNodetype().equals("结束")) {
            //向返回的JSON对象中添加活动编号属性
            json.put("f_service_acitivity_id", this.getId());
            json.put("next", next);
            state = "结束";
            // 设置完成人，完成时间
            this.setPerson(username);
            this.setUserid(userid);
            this.setFinishTime(new Date());
            session.merge(this);
            return json;
        }
        return json;
    }

    /**
     * 尝试结束活动，只要有一个转移线满足条件，活动就进行转移
     */
    public synchronized JSONObject finish(Session session) {

        //创建返回的活动JSON对象
        JSONObject json = new JSONObject();

        JSONArray next = new JSONArray();

        // 根据每个转移创建任务和活动
        ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(processName);
        // 当前活动定义
        ActivityDef actDef = procDef.getActivity(defid);
        // 后续转移活动
        List<DiversionDef> linkedList = actDef.getSplits();

        // 具有后续转移活动
        if (!linkedList.isEmpty()) {
            // 是否往后转移了
            boolean transe = false;
            for (DiversionDef divDef : linkedList) {
                ActivityDef tailDef = divDef.getTail();
                // 如果不满足表达式条件，继续下一个
                String expression = divDef.getExpression();
                if (expression != null && !expression.isEmpty() && this.process.getExpressionValue(expression).equals(Boolean.FALSE)) {
                    continue;
                }

                // 会签
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("会签") && tailDef.getJoins().size() > 1) {
                    List<ActivityInstance> list = this.process.getActivitiesByState("开始活动");
                    if (list.size() > 1) {
                        // 如果还有没有完成的活动，不能转移，将转移交于后面活动
                        // 向返回的JSON对象中添加活动编号属性
                        json.put("f_service_acitivity_id", this.getId());
                        json.put("next", next);
                        state = "结束";
                        this.setFinishTime(new Date());
                        session.merge(this);
                        continue;
                    }
                }

                // 并行
                if (tailDef.getNodetype() != null && tailDef.getNodetype().equals("合并") && tailDef.getJoins().size() > 1) {
                    List<ActivityInstance> list = this.process.getActivitiesByState("开始活动");
                    if (list.size() > 1) {
                        for (ActivityInstance o : list) {
                            o.setState("结束");
                            o.setFinishTime(new Date());
                            session.merge(o);
                        }
                    }
                }
                // 根据人员表达式，产生人员对照表
                String exp = tailDef.getPersonExpression();
                exp = (String) this.process.getExpressionValue("$" + exp);
                PersonService.Run(exp, session);
                // 用于计算的表达式与实际保存的不同，当从ldap取人员时，实际保存的简化了
                String actorExp = PersonService.getActorid(exp);
                ActivityInstance actIns = new ActivityInstance(
                        tailDef, process, actorExp, null, null, this);
                session.persist(actIns);
                next.put(actIns.getJson());
                transe = true;
            }
            // 如果转移了，让当前活动结束
            if (transe) {
                //向返回的JSON对象中添加活动编号属性
                json.put("f_service_acitivity_id", this.getId());
                json.put("next", next);
                state = "结束";
                // 设置完成人，完成时间
                this.setFinishTime(new Date());
                session.merge(this);
                return json;
            }
            return json;
        }
        // 当前活动如果没有转移活动且当前活动类型为结束直接结束
        if (actDef.getNodetype() != null && actDef.getNodetype().equals("结束")) {
            //向返回的JSON对象中添加活动编号属性
            json.put("f_service_acitivity_id", this.getId());
            json.put("next", next);
            state = "结束";
            // 设置完成人，完成时间
            this.setFinishTime(new Date());
            session.merge(this);
            return json;
        }
        return json;
    }

    /**
     * 结束活动
     */
    public synchronized void finish(Session session, String personExpression,
                                    String username, String userid) {
        // 解析传递过来的对象属性
        JSONArray array = new JSONArray(personExpression);
        JSONObject firstObj = array.getJSONObject(0);
        final String data = firstObj.getString("data");
        JSONObject dataObj = new JSONObject(data);

        // 把前台传过来的，活动对应的人员，转换成json串
        state = "结束";
        // 设置完成人，完成时间
        this.setPerson(username);
        this.setUserid(userid);
        this.setFinishTime(new Date());
        // 根据每个转移创建任务和活动
        ProcessDef procDef = ProcessDefManager.getInstance().getProcessDef(
                processName);
        ActivityDef actDef = procDef.getActivity(defid);
        for (DiversionDef divDef : actDef.getSplits()) {
            ActivityDef tailDef = divDef.getTail();

            // 给流程中的变量赋值
            this.process.putVar(dataObj);

            // 如果不满足表达式条件，继续下一个
            String expression = divDef.getExpression();
            if (expression != null && !expression.isEmpty()
                    && this.process.getExpressionValue(expression).equals(Boolean.FALSE)) {
                continue;
            }
            // 拿到当前流程的processid 和 下一步的流程名称
            String dename = tailDef.getName();
            String processid = dataObj.get("id").toString();
            int ct = getstate(dename, session, processid);
            if (ct >= 1) {
                log.info("流程已存在");
                return;
            } else {
                log.info("添加下一步流程");
                // 根据人员表达式，产生人员对照表
                String exp = tailDef.getPersonExpression();
                if (dataObj.has(tailDef.getName())) {
                    exp = dataObj.getString(tailDef.getName());
                }
                PersonService.Run(exp, session);

                ActivityInstance actIns = new ActivityInstance(tailDef,
                        process, PersonService.getActorid(exp), username, userid, this);

                session.persist(actIns);
            }

        }
        session.merge(this);
    }

    public int getstate(String dename, Session session, String acitityid) {
        final String Sql = "select id,defname,state count from activityins where defname='%s' and processid='%s' and state = '开始活动'"
                .formatted(dename, acitityid);
        return session.createNativeQuery(Sql).list().size();
    }

    /**
     * 得到活动名称
     */
    public String getName() {
        return this.getDefine().getName();
    }

    /**
     * 得到活动所属流程名称
     */
    public String getProcessName() {
        return this.getDefine().getProcess().getName();
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getState() {
        return state;
    }

    /**
     * 设置状态
     */
    public void setState(String state) {
        this.state = state;
    }

    /**
     * 得到标准的时间格式，即每年是4位的，月， 日，时，分，秒都是2位的
     */
    public String getFormatTime(String time) {
        String result;
        if (time.length() < 2) {
            result = "0" + time;
        } else {
            result = time;
        }
        return result;
    }

    /**
     * 挂起活动
     */
    public void suspend() {
        if (this.getState().equals("开始活动")) {
            this.setState("挂起");
        }
    }

    /**
     * 重启活动
     */
    public void resume() {
        if (this.getState().equals("挂起")) {
            this.setState("开始活动");
        }
    }

    public void setStateForSynchron(String state) {
        this.state = state;
    }

    public ActivityInstance getForeActivityInstance() {
        return this.foreActivityInstance;
    }

    public void setForeActivityInstance(ActivityInstance foreActivityInstance) {
        this.foreActivityInstance = foreActivityInstance;
    }

    public Date getDeadLine() {
        return deadLine;
    }

    public void setDeadLine(Date deadLine) {
        this.deadLine = deadLine;
    }

    public String getTimeout() {
        return timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getNodetype() {
        return nodetype;
    }

    public void setNodetype(String nodetype) {
        this.nodetype = nodetype;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<ActivityInstance> getBackActivities() {
        return backActivities;
    }

    public void setBackActivities(Set<ActivityInstance> backActivities) {
        this.backActivities = backActivities;
    }

    public String getDefid() {
        return defid;
    }

    public void setDefid(String defid) {
        this.defid = defid;
    }

    public String getDefname() {
        return defname;
    }

    public void setDefname(String defname) {
        this.defname = defname;
    }

    public String getParentprocess() {
        return parentprocess;
    }

    public void setParentprocess(String parentprocess) {
        this.parentprocess = parentprocess;
    }

    public String getActorexpression() {
        return actorexpression;
    }

    public void setActorexpression(String actorexpression) {
        this.actorexpression = actorexpression;
    }

    public Date getSendTime() {
        return sendTime;
    }

    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    public Date getFinishTime() {
        return finishTime;
    }

    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    public String getPerson() {
        return person;
    }

    public void setPerson(String person) {
        this.person = person;
    }

    public String getUserid() {
        return userid;
    }

    public void setUserid(String userid) {
        this.userid = userid;
    }

    public String getSenderId() {
        return senderId;
    }

    public void setSenderId(String sendId) {
        this.senderId = sendId;
    }

    public String getSenderOrgid() {
        return senderOrgid;
    }

    public void setSenderOrgid(String senderOrgid) {
        this.senderOrgid = senderOrgid;
    }

    public String getSenderOrg() {
        return senderOrg;
    }

    public void setSenderOrg(String senderOrg) {
        this.senderOrg = senderOrg;
    }

    public String getFinishOrgid() {
        return finishOrgid;
    }

    public void setFinishOrgid(String finishOrgid) {
        this.finishOrgid = finishOrgid;
    }

    public String getFinishOrg() {
        return finishOrg;
    }

    public void setFinishOrg(String finishOrg) {
        this.finishOrg = finishOrg;
    }

    public JSONObject getJson() {
        JSONObject json = new JSONObject();
        json.put("id", this.id);
        json.put("processid", this.process.getId());
        json.put("defid", this.defid);
        json.put("defname", this.defname);
        json.put("sendTime", this.sendTime);
        json.put("senderId", this.senderId);
        json.put("sender", this.sender);
        json.put("deadLine", this.deadLine);
        json.put("nodetype", this.nodetype);
        json.put("timeout", this.timeout);
        json.put("finishTime", this.finishTime);
        json.put("userid", this.userid);
        json.put("state", this.state);
        //上一个流程id
        String previd = "";
        if (this.foreActivityInstance != null) {
            previd = this.foreActivityInstance.getDefid();
        }
        json.put("previd", previd);
        return json;
    }
}
