package com.af.v4.v3.workflow.controller;

import com.af.v4.system.common.jpa.session.SessionPool;
import com.af.v4.v3.workflow.perform.*;
import org.hibernate.Session;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.w3c.dom.Element;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 动态运行部分的主服务类
 */
@Deprecated(
        since = "1.0.0"
)
@RestController
@RequestMapping({"/workflow"})
@Transactional
public class Server {
    private final SessionPool sessionPool;

    public Server(SessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    /**
     * 启动流程
     *
     * @param name 流程名
     * @return 流程id
     */
    @GetMapping(value = {"startprocess/{name}"})
    public String txstartProcess(@PathVariable("name") String name) {
        try {
            // 得到流程定义
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(
                    name);
            if (process == null) {
                throw new RuntimeException("流程不存在：名字=" + name);
            }
            Session session = sessionPool.getSession();
            // 产生流程实例
            String processId = UUID.randomUUID().toString();
            ProcessInstance procIns = process.createInstance(session, processId);
            return procIns.getId();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 开始一个活动
     *
     * @param processid 流程实例id
     * @param name      要开始的活动名称
     * @return 开始的活动的id
     */
    @GetMapping(value = {"startactivity/{processid}/{name}"})
    public String txstartActivity(@PathVariable("processid") String processid, @PathVariable("name") String name) {
        try {
            Session session = sessionPool.getSession();
            ProcessInstance procIns = session.get(ProcessInstance.class, processid);
            ProcessDef process = procIns.getDefine();
            // 获取活动定义
            ActivityDef activity = process.getActivityByName(name);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, "", null, null, null);
            session.save(actIns);
            return actIns.getId() + "";
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 开始一个活动
     *
     * @param processid 流程实例id
     * @param name      要开始的活动名称
     * @param username  操作人用户名
     * @param userid    操作人id
     * @return 开始的活动的id
     */
    @GetMapping(value = {"startactivity/{processid}/{name}/{username}/{userid}"})
    public int txstartActivity(@PathVariable("processid") String processid, @PathVariable("name") String name, @PathVariable("username") String username, @PathVariable("userid") String userid) {
        try {
            Session session = sessionPool.getSession();
            ProcessInstance procIns = session.get(ProcessInstance.class, processid);
            ProcessDef process = procIns.getDefine();
            // 获取活动定义
            ActivityDef activity = process.getActivityByName(name);
            String exp = activity.getPersonExpression();

            ActivityInstance actIns = new ActivityInstance(activity, procIns, activity.getPersonExpression(), username, userid, null);

            JSONObject org = ActivityInstance.getOrgs(null, userid);
            actIns.setSenderOrg(org.getString("name"));
            actIns.setSenderOrgid(org.getString("id"));
            actIns.setFinishOrg(org.getString("name"));
            actIns.setFinishOrgid(org.getString("id"));

            exp = (String) actIns.getProcess().getExpressionValue("$" + exp);
            PersonService.Run(org.getString("name"), exp, session, username, userid);

            System.out.println("============");
            System.out.println(actIns);
            session.save(actIns);
            return actIns.getId();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 开始一个活动
     *
     * @param processid 流程实例id
     * @param name      要开始的活动名称
     * @param vars      变量
     * @param username  操作人用户名
     * @param userid    操作人id
     * @return 开始的活动的id
     */
    @GetMapping(value = {"startactivity/{processid}/{name}/{vars}/{username}/{userid}"})
    public int txstartActivity(@PathVariable("processid") String processid, @PathVariable("name") String name, @PathVariable("vars") String vars,
                               @PathVariable("username") String username, @PathVariable("userid") String userid) {
        try {
            Session session = sessionPool.getSession();
            ProcessInstance procIns = session.get(ProcessInstance.class, processid);
            procIns.putVar(new JSONObject(vars));
            ProcessDef process = procIns.getDefine();
            // 获取活动定义
            ActivityDef activity = process.getActivityByName(name);

            String exp = activity.getPersonExpression();
            exp = (String) procIns.getExpressionValue("$" + exp);

            JSONObject org = ActivityInstance.getOrgs(null, userid);
            PersonService.Run(org.getString("name"), exp, session, username, userid);

            // 用于计算的表达式与实际保存的不同，当从ldap取人员时，实际保存的简化了
            String actorExp = PersonService.getActorid(exp);
            ActivityInstance actIns = new ActivityInstance(activity, procIns, actorExp, username, userid, null);
            actIns.setSenderOrg(org.getString("name"));
            actIns.setSenderOrgid(org.getString("id"));
            actIns.setFinishOrg(org.getString("name"));
            actIns.setFinishOrgid(org.getString("id"));

            session.save(actIns);
            return actIns.getId();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * 给流程设置变量值
     */
    @PostMapping(
            value = {"setvars/{processid}/{username}/{userid}"},
            produces = {"application/json"}
    )
    public String txsetVars(
            @PathVariable("processid") String processid,
            @PathVariable("username") String username,
            @PathVariable("userid") String userid,
            @RequestBody(required = false) String vars
    ) {
        ttxsetVars(processid, vars, username, userid);
        return "ok";
    }

    /**
     * 给流程设置变量值
     *
     * @param defid     当前操作活动节点id
     * @param processid 流程id
     * @param vars      变量值
     * @param username  用户名
     * @param userid    用户id
     */
    public JSONObject ttxsetVars(
            String defid,
            String processid,
            String vars,
            String username,
            String userid
    ) {
        try {
            //创建要返回的JSON对象
            JSONObject jsob;

            JSONObject json = new JSONObject(vars);
            Session session = sessionPool.getSession();
            ProcessInstance procIns = session.get(ProcessInstance.class, processid);
            procIns.putVar(json);

            // 根据活动节点id获取活动
            ActivityInstance act = procIns.getActivitiesByDefid(defid);

            jsob = act.finish(session, username, userid);

            return jsob;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 给流程设置变量值
     *
     * @param actid     当前操作活动id
     * @param processid 流程id
     * @param vars      变量值
     * @param username  用户名
     * @param userid    用户id
     */
    public JSONObject ttxsetVars(
            int actid,
            String processid,
            String vars,
            String username,
            String userid
    ) {
        try {
            //创建要返回的JSON对象
            JSONObject jsob;

            JSONObject json = new JSONObject(vars);
            Session session = sessionPool.getSession();
            ProcessInstance procIns = session.get(ProcessInstance.class, processid);
            procIns.putVar(json);

            // 根据活动id获取活动
            ActivityInstance act = procIns.getActivitiesByActid(actid);

            jsob = act.finish(session, username, userid);

            return jsob;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 给流程设置变量值
     */
    public JSONObject ttxsetVars(
            String processid,
            String vars,
            String username,
            String userid
    ) {
        try {
            //创建要返回的JSON对象
            JSONObject jsob = new JSONObject();
            JSONObject json = new JSONObject(vars);
            Session session = sessionPool.getSession();
            ProcessInstance procIns = session.get(ProcessInstance.class, processid);
            procIns.putVar(json);
            // 获取流程所有待办活动
            for (ActivityInstance obj : procIns.getActivitiesByState("开始活动")) {
                // 让每个活动尝试结束
                jsob = obj.finish(session, username, userid);
            }
            return jsob;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 给流程设置变量值
     */
    public JSONObject ttxsetVars(String processid, String vars) {
        try {
            //创建要返回的JSON对象
            JSONObject jsob = new JSONObject();
            JSONObject json = new JSONObject(vars);
            Session session = sessionPool.getSession();
            ProcessInstance procIns = session.get(ProcessInstance.class, processid);
            procIns.putVar(json);
            // 获取流程所有待办活动
            for (ActivityInstance obj : procIns.getActivitiesByState("开始活动")) {
                // 让每个活动尝试结束
                jsob = obj.finish(session);
            }
            return jsob;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取流程中所有待办事项
     *
     * @param processid 流程编号
     * @return JSON格式待办事项
     */
    @GetMapping(value = {"getwait/{processid}"})
    public String txgetWait(@PathVariable("processid") String processid) {
        JSONArray result = new JSONArray();

        Session session = sessionPool.getSession();
        ProcessInstance procIns = session.get(ProcessInstance.class, processid);

        // 获得所有待办
        for (ActivityInstance actIns : procIns.getActivitiesByState("开始活动")) {
            // 把每一个待办转换成JSON对象
            JSONObject json = new JSONObject();
            json.put("defid", actIns.getDefid());
            json.put("defname", actIns.getDefname());
            result.put(json);
        }

        return result.toString();
    }

    /**
     * 获取流程工作流程图
     *
     * @param processid 流程编号
     * @return JSON格式待办事项
     */
    @GetMapping(value = {"getWFGraph/{processid}"})
    public String txgetWFGraph(@PathVariable("processid") String processid) {
        //定义点集
        JSONObject res = new JSONObject();
        JSONArray spotlist = new JSONArray();
        Session session = sessionPool.getSession();
        ProcessInstance procIns = session.get(ProcessInstance.class, processid);
        // 获得所有待办
        for (ActivityInstance actIns : procIns.getAllActivities()) {
            // 把每一个待办转换成JSON对象
            spotlist.put(actIns.getJson());
        }
        //获取点和线
        res.put("spots", this.getSpots(procIns));
        res.put("lines", this.getLines(procIns));
        return res.toString();
    }

    /**
     * 获取点
     */
    public JSONArray getSpots(ProcessInstance procIns) {
        Map<String, JSONObject> spotmap = new HashMap<>();
        JSONArray Spots = new JSONArray();
        //获取流程定义
        ProcessDef pdef = procIns.getDefine();
        // 获得所有办过的数据
        for (ActivityInstance actIns : procIns.getAllActivities()) {
            // 把每一个待办转换成JSON对象
            JSONObject json = actIns.getJson();
            if (!spotmap.containsKey(json.getString("defid"))) {
                spotmap.put(json.getString("defid"), json);
            }
        }
        //处理为进行的数据
        for (ActivityDef act : pdef.getActivities()) {
            //初始化json
            JSONObject json = new JSONObject();
            json.put("defid", act.getID());
            json.put("defname", act.getName());
            json.put("state", "未执行");
            if (!spotmap.containsKey(json.getString("defid"))) {
                spotmap.put(json.getString("defid"), json);
            }
        }
        // 获取值集合的迭代器
        for (JSONObject jsonObject : spotmap.values()) {
            Spots.put(jsonObject);
        }
        return Spots;
    }

    /**
     * 获取线
     */
    public JSONArray getLines(ProcessInstance procIns) {
        JSONArray Lines = new JSONArray();
        //获取流程定义
        ProcessDef pdef = procIns.getDefine();
        for (DiversionDef diversion : pdef.getDiversions()) {
            // 把每一个待办转换成JSON对象
            JSONObject json = new JSONObject();
            json.put("start", diversion.getHead().getID());
            json.put("end", diversion.getTail().getID());
            Lines.put(json);
        }
        return Lines;
    }

    /**
     * 启动流程
     *
     * @param name 流程名称
     * @return 启动流程后的HTML片断
     */
    @PostMapping(
            value = {"startprocess/{name}/{username}/{userid}"},
            produces = {"application/json"}
    )
    public String txStartProcess(@PathVariable("name") String name,
                                 @PathVariable("username") String username,
                                 @PathVariable("userid") String userid,
                                 @RequestBody(required = false) String personExpression) {
        try {
            //解析传递过来的对象属性
            JSONArray array = new JSONArray(personExpression);
            JSONObject firstObj = array.getJSONObject(0);
            final String data = firstObj.getString("data");
            JSONObject dataObj = new JSONObject(data);
            String processId = dataObj.getString("id");

            Session session = sessionPool.getSession();
            // 得到流程定义
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(
                    name);
            if (process == null) {
                throw new RuntimeException("流程不存在：名字=" + name);
            }
            ActivityDef activity = process.getStartActivity();
            if (activity == null) {
                throw new RuntimeException("流程没有开始活动：名字=" + name);
            }
            // 产生流程实例
            ProcessInstance procIns = process.createInstance(session, processId);

            // 产生活动实例,前一个活动实例为空
            ActivityInstance actIns = new ActivityInstance(activity, procIns,
                    "", username, userid, null);
            session.save(actIns);
            actIns.finish(session, personExpression, username, userid);
            JSONObject okObject = new JSONObject();
            okObject.put("ok", "ok");
            return okObject.toString();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 启动流程
     *
     * @param name     流程名称
     * @param username 流程启动者
     * @return 启动流程后的HTML片断
     */
    @PostMapping(
            value = {"startWork/{name}/{username}/{userid}"},
            produces = {"application/json"}
    )
    public String txstartWork(@PathVariable("name") String name,
                              @PathVariable("username") String username,
                              @PathVariable("userid") String userid,
                              @RequestBody(required = false) String personExpression) {
        try {
            //解析传递过来的对象属性
            JSONObject dataObj = new JSONObject(personExpression);
            String processId = dataObj.getString("id");

            Session session = sessionPool.getSession();
            // 得到流程定义
            ProcessDef process = ProcessDefManager.getInstance().getProcessDef(
                    name);
            if (process == null) {
                throw new RuntimeException("流程不存在：名字=" + name);
            }
            ActivityDef activity = process.getStartActivity();
            if (activity == null) {
                throw new RuntimeException("流程没有开始活动：名字=" + name);
            }
            // 产生流程实例
            ProcessInstance procIns = process.createInstance(session, processId);

            // 产生活动实例,前一个活动实例为空
            ActivityInstance actIns = new ActivityInstance(activity, procIns,
                    "", username, userid, null);
            session.save(actIns);
            JSONObject result = new JSONObject();
            result.put("procIns", procIns.getId());
            result.put("actIns", actIns.getId());
            result.put("actName", actIns.getName());
            return result.toString();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 执行活动
     */
    @PostMapping(
            value = {"perfomactivity/{acitityid}/{username}/{userid}"},
            produces = {"application/json"}
    )
    public String txperformActivity(@PathVariable("acitityid") String acitityid,
                                    @PathVariable("username") String username,
                                    @PathVariable("userid") String userid,
                                    @RequestBody(required = false) String personExpression) {
        try {
            Session session = sessionPool.getSession();
            ActivityInstance actIns = session.load(ActivityInstance.class, acitityid);
            actIns.finish(session, personExpression, username, userid);
            //判断活动已结束，不执行,防止重复
            if (actIns.getState().equals("结束")) {
                JSONObject error = new JSONObject();
                error.put("error", "已结束");
                return error.toString();
            }
            JSONObject okObject = new JSONObject();
            okObject.put("ok", "ok");
            return okObject.toString();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 获取给定活动的action内容
     */
    @GetMapping(value = {"action/{acitityid}"})
    public String txgetAction(@PathVariable("acitityid") String acitityid) {
        Session session = sessionPool.getSession();
        ActivityInstance actIns = session.load(ActivityInstance.class, Integer.parseInt(acitityid));
        Element e = actIns.getDefine().getElement();
        if (e.hasAttribute("action")) {
            return e.getAttribute("action");
        } else {
            return "";
        }
    }

    /**
     * 终止流程
     *
     * @param acitityid HTTP请求，包含活动ID号
     * @return 提示页面片断
     */
    @PostMapping(
            value = {"stop/{acitityid}"},
            produces = {"application/json"}
    )
    public String txStopProcess(@PathVariable("acitityid") String acitityid) {
        try {
            Session session = sessionPool.getSession();
            ActivityInstance actIns = session.load(
                    ActivityInstance.class, acitityid);
            ProcessInstance pi = actIns.getProcess();
            List<ActivityInstance> list = pi.getActivitiesByState("开始活动");
            for (ActivityInstance act : list) {
                act.setState("终止ֹ");
                session.update(act);
            }
            pi.stop();
            session.update(pi);
            JSONObject result = new JSONObject();
            result.put("procIns", pi.getName());
            result.put("actIns", actIns.getName());
            return result.toString();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
