package com.af.v4.v3.apply.plugin;

import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.plugins.json.JsonTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class Import {

    private static JSONObject addresConfig = null;
    @Autowired
    private ServiceNoGenerator serviceNoGenerator;

    private static void getConfig() {
        if (addresConfig == null) {

            JSONObject json = new JSONObject();
            json.put("f_building_suffix", "号楼");
            json.put("f_unit_suffix", "单元");
            json.put("f_floor_suffix", "层");
            json.put("f_room_suffix", "室");
            json.put("code", 200);
            addresConfig = json;

        }
    }

    public JSONObject addUserFileByAddress(JSONObject apply, JSONObject user, JSONObject useraddres, JSONObject userfile, EntityService entity, SqlService sql) throws Exception {
        JSONObject result = new JSONObject();

        if (!StringUtils.hasLength(useraddres.optString("f_address"))) {
            result.put("type", "error");
            result.put("msg", "地址不存在");
            return result;
        }

        // 查询地址
        JSONObject params = new JSONObject();
        params.put("tablename", "t_user_address");
        params.put("condition", "f_address_state != '作废' and f_process_id = '" + apply.get("f_process_id") + "' and f_address = '" + useraddres.get("f_address") + "'");
        JSONArray jsonArray = sql.query("apply_singleTable", params);
        if (jsonArray.isEmpty()) {
            result.put("type", "error");
            result.put("msg", "地址不存在");
            return result;
        }
        JSONObject address;
        address = jsonArray.getJSONObject(0);

        // 判断气表品牌
        if (!StringUtils.hasLength(userfile.optString("gasbrand"))) {
            result.put("type", "error");
            result.put("msg", "气表品牌不存在");
            return result;
        }
        /*
         * 判断有无气表类型
         * 当气表品牌名称是唯一的，不需要气表类型
         * 当具有多个名称相同得气表品牌，需要气表类型
         */

        String sqlStr;
        if (StringUtils.hasLength(userfile.optString("f_meter_type"))) {
            sqlStr = "select a.* " +
                    "from t_gasbrand a,t_gasbrand_orgid b " +
                    "where a.id = b.f_gasbrand_id " +
                    "and a.f_meter_brand = '" +
                    userfile.get("gasbrand") +
                    "' and a.f_meter_type = '" +
                    userfile.get("f_meter_type") +
                    "' and b.f_using_orgid = '" +
                    user.get("orgid") +
                    "'";
        } else {
            sqlStr = "select a.* " +
                    "from t_gasbrand a,t_gasbrand_orgid b " +
                    "where a.id = b.f_gasbrand_id " +
                    "and a.f_meter_brand = '" +
                    userfile.get("gasbrand") +
                    "' and b.f_using_orgid = '" +
                    user.get("orgid") +
                    "'";
        }
        jsonArray = sql.querySQL("queryGasbrand", sqlStr);
        if (jsonArray.length() <= 0) {
            result.put("type", "error");
            result.put("msg", "气表品牌不存在");
            return result;
        }
        if (jsonArray.length() > 1) {
            result.put("type", "error");
            result.put("msg", "气表品牌存在多个，请携带气表类型");
            return result;
        }
        userfile.put("f_gasbrand_id", jsonArray.getJSONObject(0).get("id"));
        userfile.put("f_meter_classify", jsonArray.getJSONObject(0).get("f_meter_type"));

        // 判断气表型号
        if (!StringUtils.hasLength(userfile.optString("gasmodel"))) {
            result.put("type", "error");
            result.put("msg", "气表型号不存在");
            return result;
        }
        params.put("tablename", "t_gasmodel");
        params.put("condition", "f_gasbrand_id = '" + userfile.get("f_gasbrand_id") + "' and f_meter_style || f_type = '" + userfile.get("gasmodel") + "'");
        jsonArray = sql.query("apply_singleTable", params);
        if (jsonArray.length() <= 0) {
            result.put("type", "error");
            result.put("msg", "气表品牌下无此气表型号");
            return result;
        }
        if (jsonArray.length() > 1) {
            result.put("type", "error");
            result.put("msg", "气表型号存在多个");
            return result;
        }
        userfile.put("f_gasmodel_id", jsonArray.getJSONObject(0).get("id"));

        if (!StringUtils.hasLength(userfile.optString("f_meternumber"))) {
            result.put("type", "error");
            result.put("msg", "表号不存在");
            return result;
        }
        sqlStr = "select * from t_userfiles " +
                "where f_meternumber = '" +
                userfile.get("f_meternumber") +
                "' and f_gasbrand_id = '" +
                userfile.get("f_gasbrand_id") +
                "' and (f_table_state = '正常' or f_table_state = '待开通')";
        jsonArray = sql.querySQL("queryUserfiles", sqlStr);
        if (!jsonArray.isEmpty()) {
            result.put("type", "error");
            result.put("msg", "表号已存在");
            return result;
        }

        params.put("tablename", "t_userfiles");
        params.put("condition", "f_userinfo_id = '" + address.get("f_userinfo_id") + "' and f_table_state = '待开通'");
        jsonArray = sql.query("apply_singleTable", params);
        if (!jsonArray.isEmpty()) {
            userfile = JsonTools.addJSON(jsonArray.getJSONObject(0), userfile);
        } else {
            userfile.put("f_useraddress_id", address.get("id"));
            userfile.put("f_user_id", serviceNoGenerator.getNo("f_user_id", 0));
            userfile.put("f_filialeid", user.get("orgid"));
            userfile.put("f_orgid", user.get("orgid"));
            userfile.put("f_orgname", user.get("orgs"));
            userfile.put("f_depid", user.get("depids"));
            userfile.put("f_depname", user.get("deps"));
            userfile.put("f_operatorid", user.get("id"));
            userfile.put("f_operator", user.get("name"));

        }
        userfile.put("f_adjustable_id", userfile.get("f_adjustable_id"));
        userfile.put("f_table_state", "待开通");
        userfile.put("f_install_person", user.optString("name"));
        userfile.put("f_install_date", DateTools.getNow2());


        // 防止一户多表
        params.put("tablename", "t_userfiles");
        params.put("condition", "f_useraddress_id = '" + address.get("id") + "' and f_table_state = '待开通'" + " and f_gasbrand_id is not null ");
        jsonArray = sql.query("apply_singleTable", params);
        if (!jsonArray.isEmpty()) {
            result.put("type", "error");
            result.put("msg", "该地址档案中已经存在表具信息，暂不支持一户多表导入失败");
            return result;
        }

        entity.partialSave("t_userfiles", userfile);

        result.put("type", "success");
        result.put("msg", "成功导入");

        return result;
    }

    public JSONObject addAddressAndUserinfo(JSONObject apply, JSONObject user, JSONObject useraddres, JSONObject userinfo, JSONObject userfile, EntityService entity, SqlService sql) throws Exception {
        getConfig();

        JSONObject result = new JSONObject();
        JSONObject data = new JSONObject();

        JSONObject pcd;
        JSONObject street;
        JSONObject area = null;

        // 组织地址数据
        JSONObject saveAddress = new JSONObject();

        // 片区 不存在就为空，后期修正地址
        if (StringUtils.hasLength(useraddres.optString("f_slice_area"))) {
            saveAddress.put("f_slice_area", useraddres.get("f_slice_area"));
        }

        // 省市区
        if (!StringUtils.hasLength(useraddres.optString("f_pcd"))) {
            result.put("type", "error");
            result.put("msg", "区县不存在");
            return result;
        }
        JSONObject params = new JSONObject();
        params.put("tablename", "t_pcd");
        params.put("condition", "f_orgid = '" + user.get("orgid") + "' and f_pcd = '" + useraddres.get("f_pcd") + "'");
        JSONArray jsonArray = sql.query("apply_singleTable", params);
        if (jsonArray.isEmpty()) {
            result.put("type", "error");
            result.put("msg", "区县不存在");
            return result;
        }
        pcd = jsonArray.getJSONObject(0);
        saveAddress.put("f_pcd", pcd.get("f_pcd"));
        saveAddress.put("f_pcd_id", pcd.get("id"));


        // 街道/乡镇
        if (!StringUtils.hasLength(useraddres.optString("f_street"))) {
            result.put("type", "error");
            result.put("msg", "街道/乡镇不存在");
            return result;
        }
        params.put("tablename", "t_street");
        params.put("condition", "f_orgid = '" + user.get("orgid") + "' and f_street = '" + useraddres.get("f_street") + "' and f_pcd_id = '" + pcd.get("id") + "'");
        jsonArray = sql.query("apply_singleTable", params);
        if (jsonArray.isEmpty()) {
            result.put("type", "error");
            result.put("msg", "街道/乡镇不存在当前区县下");
            return result;
        }
        if (jsonArray.length() > 1) {
            result.put("type", "error");
            result.put("msg", "当前区县下有多个同名街道/乡镇");
            return result;
        }

        street = jsonArray.getJSONObject(0);
        saveAddress.put("f_street", street.get("f_street"));
        saveAddress.put("f_street_id", street.get("id"));


        if (!StringUtils.hasLength(useraddres.optString("f_address_type"))) {
            result.put("type", "error");
            result.put("msg", "地址类型不存在");
            return result;
        }

        StringBuilder f_address = new StringBuilder();
        if ("民用市区".equals(useraddres.optString("f_address_type")) || "民用乡镇".equals(useraddres.optString("f_address_type"))) {
            if ("民用市区".equals(useraddres.optString("f_address_type"))) {
                saveAddress.put("f_address_type", "市区");
                if (!"市区".equals(street.optString("f_iscity"))) {
                    result.put("type", "error");
                    result.put("msg", "该街道/乡镇不是市区类型");
                    return result;
                }
            }
            if ("民用乡镇".equals(useraddres.optString("f_address_type"))) {
                saveAddress.put("f_address_type", "乡镇");
                if (!"乡镇".equals(street.optString("f_iscity"))) {
                    result.put("type", "error");
                    result.put("msg", "该街道/乡镇不是乡镇类型");
                    return result;
                }
            }

            // 集收单位
            if (!StringUtils.hasLength(useraddres.optString("f_residential_area"))) {
                result.put("type", "error");
                result.put("msg", "集收单位不存在");
                return result;
            }
            params.put("tablename", "t_area");
            params.put("condition", "f_orgid = '" + user.get("orgid") + "' and f_residential_area = '" + useraddres.get("f_residential_area") + "' and f_street_id = '" + street.get("id") + "'");
            jsonArray = sql.query("apply_singleTable", params);
            if (jsonArray.isEmpty()) {
                result.put("type", "error");
                result.put("msg", "集收单位不存在当前街道/乡镇下");
                return result;
            }
            if (jsonArray.length() > 1) {
                result.put("type", "error");
                result.put("msg", "当前街道/乡镇下有多个同名集收单位");
                return result;
            }
            area = jsonArray.getJSONObject(0);
            saveAddress.put("f_residential_area", area.get("f_residential_area"));
            saveAddress.put("f_residential_area_id", area.get("id"));

            f_address.append(pcd.optString("f_pcd"));
            f_address.append(street.optString("f_street"));
            f_address.append(area.optString("f_residential_area"));
            if (StringUtils.hasLength(useraddres.optString("f_building"))) {
                f_address.append(useraddres.get("f_building"));
                saveAddress.put("f_building", useraddres.optString("f_building"));

                f_address.append(addresConfig.opt("f_building_suffix"));
                saveAddress.put("f_building_suffix", addresConfig.opt("f_building_suffix"));
            }
            if (StringUtils.hasLength(useraddres.optString("f_unit"))) {
                f_address.append(useraddres.get("f_unit"));
                saveAddress.put("f_unit", useraddres.optString("f_unit"));

                f_address.append(addresConfig.opt("f_unit_suffix"));
                saveAddress.put("f_unit_suffix", addresConfig.opt("f_unit_suffix"));
            }

            if (StringUtils.hasLength(useraddres.optString("f_floor"))) {
                f_address.append(useraddres.get("f_floor"));
                saveAddress.put("f_floor", useraddres.optString("f_floor"));

                f_address.append(addresConfig.opt("f_floor_suffix"));
                saveAddress.put("f_floor_suffix", addresConfig.opt("f_floor_suffix"));
            }

            if (StringUtils.hasLength(useraddres.optString("f_room"))) {
                f_address.append(useraddres.get("f_room"));
                saveAddress.put("f_room", useraddres.optString("f_room"));

                f_address.append(addresConfig.opt("f_room_suffix"));
                saveAddress.put("f_room_suffix", addresConfig.opt("f_room_suffix"));
            } else {
                result.put("type", "error");
                result.put("msg", "门牌号不存在");
                return result;
            }
        }
        if ("特殊地址".equals(useraddres.optString("f_address_type"))) {
            // 特殊地址 地址类型从街道获取
            saveAddress.put("f_address_type", street.optString("f_iscity"));
            saveAddress.put("f_special", 1);

            // 小区
            if (StringUtils.hasLength(useraddres.optString("f_residential_area"))) {
                params.put("tablename", "t_area");
                params.put("condition", "f_orgid = '" + user.get("orgid") + "' and f_residential_area = '" + useraddres.get("f_residential_area") + "' and f_street_id = '" + street.get("id") + "'");
                jsonArray = sql.query("apply_singleTable", params);
                if (jsonArray.isEmpty()) {
                    result.put("type", "error");
                    result.put("msg", "集收单位不存在当前街道/乡镇下");
                    return result;
                }
                if (jsonArray.length() > 1) {
                    result.put("type", "error");
                    result.put("msg", "当前街道/乡镇下有多个同名集收单位");
                    return result;
                }
                area = jsonArray.getJSONObject(0);
                saveAddress.put("f_residential_area", area.get("f_residential_area"));
                saveAddress.put("f_residential_area_id", area.get("id"));
            }

            if (!StringUtils.hasLength(useraddres.optString("f_address"))) {
                result.put("type", "error");
                result.put("msg", "地址不存在");
                return result;
            }
            f_address.append(useraddres.optString("f_address"));
        }

        saveAddress.put("f_address", f_address);

        saveAddress.put("f_address_state", "未通气");
        saveAddress.put("f_create_date", DateTools.getNow2());
        saveAddress.put("f_create_person", user.get("name"));
        saveAddress.put("f_operator", user.get("name"));
        saveAddress.put("f_filialeid", user.get("orgid"));
        saveAddress.put("f_orgid", user.get("orgid"));
        saveAddress.put("f_orgname", user.get("orgs"));
        saveAddress.put("f_depid", user.get("depids"));
        saveAddress.put("f_depname", user.get("parentname"));
        saveAddress.put("f_operatorid", user.get("id"));
        saveAddress.put("f_process_id", apply.getString("f_process_id"));

        // 判断地址是否存在
        params.put("tablename", "t_user_address");
        if ("民用市区".equals(useraddres.optString("f_address_type")) || "民用乡镇".equals(useraddres.optString("f_address_type"))) {
            params.put("condition", "f_address_state != '作废' " + " and f_orgid = '" + user.get("orgid") + "' and f_pcd_id = '" + pcd.get("id") + "' and f_street_id = '" + street.get("id") + "' and f_residential_area_id = '" + area.get("id") + "' and f_building = '" + saveAddress.optString("f_building") + "' and f_unit = '" + saveAddress.optString("f_unit") + "' and f_floor = '" + saveAddress.optString("f_floor") + "' and f_room = '" + saveAddress.optString("f_room") + "'");
        }
        if ("特殊地址".equals(useraddres.optString("f_address_type"))) {
            if (area == null) {
                params.put("condition", "f_address_state != '作废' " + " and f_orgid = '" + user.get("orgid") + "' and f_pcd_id = '" + pcd.get("id") + "' and f_street_id = '" + street.get("id") + "' and f_address = '" + saveAddress.get("f_address") + "'");
            } else {
                params.put("condition", "f_address_state != '作废' " + " and f_orgid = '" + user.get("orgid") + "' and f_pcd_id = '" + pcd.get("id") + "' and f_street_id = '" + street.get("id") + "' and f_residential_area_id = '" + area.get("id") + "' and f_address = '" + saveAddress.optString("f_address") + "'");
            }
        }
        jsonArray = sql.query("apply_singleTable", params);
        if (!jsonArray.isEmpty()) {
            result.put("type", "error");
            result.put("msg", "地址已存在");
            return result;
        }

        JSONObject res = entity.partialSave("t_user_address", saveAddress);
        saveAddress.put("id", res.get("id"));
        String sqlStr;
        userinfo.put("f_user_state", "预备");
        userinfo.put("f_createfile_person", user.get("name"));
        userinfo.put("f_createfile_date", DateTools.getNow2());
        userinfo.put("f_filialeid", user.get("orgid"));
        userinfo.put("f_orgid", user.get("orgid"));
        userinfo.put("f_orgname", user.get("orgs"));
        userinfo.put("f_depid", user.get("depids"));
        userinfo.put("f_depname", user.get("deps"));
        userinfo.put("f_operatorid", user.get("id"));
        userinfo.put("f_of_userinfo_codeperator", user.get("name"));
        userinfo.put("f_process_id", apply.get("f_process_id"));

        if (userfile.isEmpty()) {
            userfile = new JSONObject();
        }
        else {
            // 判断气表品牌
            if (!StringUtils.hasLength(userfile.optString("gasbrand"))) {
                result.put("type", "error");
                result.put("msg", "气表品牌不存在");
                return result;
            }
            /*
             * 判断有无气表类型
             *  当气表品牌名称是唯一的，不需要气表类型
             *  当具有多个名称相同得气表品牌，需要气表类型
             */
            if (StringUtils.hasLength(userfile.optString("f_meter_type"))) {
                sqlStr = "select a.* " +
                        "from t_gasbrand a,t_gasbrand_orgid b " +
                        "where a.id = b.f_gasbrand_id " +
                        "and a.f_meter_brand = '" +
                        userfile.get("gasbrand") +
                        "' and a.f_meter_type = '" +
                        userfile.get("f_meter_type") +
                        "' and b.f_using_orgid = '" +
                        user.get("orgid") +
                        "'";
            } else {
                sqlStr = "select a.* " +
                        "from t_gasbrand a,t_gasbrand_orgid b " +
                        "where a.id = b.f_gasbrand_id " +
                        "and a.f_meter_brand = '" +
                        userfile.get("gasbrand") +
                        "' and b.f_using_orgid = '" +
                        user.get("orgid") +
                        "'";
            }
            jsonArray = sql.querySQL("queryGasbrand", sqlStr);
            if (jsonArray.length() <= 0) {
                result.put("type", "error");
                result.put("msg", "气表品牌不存在");
                return result;
            }
            if (jsonArray.length() > 1) {
                result.put("type", "error");
                result.put("msg", "气表品牌存在多个，请携带气表类型");
                return result;
            }
            userfile.put("f_gasbrand_id", jsonArray.getJSONObject(0).get("id"));
            userfile.put("f_meter_classify", jsonArray.getJSONObject(0).get("f_meter_type"));

            // 判断气表型号
            if (!StringUtils.hasLength(userfile.optString("gasmodel"))) {
                result.put("type", "error");
                result.put("msg", "气表型号不存在");
                return result;
            }
            params.put("tablename", "t_gasmodel");
            params.put("condition", "f_gasbrand_id = '" + userfile.get("f_gasbrand_id") + "' and f_meter_style || f_type = '" + userfile.get("gasmodel") + "'");
            jsonArray = sql.query("apply_singleTable", params);
            if (jsonArray.length() <= 0) {
                result.put("type", "error");
                result.put("msg", "气表品牌下无此气表型号");
                return result;
            }
            if (jsonArray.length() > 1) {
                result.put("type", "error");
                result.put("msg", "气表型号存在多个");
                return result;
            }
            userfile.put("f_gasmodel_id", jsonArray.getJSONObject(0).get("id"));
            // 表号
            if (!StringUtils.hasLength(userfile.optString("f_meternumber"))) {
                result.put("type", "error");
                result.put("msg", "表号不存在");
                return result;
            }
            sqlStr = "select * from t_userfiles " +
                    "where f_meternumber = '" +
                    userfile.get("f_meternumber") +
                    "' and f_gasbrand_id = '" +
                    userfile.get("f_gasbrand_id") +
                    "' and (f_table_state = '正常' or f_table_state = '待开通')";
            jsonArray = sql.querySQL("queryUserfiles", sqlStr);
            if (!jsonArray.isEmpty()) {
                result.put("type", "error");
                result.put("msg", "表号已存在");
                return result;
            }
            // 判断安装日期是否存在
            if (!StringUtils.hasLength(userfile.optString("f_install_date"))) {
                userfile.put("f_install_date", DateTools.getNow2());
            }
        }
        if (apply.has("f_price_id")) {
            if (!apply.get("f_price_id").equals("")) {
                // 气价id
                userfile.put("f_price_id", apply.get("f_price_id"));
                // 用户类型
                userfile.put("f_user_type", apply.get("f_user_type"));
                // 用气性质
                userfile.put("f_gasproperties", apply.get("f_gas_nature"));
            }
        }
        // 表具信息处理
        userfile.put("f_table_state", "待开通");
        userfile.put("f_useraddress_id", saveAddress.get("id"));
        userfile.put("f_user_id", serviceNoGenerator.getNo("f_user_id", 0));
        userfile.put("f_filialeid", user.get("orgid"));
        userfile.put("f_orgid", user.get("orgid"));
        userfile.put("f_orgname", user.get("orgs"));
        userfile.put("f_depid", user.get("depids"));
        userfile.put("f_depname", user.get("deps"));
        userfile.put("f_operatorid", user.get("id"));
        userfile.put("f_operator", user.get("name"));
        if ("工商户报建".equals(apply.getString("f_apply_type"))) {
            userfile.put("f_user_type", "非民用");
        }

        // 防止一户多表
        params.put("tablename", "t_userfiles");
        params.put("condition", "f_useraddress_id = '" + saveAddress.get("id") + "' and f_table_state = '待开通'" + " and f_gasbrand_id is not null ");
        jsonArray = sql.query("apply_singleTable", params);
        if (!jsonArray.isEmpty()) {
            result.put("type", "error");
            result.put("msg", "该地址档案中已经存在表具信息，暂不支持一户多表,导入失败");
            return result;
        }

        res = entity.partialSave("t_userinfo", userinfo);
        String f_userinfo_id = res.getString("f_userinfo_id");

        params.put("tablename", "t_user_address");
        params.put("condition", "id = '" + saveAddress.get("id") + "'");
        jsonArray = sql.query("apply_singleTable", params);
        saveAddress = jsonArray.getJSONObject(0);

        saveAddress.put("f_userinfo_id", f_userinfo_id);
        entity.partialSave("t_user_address", saveAddress);

        userfile.put("f_userinfo_id", f_userinfo_id);
        entity.partialSave("t_userfiles", userfile);

        result.put("type", "success");
        result.put("msg", "成功导入");
        data.put("f_useraddress_id", saveAddress.get("id"));
        data.put("f_userinfo_id", f_userinfo_id);
        data.put("f_userinfo_code", userinfo.get("f_userinfo_code"));
        result.put("data", data);

        return result;
    }

}
