package com.af.v4.v3.apply.plugin;

import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.digest.HMac;
import cn.hutool.crypto.digest.HmacAlgorithm;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.application.service.GlazeApplicationService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.v3.workflow.perform.ActivityDef;
import com.af.v4.v3.workflow.perform.ProcessDef;
import com.af.v4.v3.workflow.perform.ProcessDefManager;
import com.alibaba.fastjson.JSON;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

@Component
@Transactional
public class ApplyUtils {

    private final GlazeApplicationService applicationService;

    private final LiuLiConfigService liuliConfigService;

    private static LiuLiConfigService liuliConfigService2;

    public ApplyUtils(GlazeApplicationService applicationService,LiuLiConfigService liuliConfigService) {
        this.applicationService = applicationService;
        this.liuliConfigService = liuliConfigService;
        this.liuliConfigService2 = liuliConfigService;
    }

    /**
     * 获取节点名称
     *
     * @param name 流程配置文件名
     */
    public static JSONArray getDefnames(String name) {
        JSONArray array = new JSONArray();

        ProcessDef process = ProcessDefManager.getInstance().getProcessDef(name);
        List<ActivityDef> list = process.getActivities();
        list.forEach(item -> {
            JSONObject object = new JSONObject();
            object.put("label", item.getName());
            object.put("value", item.getName());
            array.put(object);
        });

        return array;
    }

    /**
     * 判断类型
     */
    public static String checkType(Object value) {
        return switch (value) {
            case Double ignored -> "Double";
            case String ignored -> "String";
            case Boolean ignored -> "Boolean";
            case Long ignored -> "Long";
            case Integer ignored -> "Integer";
            case Float ignored -> "Float";
            case Short ignored -> "Short";
            case JSONObject ignored -> "JSONObject";
            case null, default -> null;
        };
    }

    public static String toUppercase(String number) {
        double n = Double.parseDouble(number);
        String[] fraction = {"角", "分"};
        String[] digit = {"零", "壹", "贰", "叁", "肆", "伍", "陆", "柒", "捌", "玖"};
        String[][] unit = {{"元", "万", "亿"}, {"", "拾", "佰", "仟"}};

        String head = n < 0 ? "负" : "";
        n = Math.abs(n);

        StringBuilder s = new StringBuilder();
        for (int i = 0; i < fraction.length; i++) {
            s.append((digit[(int) (Math.floor(n * 10 * Math.pow(10, i)) % 10)] + fraction[i]).replaceAll("(零.)+", ""));
        }
        if (s.isEmpty()) {
            s = new StringBuilder("整");
        }
        int integerPart = (int) Math.floor(n);

        for (int i = 0; i < unit[0].length && integerPart > 0; i++) {
            StringBuilder p = new StringBuilder();
            for (int j = 0; j < unit[1].length && n > 0; j++) {
                p.insert(0, digit[integerPart % 10] + unit[1][j]);
                integerPart = integerPart / 10;
            }
            s.insert(0, p.toString().replaceAll("(零.)*零$", "").replaceAll("^$", "零") + unit[0][i]);
        }
        return head + s.toString().replaceAll("(零.)*零元", "元").replaceFirst("(零.)+", "").replaceAll("(零.)+", "零").replaceAll("^整$", "零元整");
    }

    /**
     * 获取编号
     *
     * @param number 起始数字
     * @param prefix 前置
     * @param suffix 后置
     * @param length 长度
     */
    public static String getNumber(Integer number, String prefix, String suffix, Integer length) {
        return prefix + mendNumber(number, 0, length) + suffix;
    }

    /**
     * 补齐数字
     *
     * @param number     起始数字
     * @param supplement 补充数字
     * @param length     长度
     */
    public static String mendNumber(Integer number, Integer supplement, Integer length) {

        String expression = "%";
        expression += supplement;
        expression += length;
        expression += "d";

        return String.format(expression, number);
    }

    /**
     * 返回特殊字符  $
     */
    public static String getSpecialChar(int index) {
        return switch (index) {
            case 0 -> "$";
            case 1 -> "//";
            case 2 -> "-";
            default -> "";
        };
    }

    /**
     * 成武潜能爱山东获取二维码信息
     *
     * @param qrcodeInfo 扫描的二维码信息
     * @param optype     证件类型
     */
    public static String getusinfo(String qrcodeInfo, String optype) {
        String clientId = "be14ac13d60c41af8ce807d5df160164";
        String clientSecret = "eb7d627e661b41f9b58d3c379b04985a";
        String dorg = "100087";

        String url = "https://hzjmm.heze.gov.cn/ymt/api/yanma";

        String timestamp = String.valueOf(System.currentTimeMillis());
        String dsp = UUID.randomUUID().toString().replaceAll("-", "");
        String signature = sm3Sign(clientId, clientSecret, dsp, timestamp);
        // 组装请求头
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("dtimestamp", timestamp);
        headers.set("dorg", dorg);
        headers.set("dsp", dsp);
        headers.set("dsignature", signature);
        // 组装参数
        JSONObject body = new JSONObject();
        body.put("QRCODE", qrcodeInfo);
        body.put("PLACE", "其他");
        body.put("OPTYPE", optype);
        HttpEntity<Object> httpEntity = new HttpEntity<>(body.toString(), headers);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity<String> responseEntity = restTemplate.postForEntity(url, httpEntity, String.class);
        // 接口返回值
        return responseEntity.getBody();
    }

    public static String sm3Sign(String clientid, String secret, String dsp, String timestamp) {
        String rsrt = timestamp.substring(timestamp.length() - 2);
        int r = Integer.parseInt(rsrt);
        if (r == 0) {
            r = 10;
        }
        String source = SmUtil.sm3(clientid + timestamp + dsp + secret);
        for (int i = 0; i < r; i++) {
            source = SmUtil.sm3(source.substring(6, 8) + source);
        }
        return source;
    }

    /**
     * 济宁 金乡 潜能爱山东获取二维码信息
     *
     * @param qrcodeInfo  扫描的二维码信息
     * @param acceptOrgId 用码机构标识
     * @param pinToken    x-sop-signature 的参数：pinToken
     * @param pinId       x-sop-pinId
     * @param url         请求网址
     */
    public static com.alibaba.fastjson.JSONObject getusinfo1(String qrcodeInfo, String acceptOrgId, String pinToken, String pinId, String url) {
        StringBuilder stringBuffer = new StringBuilder();
        String timestamp = System.currentTimeMillis() + "";
        String nonce = genNonce(11);
        stringBuffer.append(timestamp).append(pinToken).append(nonce).append(timestamp);
        // hamcsm3算法
        HMac hmac = new HMac(HmacAlgorithm.HmacSM3, pinToken.getBytes());
        String signature = hmac.digestHex(stringBuffer.toString());
        // 远程请求地址
        HttpPost httpPost = new HttpPost(url);
        JSONObject json = new JSONObject();
        json.put("codeContent", qrcodeInfo);
        json.put("acceptOrgId", acceptOrgId);
        StringEntity requestEntity = new StringEntity(json.toString(), "utf-8");
        requestEntity.setContentEncoding("UTF-8");
        // 准入参数
        httpPost.setHeader("x-sop-pinId", pinId);
        httpPost.setHeader("x-sop-timestamp", timestamp);
        httpPost.setHeader("x-sop-signature", signature);
        httpPost.setHeader("x-sop-nonce", nonce);
        // 请求类型
        httpPost.setHeader("content-type", "application/json");
        // 如需用户信息需要透传token
        httpPost.setHeader("x-sop-sid", "FLZn9QIgOSDXIDbCqxRR2aP33go");
        httpPost.setEntity(requestEntity);
        Header[] requestHeaders = httpPost.getAllHeaders();
        Map<String, String> map = new HashMap<>();
        for (Header header : requestHeaders) {
            String key = header.getName();
            String value = header.getValue();
            map.put(key, value);
        }
        com.alibaba.fastjson.JSONObject jsonObject;
        com.alibaba.fastjson.JSONObject jsonObject1 = new com.alibaba.fastjson.JSONObject();
        try {
            HttpResponse response = new DefaultHttpClient().execute(httpPost);
            org.apache.http.HttpEntity resEntity = response.getEntity();
            if (resEntity != null) {
                jsonObject = JSON.parseObject(EntityUtils.toString(resEntity, "utf-8"));
                com.alibaba.fastjson.JSONObject obj = (com.alibaba.fastjson.JSONObject) jsonObject.get("Response");
                String privateKey = "D29262892372154FA8E63D3CB14C95F7FB3B25A2205605A34414F606812870E6";
                jsonObject1.put("Error", obj.get("Error"));
                if (obj.containsKey("Data")) {
                    com.alibaba.fastjson.JSONObject data = (com.alibaba.fastjson.JSONObject) obj.get("Data");
                    jsonObject1.put("name", sm2Decrypt(privateKey, data.get("userNameCyp").toString()));
                    jsonObject1.put("tel", sm2Decrypt(privateKey, data.get("mobileCyp").toString()));
                    jsonObject1.put("idno", sm2Decrypt(privateKey, data.get("certNoCyp").toString()));
                    jsonObject1.put("idtype", sm2Decrypt(privateKey, data.get("certTypeCyp").toString()));
                }
            }
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return jsonObject1;
    }

    private static String genNonce(int length) {
        StringBuilder val = new StringBuilder();
        Random random = new Random();

        //参数length，表示生成几位随机数
        for (int i = 0; i < length; i++) {

            String charOrNum = random.nextInt(2) % 2 == 0 ? "char" : "num";
            //输出字母还是数字
            if ("char".equalsIgnoreCase(charOrNum)) {
                //输出是大写字母还是小写字母
                int temp = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val.append((char) (random.nextInt(26) + temp));
            } else {
                val.append(random.nextInt(10));
            }
        }
        return val.toString();
    }

    public static String sm2Decrypt(String privateKey, String data) {
        SM2 sm2 = SmUtil.sm2(hexToByte(privateKey), null);
        // 公钥加密，私钥解密
        return StrUtil.utf8Str(sm2.decryptFromBcd(
                data,
                KeyType.PrivateKey));
    }

    public static String sm2encrypt(String data, String publicKey) {
        SM2 sm2 = SmUtil.sm2(null, hexToByte(publicKey));
        return sm2.encryptBcd(data, KeyType.PublicKey);
    }

    /**
     * 16进制转换成byte
     *
     * @param hexStr hexStr
     * @return String
     */
    public static byte[] hexToByte(String hexStr) {
        if (hexStr.isEmpty()) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2),
                    16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

    public static String makeNumberString(Object val, int length) {
        StringBuilder valStr = new StringBuilder(val.toString());
        while (valStr.length() < length) {
            valStr.insert(0, '0');
        }
        return valStr.toString();
    }

    /**
     * 获取下一个节点名称
     *
     * @param processName 流程名字
     * @param id          活动id号
     * @return JSONArray
     */
    public static JSONObject getActivity(String processName, String id) {
        // 得到流程定义
        ProcessDef process = ProcessDefManager.getInstance().getProcessDef(processName);
        ActivityDef ad = process.getActivity(id);
        JSONObject json = new JSONObject();
        json.put("id", ad.getID());
        json.put("name", ad.getName());
        json.put("personExpression", ad.getPersonExpression());
        json.put("timeout", ad.getTimeout());
        json.put("nodetype", ad.getNodetype());
        return json;
    }

    /**
     * 获取配置文件路径
     *
     * @param fileName 文件名
     */
    public JSONObject getConfigs(String fileName) {
        fileName += "Config";
        return liuliConfigService.get(fileName);
    }
    /**
     * 获取配置文件路径
     *
     * @param fileName 文件名
     */
    public static JSONObject getConfigstatic(String fileName) {
        return liuliConfigService2.get(fileName);
    }
    /**
     * 获取配置文件路径中的url
     */
    public static String getUrl() {
        JSONObject webConfig = getConfigstatic("webConfig");
        JSONObject setting = (JSONObject) webConfig.get("setting");
        String url = (String) setting.get("url");
        return url;
    }
    /*
     * 获取合同编号
     * */
    public synchronized String getContractNumber(SqlService sql, int length) {
        // 初始化合同号
        String contractNumber;
        try {
            // 获取年月格式为(yyyyMM)
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMM");
            String date = sdf.format(new Date());
            JSONArray getYM = sql.querySQL("queryContract",
                    "select f_yyyyMM from t_contract_YM where f_yyyyMM ='" + date + "'"
            );
            String number;
            if (getYM.isEmpty()) {

                // 如果没有当月则将本年月插入
                sql.execSQL("addContract",
                        " insert into t_contract_YM (f_yyyyMM) values ('" + date + "') "
                );
                number = "1";
            } else {
                JSONArray getNumber = sql.querySQL("getSingleValue", "select * from t_singlevalue where name ='报装合同编号'");
                JSONObject json2 = (JSONObject) getNumber.get(0);
                number = (String) json2.get("value");
            }

            // 组织合同号
            contractNumber = makeNumberString(number, length);
            // 更新合同号
            int num = Integer.parseInt(number);
            num++;
            sql.execSQL("updateSingleValue",
                    " update t_singlevalue set value='" + (num) + "'  where name = '报装合同编号'"
            );

        } catch (Exception ex) {
            throw new ServiceException(ex.getMessage(), 500);
        }
        return contractNumber;
    }
}
