package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.runtime.service.AppService;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 应用服务
 */
@RestController
@RequestMapping("/app")
public class AppController {

    private final AppService appService;

    public AppController(AppService appService) {
        this.appService = appService;
    }

    /**
     * 获取本地应用信息
     *
     * @return 应用信息
     */
    @GetMapping
    public R<Map<String, Object>> getAppInfo() {
        return R.ok(appService.getAppInfo().toMap());
    }

    /**
     * 本地应用版本号比较
     *
     * @param version 传入的要比较的版本号
     * @return 如果传入版本号等于应用版本号，则值为0；
     * 如果传入版本号小于应用版本号，则值小于0；
     * 如果传入版本号大于应用版本号，则值大于0
     */
    @GetMapping("/compare/{version}")
    public R<Integer> compareAppVersion(@PathVariable("version") String version) {
        return R.ok(appService.compareAppVersion(version));
    }

    /**
     * 本地琉璃框架版本号比较
     *
     * @param version 传入的要比较的版本号
     * @return 如果传入版本号等于琉璃框架版本号，则值为0；
     * 如果传入版本号小于琉璃框架版本号，则值小于0；
     * 如果传入版本号大于琉璃框架版本号，则值大于0
     */
    @GetMapping("/compareLiuLi/{version}")
    public R<Integer> compareLiuLiVersion(@PathVariable("version") String version) {
        return R.ok(appService.compareLiuLiVersion(version));
    }
}
