package com.af.v4.system.runtime.upgrade.bootstrap;

import com.af.v4.system.runtime.upgrade.BaseUpgradeAppBootstrap;
import com.af.v4.system.runtime.upgrade.UpgradePathExecutor;
import com.af.v4.system.runtime.upgrade.executor.UpgradePathCoreExecutor_2_12_1;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 框架核心升级引导类
 */
@Component
public class UpgradeCoreBootstrap extends BaseUpgradeAppBootstrap {

    /**
     * 获取所有升级路径执行器
     *
     * @return 升级路径执行器列表
     * @apiNote 此处指定升级路径执行器列表，应用启动时，会根据框架版本执行相应执行器
     */
    public List<UpgradePathExecutor> getAllExecutor() {
        List<UpgradePathExecutor> executors = new ArrayList<>();
        executors.add(new UpgradePathCoreExecutor_2_12_1());
        return executors;
    }
}
