/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/entity"})
public class EntityController {
    private final EntityService entityService;

    public EntityController(EntityService entityService) {
        this.entityService = entityService;
    }

    @Log(title="\u4fdd\u5b58/\u66f4\u65b0\u5b9e\u4f53", businessType=BusinessType.Entity)
    @PostMapping(value={"/save/{entityName}"}, produces={"application/json"})
    public R<Map<String, Object>> save(@PathVariable(value="entityName") String entityName, @RequestBody String entityContent) {
        return R.ok((Object)this.entityService.partialSave(entityName, new JSONObject(entityContent)).toMap());
    }

    @Log(title="\u6279\u91cf\u4fdd\u5b58/\u66f4\u65b0\u5b9e\u4f53", businessType=BusinessType.Entity)
    @PostMapping(value={"/batchSave/{entityName}"}, produces={"application/json"})
    public R<List<Object>> saveBatch(@PathVariable(value="entityName") String entityName, @RequestBody String entityContent) {
        return R.ok((Object)this.entityService.partialSave(entityName, new JSONArray(entityContent)).toList());
    }

    @Log(title="\u6839\u636e\u6307\u5b9a\u952e\u4fdd\u5b58\u5b9e\u4f53", businessType=BusinessType.Entity)
    @PostMapping(value={"/saveByKey/{entityName}"}, produces={"application/json"})
    public R<Map<String, Object>> saveByKey(@PathVariable(value="entityName") String entityName, @RequestBody String params) {
        JSONObject paramsContent = new JSONObject(params);
        JSONObject entity = paramsContent.getJSONObject("entity");
        JSONArray keyArray = paramsContent.getJSONArray("keyArray");
        boolean isCover = paramsContent.optBoolean("isCover", true);
        return R.ok((Object)this.entityService.saveByKey(entityName, entity, keyArray, Boolean.valueOf(isCover)).toMap());
    }

    @Log(title="\u5220\u9664\u5b9e\u4f53", businessType=BusinessType.Entity)
    @DeleteMapping(value={"{entityName}/{id}"}, produces={"application/json"})
    public R<Map<String, Object>> deleteById(@PathVariable(value="entityName") String entityName, @PathVariable(value="id") String id) {
        JSONObject result = new JSONObject();
        result.put("msg", (Object)this.entityService.delete(entityName, (Object)id));
        return R.ok((Object)result.toMap());
    }

    @Log(title="\u6279\u91cf\u5220\u9664\u5b9e\u4f53", businessType=BusinessType.Entity)
    @DeleteMapping(value={"{entityName}"}, produces={"application/json"})
    public R<Map<String, Object>> deleteAllByIds(@PathVariable(value="entityName") String entityName, @RequestBody String entity) {
        JSONObject entityContent = new JSONObject(entity);
        JSONObject result = new JSONObject();
        result.put("msg", (Object)this.entityService.deleteAllByIds(entityName, entityContent.getJSONArray("ids")));
        return R.ok((Object)result.toMap());
    }

    @Log(title="\u6839\u636eID\u67e5\u8be2\u6570\u636e", businessType=BusinessType.Entity)
    @PostMapping(value={"/query/{entityName}/{id}"}, produces={"application/json"})
    public R<Map<String, Object>> getById(@PathVariable(value="entityName") String entityName, @PathVariable(value="id") String id, @RequestBody String entity) {
        JSONObject entityContent = new JSONObject(entity);
        if (entityContent.has("columns")) {
            return R.ok((Object)this.entityService.getById(entityContent.getString("columns"), entityName, (Object)id).toMap());
        }
        return R.ok((Object)this.entityService.getById(entityName, (Object)id).toMap());
    }

    @Log(title="\u6839\u636eID\u96c6\u5408\u67e5\u8be2\u6240\u6709\u6570\u636e", businessType=BusinessType.Entity)
    @PostMapping(value={"/query/{entityName}"}, produces={"application/json"})
    public R<List<Object>> findAllByIds(@PathVariable(value="entityName") String entityName, @RequestBody String entity) {
        JSONObject entityContent = new JSONObject(entity);
        if (entityContent.has("columns")) {
            return R.ok((Object)this.entityService.findAllByIds(entityContent.getString("columns"), entityName, entityContent.getJSONArray("ids")).toList());
        }
        return R.ok((Object)this.entityService.findAllByIds(entityName, entityContent.getJSONArray("ids")).toList());
    }

    @Log(title="\u67e5\u8be2\u6240\u6709\u6570\u636e", businessType=BusinessType.Entity)
    @PostMapping(value={"/queryAll/{entityName}"}, produces={"application/json"})
    public R<List<Object>> findAll(@PathVariable(value="entityName") String entityName, @RequestBody String entity) {
        JSONObject entityContent = new JSONObject(entity);
        if (entityContent.has("columns")) {
            return R.ok((Object)this.entityService.findAll(entityContent.getString("columns"), entityName).toList());
        }
        return R.ok((Object)this.entityService.findAll(entityName).toList());
    }

    @Log(title="\u67e5\u8be2\u5b9e\u4f53\u7684\u603b\u6570\u91cf", businessType=BusinessType.Entity)
    @PostMapping(value={"/queryCount/{entityName}"}, produces={"application/json"})
    public R<Map<String, Object>> getCount(@PathVariable(value="entityName") String entityName) {
        JSONObject result = new JSONObject();
        result.put("msg", (Object)this.entityService.getCount(entityName));
        return R.ok((Object)result.toMap());
    }
}

