package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.file.service.FileService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.resource.config.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * 文件控制器
 *
 * @author Mr.river
 */
@RestController
@RequestMapping("/resource")
public class FileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileController.class);

    private final FileService fileService;
    private final ResourceConfig resourceConfig;

    public FileController(FileService fileService, ResourceConfig resourceConfig) {
        this.fileService = fileService;
        this.resourceConfig = resourceConfig;
    }

    /**
     * 资源上传
     *
     * @param file          文件
     * @param resUploadMode 资源上传模式
     * @param operator      操作人
     * @param formType      表单类型
     * @return 上传结果
     */
    @Log(title = "资源上传", businessType = BusinessType.OTHER)
    @PostMapping(value = "/upload", produces = MediaType.APPLICATION_JSON_VALUE)
    public R<Object> upload(
            @RequestParam("avatar") MultipartFile file,
            @RequestParam(value = "resUploadMode", required = false) String resUploadMode,
            @RequestParam("f_operator") String operator,
            @RequestParam("formType") String formType,
            @RequestParam("useType") String useType) {
        LOGGER.info("文件上传，文件名：{}", file.getOriginalFilename());

        String finalResUploadMode = (resUploadMode != null && !resUploadMode.isEmpty()) ? resUploadMode : resourceConfig.getResUploadMode();

        LOGGER.info("使用上传模式：{}", finalResUploadMode);
        FileService.FileUploadResult result = fileService.uploadFile(file, finalResUploadMode, operator, formType, useType);
        if (result.getSuccess()) {
            return R.ok(result);
        } else {
            return R.fail(result, result.getData().toString());
        }
    }

    /**
     * 删除图片(将t_files中状态字段修改为删除)
     *
     * @param id            需要删除的图片Id
     * @param resDeleteMode 资源删除模式
     * @return 删除结果
     */
    @Log(title = "资源删除", businessType = BusinessType.OTHER)
    @DeleteMapping(value = "/delete", produces = MediaType.APPLICATION_JSON_VALUE)
    public R<Object> delete(Integer id, String resDeleteMode) {
        LOGGER.info("文件删除，文件id：{}", id);
        FileService.FileUploadResult result = fileService.deleteFile(id, resDeleteMode);
        if (result.getSuccess()) {
            return R.ok(result);
        } else {
            return R.fail(result, result.getData().toString());
        }
    }
}
