/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.upgrade;

import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.runtime.dto.UpgradeField;
import com.af.v4.system.runtime.dto.UpgradeTable;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public abstract class UpgradePathExecutor {
    protected final LogicService logicService = (LogicService)SpringUtils.getBean(LogicService.class);
    protected final SqlService sqlService = (SqlService)SpringUtils.getBean(SqlService.class);
    protected final ApplicationService applicationService = (ApplicationService)SpringUtils.getBean(ApplicationService.class);
    protected final LiuLiConfigService liuLiConfigService = (LiuLiConfigService)SpringUtils.getBean(LiuLiConfigService.class);

    protected UpgradePathExecutor() {
    }

    @Transactional(rollbackFor={Exception.class})
    public abstract void upgrade();

    public abstract String targetVersion();

    public final int targetVersionCode() {
        return ApplicationService.buildVersionCode((String)this.targetVersion());
    }

    protected final void removeCacheKeys(List<String> cacheKeys) {
        String namespaceName = this.applicationService.getApplicationName();
        cacheKeys.forEach(cacheKey -> this.logicService.remoteRun("af-system", "deleteConfigurationCache", new JSONObject().put("configName", cacheKey).put("namespaceName", (Object)namespaceName)));
    }

    protected final void addFields(List<UpgradeField> fields) {
        for (UpgradeField field : fields) {
            String searchSql = field.getSearchSql();
            JSONArray searchResult = this.sqlService.querySQL("UpgradeField", searchSql);
            if (!searchResult.isEmpty()) continue;
            String addSql = field.getAddSql();
            this.sqlService.execSQL("UpgradeField", addSql);
        }
    }

    protected final void createTables(List<UpgradeTable> tables) {
        for (UpgradeTable table : tables) {
            String searchSql = table.getSearchSql();
            JSONArray result = this.sqlService.querySQL("CreateTable", searchSql);
            if (!result.isEmpty()) continue;
            String createSql = table.getCreateSql();
            this.sqlService.execSQL("CreateTable", createSql);
        }
    }
}

