/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.file.service.FileService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.resource.config.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/resource"})
public class FileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileController.class);
    private final FileService fileService;
    private final ResourceConfig resourceConfig;

    public FileController(FileService fileService, ResourceConfig resourceConfig) {
        this.fileService = fileService;
        this.resourceConfig = resourceConfig;
    }

    @Log(title="\u8d44\u6e90\u4e0a\u4f20", businessType=BusinessType.OTHER)
    @PostMapping(value={"/upload"}, produces={"application/json"})
    public R<Object> upload(@RequestParam(value="avatar") MultipartFile file, @RequestParam(value="resUploadMode", required=false) String resUploadMode, @RequestParam(value="f_operator") String operator, @RequestParam(value="formType") String formType, @RequestParam(value="useType") String useType) {
        LOGGER.info("\u6587\u4ef6\u4e0a\u4f20\uff0c\u6587\u4ef6\u540d\uff1a{}", (Object)file.getOriginalFilename());
        String finalResUploadMode = resUploadMode != null && !resUploadMode.isEmpty() ? resUploadMode : this.resourceConfig.getResUploadMode();
        LOGGER.info("\u4f7f\u7528\u4e0a\u4f20\u6a21\u5f0f\uff1a{}", (Object)finalResUploadMode);
        FileService.FileUploadResult result = this.fileService.uploadFile(file, finalResUploadMode, operator, formType, useType);
        if (result.getSuccess().booleanValue()) {
            return R.ok((Object)result);
        }
        return R.fail((Object)result, (String)result.getData().toString());
    }

    @Log(title="\u8d44\u6e90\u5220\u9664", businessType=BusinessType.OTHER)
    @DeleteMapping(value={"/delete"}, produces={"application/json"})
    public R<Object> delete(Integer id, String resDeleteMode) {
        LOGGER.info("\u6587\u4ef6\u5220\u9664\uff0c\u6587\u4ef6id\uff1a{}", (Object)id);
        FileService.FileUploadResult result = this.fileService.deleteFile(id, resDeleteMode);
        if (result.getSuccess().booleanValue()) {
            return R.ok((Object)result);
        }
        return R.fail((Object)result, (String)result.getData().toString());
    }
}

