package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.file.enums.ResUploadModeEnum;
import com.af.v4.system.common.file.service.MinioService;
import com.af.v4.system.common.file.utils.FilePathUtil;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.jpa.utils.QueryParams;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.resource.config.ResourceConfig;
import jakarta.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import static com.af.v4.system.common.core.constant.FileConstants.RESOURCE_EXT_2_TYPE;

/**
 * v3 上传文件请求兼容
 *
 * @author 张振宇
 * @apiNote 由于旧版 文件上传和 v4 toServer 差距较大，为了减少切换成本，此接口仅用于保持对v3及以前版本的兼容，
 * <p>该api随时都有可能移除，请不要使用该api开发任何新业务，仅对于以前的旧业务，
 */
@Deprecated
@RestController
@RequestMapping("/file")
public class V3FileController {

    private final FilePathUtil filePathUtil;
    private final EntityService entityService;
    private final SqlService sqlService;
    private final MinioService minioService;
    private final ApplicationService applicationService;
    private final ResourceConfig resourceConfig;

    public V3FileController(FilePathUtil filePathUtil, EntityService entityService,
                            SqlService sqlService, MinioService minioService,
                            ApplicationService applicationService, ResourceConfig resourceConfig) {
        this.filePathUtil = filePathUtil;
        this.entityService = entityService;
        this.sqlService = sqlService;
        this.minioService = minioService;
        this.applicationService = applicationService;
        this.resourceConfig = resourceConfig;
    }

    @PostMapping(value = "uploadFile")
    public String fileUpload2(HttpServletRequest request, @RequestParam("file") MultipartFile[] files) throws Exception {
        JSONObject result = new JSONObject();
        if (files.length == 0) {
            return "";
        }

        // 获取并解码请求头参数
        Map<String, Object> map = new HashMap<>();
        Enumeration<String> headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), StandardCharsets.UTF_8);
            map.put(key.toLowerCase(), value);
        }

        for (MultipartFile item : files) {
            String filename = item.getOriginalFilename();
            if (!validateFileName(filename)) {
                return new JSONObject().put("result", "文件不符合规范").toString();
            }

            // 构建新文件名
            String fileNameWithoutExt = filename.substring(0, filename.lastIndexOf('.'));
            String extension = filename.substring(filename.lastIndexOf('.') + 1);
            filename = fileNameWithoutExt + "_" + map.get("username") + "_" + CommonTools.getUUID(true) + "." + extension;

            String resourceType = RESOURCE_EXT_2_TYPE.get(extension);
            String savePath;
            String downloadPath;

            // 根据配置决定上传方式
            if (ResUploadModeEnum.toType(resourceConfig.getResUploadMode()) == ResUploadModeEnum.OSS) {
                // MinIO上传
                savePath = filePathUtil.getFileFullPathBySSO(resourceType, filename);
                downloadPath = filePathUtil.getFileDownloadUrlBySSO(resourceType, filename);
                String bucketName = applicationService.getApplicationName();
                try {
                    minioService.upload(item, savePath, bucketName);
                } catch (Exception e) {
                    throw new RuntimeException("MinIO上传失败", e);
                }
            } else {
                // 服务器本地上传
                savePath = filePathUtil.getFileFullPathByServer(resourceType, filename);
                downloadPath = filePathUtil.getFileDownloadUrlByServer(resourceType, filename);
                File saveDir = new File(savePath).getParentFile();
                if (!saveDir.exists()) {
                    saveDir.mkdirs();
                }
                try (InputStream in = item.getInputStream();
                     FileOutputStream out = new FileOutputStream(savePath)) {
                    in.transferTo(out);
                }
            }

            // 更新文件相关信息
            if (map.get("blodid") != null && !((String) map.get("blodid")).trim().isEmpty()) {
                map.put("f_blobid", map.get("blodid"));
            }
            if (map.get("f_table_name") != null && !((String) map.get("f_table_name")).trim().isEmpty()) {
                map.put("f_table_name", map.get("f_table_name"));
            }
            if (map.containsKey("businessid") && map.get("businessid") != null &&
                    !((String) map.get("businessid")).trim().isEmpty()) {
                map.put("f_businessid", map.get("businessid"));
            }
            if (map.get("username") != null && !((String) map.get("username")).trim().isEmpty()) {
                map.put("f_username", map.get("username"));
            }

            map.put("f_filename", filename);
            map.put("f_filetype", extension);
            map.put("f_downloadpath", downloadPath);
            map.put("path", downloadPath);
            map.put("f_realpath", savePath);
            map.put("f_upload_mode", resourceConfig.getResUploadMode());

            // 保存到数据库
            map.remove("id");
            JSONObject savedObj = entityService.partialSave("t_files", new JSONObject(map));
            map.put("id", savedObj.get("id"));
            result = new JSONObject(map);
        }

        return result.put("result", "success").toString();
    }

    // 获得图片
    @GetMapping(value = "getfile/{id}")
    public byte[] getfile(@PathVariable("id") String id) {
        try {
            // 获取文件真实路径
            JSONArray array = sqlService.querySQL(
                    "getFileById",
                    "select f_downloadpath, f_realpath, f_upload_mode from t_files where id = :id",
                    new QueryParams.Builder().addParameter("id", id).build()
            );
            if (array.isEmpty()) {
                return null;
            }
            JSONObject map = array.getJSONObject(0);

            // 根据上传模式决定获取方式
            if (ResUploadModeEnum.toType(map.optString("f_upload_mode")) == ResUploadModeEnum.OSS) {
                // 从MinIO获取
                try (InputStream in = minioService.download(applicationService.getApplicationName(), map.getString("f_realpath"))) {
                    return in.readAllBytes();
                }
            } else {
                // 从本地文件系统获取
                File file = new File(map.getString("f_downloadpath"));
                try (FileInputStream in = new FileInputStream(file)) {
                    return in.readAllBytes();
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 通过filepath获取文件
     */
    @PostMapping(value = "getUploadFile")
    public byte[] getFileOfFilePath(String values) {
        try {
            // 获得文件
            values = values.replaceAll("\\\\", "/");
            JSONObject params = new JSONObject(values);
            String filepath = params.getString("filepath");

            // 这里需要根据filepath的格式来判断是从MinIO还是本地获取
            if (filepath.startsWith("/minio/")) {
                try (InputStream in = minioService.download(applicationService.getApplicationName(), filepath.substring(7))) {
                    return in.readAllBytes();
                }
            } else {
                File file = new File(filepath);
                try (FileInputStream in = new FileInputStream(file)) {
                    return in.readAllBytes();
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getSuffix(String name) {
        return name.split("\\.")[name.split("\\.").length - 1];
    }


    private boolean validateFileName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        String suffix = getSuffix(name).toLowerCase();
        return RESOURCE_EXT_2_TYPE.containsKey(suffix);
    }
}
