/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.constant.FileConstants;
import com.af.v4.system.common.core.service.ApplicationService;
import com.af.v4.system.common.file.enums.ResUploadModeEnum;
import com.af.v4.system.common.file.service.MinioService;
import com.af.v4.system.common.file.utils.FilePathUtil;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.jpa.utils.QueryParams;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.resource.config.ResourceConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Deprecated
@RestController
@RequestMapping(value={"/file"})
public class V3FileController {
    private final FilePathUtil filePathUtil;
    private final EntityService entityService;
    private final SqlService sqlService;
    private final MinioService minioService;
    private final ApplicationService applicationService;
    private final ResourceConfig resourceConfig;

    public V3FileController(FilePathUtil filePathUtil, EntityService entityService, SqlService sqlService, MinioService minioService, ApplicationService applicationService, ResourceConfig resourceConfig) {
        this.filePathUtil = filePathUtil;
        this.entityService = entityService;
        this.sqlService = sqlService;
        this.minioService = minioService;
        this.applicationService = applicationService;
        this.resourceConfig = resourceConfig;
    }

    @PostMapping(value={"uploadFile"})
    public String fileUpload2(HttpServletRequest request, @RequestParam(value="file") MultipartFile[] files) throws Exception {
        JSONObject result = new JSONObject();
        if (files.length == 0) {
            return "";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String)headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), StandardCharsets.UTF_8);
            map.put(key.toLowerCase(), value);
        }
        for (MultipartFile item : files) {
            String downloadPath;
            String savePath;
            Object filename = item.getOriginalFilename();
            if (!this.validateFileName((String)filename)) {
                return new JSONObject().put("result", (Object)"\u6587\u4ef6\u4e0d\u7b26\u5408\u89c4\u8303").toString();
            }
            String fileNameWithoutExt = ((String)filename).substring(0, ((String)filename).lastIndexOf(46));
            String extension = ((String)filename).substring(((String)filename).lastIndexOf(46) + 1);
            filename = fileNameWithoutExt + "_" + String.valueOf(map.get("username")) + "_" + CommonTools.getUUID((Boolean)true) + "." + extension;
            String resourceType = (String)FileConstants.RESOURCE_EXT_2_TYPE.get(extension);
            if (ResUploadModeEnum.toType((String)this.resourceConfig.getResUploadMode()) == ResUploadModeEnum.OSS) {
                savePath = this.filePathUtil.getFileFullPathBySSO(resourceType, (String)filename);
                downloadPath = this.filePathUtil.getFileDownloadUrlBySSO(resourceType, (String)filename);
                String bucketName = this.applicationService.getApplicationName();
                try {
                    this.minioService.upload(item, savePath, bucketName);
                }
                catch (Exception e) {
                    throw new RuntimeException("MinIO\u4e0a\u4f20\u5931\u8d25", e);
                }
            }
            savePath = this.filePathUtil.getFileFullPathByServer(resourceType, (String)filename);
            downloadPath = this.filePathUtil.getFileDownloadUrlByServer(resourceType, (String)filename);
            File saveDir = new File(savePath).getParentFile();
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            try (InputStream in = item.getInputStream();
                 FileOutputStream out = new FileOutputStream(savePath);){
                in.transferTo(out);
            }
            if (map.get("blodid") != null && !((String)map.get("blodid")).trim().isEmpty()) {
                map.put("f_blobid", map.get("blodid"));
            }
            if (map.get("f_table_name") != null && !((String)map.get("f_table_name")).trim().isEmpty()) {
                map.put("f_table_name", map.get("f_table_name"));
            }
            if (map.containsKey("businessid") && map.get("businessid") != null && !((String)map.get("businessid")).trim().isEmpty()) {
                map.put("f_businessid", map.get("businessid"));
            }
            if (map.get("username") != null && !((String)map.get("username")).trim().isEmpty()) {
                map.put("f_username", map.get("username"));
            }
            map.put("f_filename", filename);
            map.put("f_filetype", extension);
            map.put("f_downloadpath", downloadPath);
            map.put("path", downloadPath);
            map.put("f_realpath", savePath);
            map.put("f_upload_mode", this.resourceConfig.getResUploadMode());
            map.remove("id");
            JSONObject savedObj = this.entityService.partialSave("t_files", new JSONObject(map));
            map.put("id", savedObj.get("id"));
            result = new JSONObject(map);
        }
        return result.put("result", (Object)"success").toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GetMapping(value={"getfile/{id}"})
    public byte[] getfile(@PathVariable(value="id") String id) {
        try {
            JSONArray array = this.sqlService.querySQL("getFileById", "select f_downloadpath, f_realpath, f_upload_mode from t_files where id = :id", new QueryParams.Builder().addParameter("id", (Object)id).build());
            if (array.isEmpty()) {
                return null;
            }
            JSONObject map = array.getJSONObject(0);
            if (ResUploadModeEnum.toType((String)map.optString("f_upload_mode")) == ResUploadModeEnum.OSS) {
                try (InputStream in = this.minioService.download(this.applicationService.getApplicationName(), map.getString("f_downloadpath"));){
                    byte[] byArray = in.readAllBytes();
                    return byArray;
                }
            }
            File file = new File(map.getString("f_downloadpath"));
            try (FileInputStream in = new FileInputStream(file);){
                byte[] byArray = in.readAllBytes();
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostMapping(value={"getUploadFile"})
    public byte[] getFileOfFilePath(String values) {
        try {
            values = values.replaceAll("\\\\", "/");
            JSONObject params = new JSONObject(values);
            String filepath = params.getString("filepath");
            if (filepath.startsWith("/minio/")) {
                try (InputStream in = this.minioService.download(this.applicationService.getApplicationName(), filepath.substring(7));){
                    byte[] byArray = in.readAllBytes();
                    return byArray;
                }
            }
            File file = new File(filepath);
            try (FileInputStream in = new FileInputStream(file);){
                byte[] byArray = in.readAllBytes();
                return byArray;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getSuffix(String name) {
        return name.split("\\.")[name.split("\\.").length - 1];
    }

    private boolean validateFileName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        String suffix = this.getSuffix(name).toLowerCase();
        return FileConstants.RESOURCE_EXT_2_TYPE.containsKey(suffix);
    }
}

