package com.af.v4.system.runtime.aspect;

import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.resource.mapper.LogicMapper;
import com.af.v4.system.runtime.annotation.OpenApi;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

/**
 * 校验无需鉴权的API是否配置了auth属性
 */
@Aspect
@Component
public class OpenApiAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenApiAspect.class);

    private final LogicMapper logicMapper;

    public OpenApiAspect(LogicMapper logicMapper) {
        this.logicMapper = logicMapper;
    }

    /**
     * 处理请求前执行
     */
    @Before(value = "@annotation(openApi)")
    public void boBefore(JoinPoint joinPoint, OpenApi openApi) {
        Object[] params = joinPoint.getArgs();
        String resName = params[0].toString();
        checkAuth(resName);
    }

    /**
     * 校验资源鉴权
     *
     * @param resName 资源名称
     */
    private void checkAuth(String resName) {
        LogicMapper.LogicResource logicResource = logicMapper.getResource(resName);
        boolean isAuth = logicResource.getAuth();
        if (isAuth) {
            throw new ServiceException("非法访问接口", 401);
        }
    }
}
