package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.file.utils.FilePathUtil;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.plugins.date.DateTools;
import com.af.v4.system.common.resource.config.ResourceConfig;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/**
 * v3 上传文件请求兼容
 *
 * @author 张振宇
 * @apiNote 由于旧版 文件上传和 v4 toServer 差距较大，为了减少切换成本，此接口仅用于保持对v3及以前版本的兼容，
 * <p>该api随时都有可能移除，请不要使用该api开发任何新业务，仅对于以前的旧业务，
 */
@Deprecated(since = "1.0.0", forRemoval = true)
@RestController
@RequestMapping("/file")
public class V3FileController {

    private final FilePathUtil filePathUtil;
    private final ResourceConfig resourceConfig;
    private final EntityService entityService;
    private final SqlService sqlService;
    private final ApplicationUtils applicationUtils;


    public V3FileController(FilePathUtil filePathUtil, ResourceConfig resourceConfig, EntityService entityService, SqlService sqlService, ApplicationUtils applicationUtils) {
        this.filePathUtil = filePathUtil;
        this.resourceConfig = resourceConfig;
        this.entityService = entityService;
        this.sqlService = sqlService;
        this.applicationUtils = applicationUtils;
    }

    @PostMapping(value = "uploadFile")
    public String fileUpload2(HttpServletRequest request, @RequestParam("file") MultipartFile[] files) throws Exception {
        //  nacos 配置中的 resource
        //  resource:
        //   fileRootPath: D:/
        //   extraPaths: D:/
        String savePath = filePathUtil.getFileRootPathByServer() + File.separatorChar + applicationUtils.getApplicationName();
        JSONObject result = new JSONObject();
        File file = new File(savePath + File.separator + DateTools.getNow("yyyyMMdd"));
        //判断上传文件的保存目录是否存在
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        String downloadpath;
        //获取所有请求头参数
        Enumeration<String> headerNames = request.getHeaderNames();
        Map<String, Object> map = new HashMap<>();
        while (headerNames.hasMoreElements()) {
            String key = headerNames.nextElement();
            String value = URLDecoder.decode(request.getHeader(key), StandardCharsets.UTF_8);
            map.put(key.toLowerCase(), value);
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload(factory);
        upload.setHeaderEncoding("UTF-8");
        if (files.length == 0) {
            return "";
        }
        for (MultipartFile item : files) {
            //获得文件名
            String filename = item.getOriginalFilename();
            if (!validateFileName(filename)) {
                result.put("result", "文件不符合规范");
                return result.toString();
            }
            filename = filename.substring(0, filename.lastIndexOf('.')) + "_" + map.get("username") + "_" + CommonTools.getUUID(true) + "." + filename.substring(filename.lastIndexOf('.') + 1);
            //获取item中的上传文件的输入流
            try (InputStream in = item.getInputStream();
                 FileOutputStream out = new FileOutputStream(file.getAbsolutePath() + File.separator + filename)) {
                //创建一个缓冲区
                byte[] buffer = new byte[1024];
                //判断输入流中的数据是否已经读完的标识
                int len;
                //循环将输入流读入到缓冲区当中，(len=in.read(buffer))>0就表示in里面还有数据
                while ((len = in.read(buffer)) > 0) {
                    //使用FileOutputStream输出流将缓冲区的数据写入到指定的目录(savePath + "\\" + filename)当中
                    out.write(buffer, 0, len);
                }
            }
            // 给数据库里保存
            downloadpath = file.getAbsolutePath() + File.separator + filename;
            String filetype = filename.substring(filename.lastIndexOf('.') + 1);
            if (map.get("blodid") != null && !((String) map.get("blodid")).trim().isEmpty()) {
                //存f_userinfo_id
                map.put("f_blobid", map.get("blodid"));
            }
            if (map.containsKey("businessid")) {
                //存业务id
                if (map.get("businessid") != null && !((String) map.get("businessid")).trim().isEmpty()) {
                    map.put("f_businessid", map.get("businessid"));
                }
            }
            if (map.get("username") != null && !((String) map.get("username")).trim().isEmpty()) {
                map.put("f_username", map.get("username"));
            }
            map.put("f_filename", filename);
            map.put("f_filetype", filetype);
            map.put("f_downloadpath", downloadpath);
            map.put("path", downloadpath);
            map.put("f_realpath", savePath);
            map.remove("id");
            JSONObject JObj = entityService.partialSave("t_files", new JSONObject(map));
            map.put("id", JObj.get("id"));
            result = new JSONObject(map);
        }
        result.put("result", "success");
        return result.toString();
    }

    // 获得图片
    @GetMapping(value = "getfile/{id}")
    public byte[] getfile(@PathVariable("id") String id) {
        try {
            // 获取文件真实路径
            JSONArray array = sqlService.querySQL("getFileById",
                    "select f_downloadpath from t_files where id=" + id
            );
            if (array.isEmpty()) {
                return null;
            }
            JSONObject map = array.getJSONObject(0);
            // 获得文件名
            String filename = map.getString("f_downloadpath");
            // 获得文件
            File file = new File(filename);
            try (FileInputStream in = new FileInputStream(file)) {
                byte[] result = new byte[(int) file.length()];
                in.read(result);
                return result;
            }
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 通过filepath获取文件
     */
    @PostMapping(value = "getUploadFile")
    public byte[] getFileOfFilePath(String values) {
        try {
            // 获得文件
            values = values.replaceAll("\\\\", "/");
            JSONObject params = new JSONObject(values);
            Object object = params.get("filepath");
            String filepath = (String) object;
            File file = new File(filepath);
            try (FileInputStream in = new FileInputStream(file)) {
                byte[] result = new byte[(int) file.length()];
                in.read(result);
                return result;
            }
        } catch (RuntimeException e) {
            throw e;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getSuffix(String name) {
        return name.split("\\.")[name.split("\\.").length - 1];
    }


    private boolean validateFileName(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        String[] uploadType = {"doc", "docx", "xls", "xlsx", "jpg", "png", "gif", "bmp", "avi", "mp4", "wmv", "rmvb", "mov", "pdf", "dwg", "txt"};
        String suffix = getSuffix(name).toLowerCase();
        return Arrays.asList(uploadType).contains(suffix);
    }
}
