/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.upgrade;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.redis.RedisService;
import com.af.v4.system.runtime.upgrade.BaseUpgradeAppBootstrap;
import com.af.v4.system.runtime.upgrade.UpgradePathExecutor;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class UpgradePathManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradePathManager.class);
    private static final TreeMap<Integer, UpgradePathExecutor> UPGRADE_PATH_EXECUTORS = new TreeMap();
    private final RedisService redisService;
    private final ApplicationUtils applicationUtils;
    private final BaseUpgradeAppBootstrap bootstrap;

    public UpgradePathManager(RedisService redisService, ApplicationUtils applicationUtils, BaseUpgradeAppBootstrap bootstrap) {
        this.redisService = redisService;
        this.applicationUtils = applicationUtils;
        this.bootstrap = bootstrap;
    }

    public static void register(UpgradePathExecutor executor) {
        UPGRADE_PATH_EXECUTORS.put(executor.targetVersionCode(), executor);
    }

    public void executeUpgrade() {
        LOGGER.info("\u68c0\u67e5\u670d\u52a1\u5347\u7ea7...");
        String cacheKey = "System@AppVersion-" + this.applicationUtils.getApplicationName();
        String fromVersion = (String)this.redisService.get(cacheKey);
        int fromVersionCode = fromVersion == null ? ApplicationUtils.getAppVersionCode().intValue() : ApplicationUtils.buildVersionCode((String)fromVersion).intValue();
        String toVersion = ApplicationUtils.getAppVersion();
        int toVersionCode = ApplicationUtils.getAppVersionCode();
        if (fromVersionCode >= toVersionCode) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u5185\u5bb9.");
            this.redisService.set(cacheKey, (Object)toVersion);
            return;
        }
        NavigableMap<Integer, UpgradePathExecutor> upgradePathExecutorMap = UPGRADE_PATH_EXECUTORS.subMap(fromVersionCode, false, toVersionCode, true);
        if (upgradePathExecutorMap.isEmpty()) {
            LOGGER.info("\u6ca1\u6709\u9700\u8981\u5347\u7ea7\u7684\u5185\u5bb9.");
            this.redisService.set(cacheKey, (Object)toVersion);
            return;
        }
        LOGGER.info("\u5f85\u5347\u7ea7\u6570\u636e\u5305\u6570\u91cf\uff1a{}", (Object)upgradePathExecutorMap.size());
        for (UpgradePathExecutor executor : upgradePathExecutorMap.values()) {
            LOGGER.info("\u5f00\u59cb\u8fdb\u884c\u670d\u52a1\u5347\u7ea7 ===============> {} to {}", (Object)fromVersion, (Object)executor.targetVersion());
            try {
                executor.upgrade();
            }
            catch (Exception e) {
                LOGGER.error("\u670d\u52a1\u5347\u7ea7\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Throwable)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                throw new ServiceException("\u670d\u52a1\u5347\u7ea7\u5931\u8d25\uff0c\u7a0b\u5e8f\u5df2\u5f3a\u5236\u4e2d\u6b62.");
            }
            this.redisService.set(cacheKey, (Object)executor.targetVersion());
            LOGGER.info("{} => {} done.", (Object)fromVersion, (Object)executor.targetVersion());
            fromVersion = executor.targetVersion();
        }
    }

    @PostConstruct
    public void init() {
        if (this.applicationUtils.getEnvType() == EnvType.PROD) {
            for (UpgradePathExecutor executor : this.bootstrap.getAllExecutor()) {
                UpgradePathManager.register(executor);
            }
            this.executeUpgrade();
        }
    }
}

