/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.service;

import com.af.v4.system.common.core.enums.EnvType;
import com.af.v4.system.common.core.exception.ServiceException;
import com.af.v4.system.common.expression.core.Program;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.plugins.core.CommonTools;
import com.af.v4.system.common.resource.mapper.AbstractResourceMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ResCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResCheckService.class);
    private static final List<String> ERROR_ARRAY = new ArrayList<String>();
    private static final String[] sentence = new String[]{"\u8f6f\u4ef6\u5f00\u53d1\u5f80\u5f80\u662f\u8fd9\u6837\uff1a\u6700\u5f00\u59cb\u768490%\u4ee3\u7801\u5360\u7528\u4e86\u5f00\u59cb\u768490%\u7684\u5f00\u53d1\u65f6\u95f4\uff1b\u5269\u4e0b10%\u4ee3\u7801\u540c\u6837\u9700\u898190%\u7684\u5f00\u53d1\u65f6\u95f4\u3002", "\u8fd9\u4e0d\u662f\u4e00\u4e2abug\uff0c\u8fd9\u53ea\u662f\u4e00\u4e2a\u672a\u5217\u51fa\u6765\u7684\u7279\u6027\u3002", "\u4f5c\u4e3a\u4e00\u4e2a\u7a0b\u5e8f\u5458\uff0c\u90c1\u95f7\u7684\u4e8b\u60c5\u662f\uff0c\u2faf\u5bf9\u4e00\u4e2a\u4ee3\u7801\u5757\uff0c\u5374\u4e0d\u6562\u53bb\u4fee\u6539\u3002\u66f4\u7cdf\u7cd5\u7684\u662f\uff0c\u8fd9\u4e2a\u4ee3\u7801\u5757\u8fd8\u662f\u2f83\u2f30\u5199\u7684\u3002", "\u5728\u7cfb\u7edf\u6d4b\u8bd5\u9636\u6bb5\u67e5\u627e\u5e76\u4fee\u590d Bug\uff0c\u82b1\u8d39\u7684\u65f6\u95f4\u548c\u5de5\u4f5c\u91cf\u662f\u8ba9\u5f00\u53d1\u8005\u81ea\u5df1\u627e Bug \u7684\u4e09\u500d\u3002\u5728\u6b63\u5f0f\u4e0a\u7ebf\u540e\u67e5\u627e\u5e76\u4fee\u590d Bug\uff0c\u82b1\u8d39\u7684\u65f6\u95f4\u548c\u5de5\u4f5c\u91cf\u662f\u7cfb\u7edf\u6d4b\u8bd5\u9636\u6bb5\u7684\u5341\u500d\u3002\u56e0\u6b64\u4e00\u5b9a\u8981\u8ba9\u5f00\u53d1\u8005\u81ea\u5df1\u505a\u5355\u5143\u6d4b\u8bd5\u3002", "\u4e0d\u8981\u7ad9\u7740\u8c03\u8bd5\u3002\u7ad9\u7740\u4f1a\u8ba9\u4f60\u7684\u8010\u5fc3\u51cf\u534a\uff0c\u800c\u4e14\u4f60\u9700\u8981\u96c6\u4e2d\u6240\u6709\u7cbe\u529b\u3002", "\u6d4b\u8bd5\u53ef\u4ee5\u53d1\u73b0bug\u7684\u5b58\u5728\uff0c\u4f46\u4e0d\u80fd\u8bc1\u660ebug\u4e0d\u5b58\u5728\u3002", "\u65b0\u7cfb\u7edf\u7684\u6bcf\u4e2a\u65b0\u7528\u6237\u90fd\u4f1a\u53d1\u73b0\u4e00\u7c7b\u65b0\u7684Bug\u3002", "\u4fee\u590d\u635f\u574f\u7684\u7a0b\u5e8f\u7684\u7b2c\u4e00\u6b65\u5c31\u662f\u8ba9\u5b83\u4e0d\u65ad\u5931\u8d25\u3002", "\u6709\u4e24\u79cd\u65b9\u6cd5\u80fd\u5199\u51fa\u6ca1\u6709\u9519\u8bef\u7684\u7a0b\u5e8f\uff1b\u4f46\u53ea\u6709\u7b2c\u4e09\u79cd\u597d\u7528\u3002", "\u4ee3\u7801\u5199\u7684\u8d8a\u6025\uff0c\u7a0b\u5e8f\u8dd1\u5f97\u8d8a\u6162\u3002"};
    private static final String[] prompt = new String[]{"\u751f\u4ea7\u73af\u5883\u4e0b\u5173\u95edHibernate\u7684\u81ea\u52a8\u5efa\u8868\uff0c\u8fd9\u662f\u4e00\u4e2a\u57fa\u672c\u5e38\u8bc6\uff0c\u597d\u5728\u6211\u4eec\u5df2\u7ecf\u8fd9\u4e48\u505a\u4e86\u3002", "\u5982\u4f55\u4f18\u96c5\u7684\u5199Logic\uff1f\u4f7f\u7528Logic for IDEA\u63d0\u793a\u63d2\u4ef6\uff0c\u83b7\u5f97\u66f4\u667a\u80fd\u7684\u5f00\u53d1\u4f53\u9a8c\u3002", "\u4e0d\u7528\u6000\u5ff5V3\uff0c\u5f80\u524d\u8d70\uff0c\u522b\u56de\u5934\u3002", "\u5c06Logic\u6587\u4ef6\u50cfJava\u4e00\u6837\u6309\u7167\u4e0d\u540c\u6a21\u5757\u4e0d\u540c\u4f5c\u7528\u5b58\u653e\uff0c\u8fd9\u6837\u7684\u9879\u76ee\u5c42\u7ea7\u7ed3\u6784\u4f1a\u66f4\u6e05\u6670\u3002", "\u5f53\u4f60\u5199\u51fa\u4e86\u8d85\u8fc7150\u884c\u7684\u590d\u6742SQL\uff0c\u5c1d\u8bd5\u79bb\u5f00\u4f4d\u7f6e\uff0c\u5230\u5916\u9762\u900f\u900f\u6c14\uff0c\u56de\u6765\u518d\u60f3\u60f3\uff0c\u6709\u6ca1\u6709\u66f4\u597d\u7684\u89e3\u51b3\u529e\u6cd5\u5462\u3002", "\u5982\u679c\u4f60\u9700\u8981\u5b9e\u73b0\u7684\u4e1a\u52a1\u6d89\u53ca\u5230\u4f7f\u7528\u65b0\u7684\u6846\u67b6\u3001\u6280\u672f\u6216\u8005\u4f9d\u8d56\uff0c\u8bf7\u4e0e\u7814\u53d1\u7ec4\u786e\u8ba4\uff0c\u4e0d\u8981\u81ea\u5df1\u5c1d\u8bd5\u589e\u52a0\u4efb\u4f55\u4f9d\u8d56\u3002", "\u5982\u4f55\u6210\u4e3a\u4e00\u540d\u597d\u7684\u7a0b\u5e8f\u5458\uff1f\u5077\u61d2\u5427\uff0c\u300c\u61d2\u300d\u662f\u7a0b\u5e8f\u5458\u5e94\u6709\u7684\u7f8e\u5fb7\uff0c\u5b66\u7740\u7528\u8f6f\u4ef6\u5de5\u7a0b\u601d\u60f3\u6765\u51cf\u5c11\u81ea\u5df1\u7684\u91cd\u590d\u4f4e\u6548\u5de5\u4f5c\u3002", "\u540e\u7aef\u63a5\u53e3\u8d85\u8fc710\u79d2\u5c31\u5fc5\u987b\u4f18\u5316\u4e86\uff0c\u5bf9\u4e8e\u5927\u91cf\u6570\u636e\u5904\u7406\u7684\u4e1a\u52a1\uff0c\u5c1d\u8bd5\u7528MQ\uff0c\u5f02\u6b65\u6216\u8005\u4efb\u52a1\u8c03\u5ea6\u6846\u67b6\u3002", "\u4ee3\u7801\u53ef\u4ee5\u91cd\u6784\uff0c\u4f46\u91cd\u6784\u524d\u4e00\u5b9a\u8981\u5907\u4efd\uff0c\u4e00\u5b9a\u8981\u5907\u4efd\uff0c\u4e00\u5b9a\u8981\u5907\u4efd\u3002"};
    private final ApplicationUtils applicationUtils;
    private final List<AbstractResourceMapper<?>> abstractResourceMappers;

    public ResCheckService(ApplicationUtils applicationUtils, List<AbstractResourceMapper<?>> abstractResourceMappers) {
        this.applicationUtils = applicationUtils;
        this.abstractResourceMappers = abstractResourceMappers;
    }

    @PostConstruct
    public void checkAll() {
        EnvType envType = this.applicationUtils.getEnvType();
        if (envType != EnvType.DEV) {
            LOGGER.info("==================\u8df3\u8fc7\u8d44\u6e90\u68c0\u67e5==================");
            return;
        }
        LOGGER.info("==================\u5f00\u59cb\u8d44\u6e90\u5f3a\u5236\u68c0\u67e5==================");
        boolean throwError = false;
        StringBuilder msg = new StringBuilder("\u68c0\u67e5\u7ed3\u679c\uff1a");
        AbstractResourceMapper.RESOURCE_CHECK_FLAG.set(true);
        for (AbstractResourceMapper<?> mapper : this.abstractResourceMappers) {
            int errorNum = this.checkRes(mapper);
            if (errorNum <= 0) continue;
            throwError = true;
            msg.append("\n * >>>ERROR: ").append(mapper.getResType()).append("\u5f3a\u5236\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u5171\u6709").append(errorNum).append("\u9879\u9519\u8bef");
        }
        AbstractResourceMapper.RESOURCE_CHECK_FLAG.remove();
        if (throwError) {
            Object errorWelcome = "/***\n * _ooOoo_\n * o8888888o\n * 88\" . \"88\n * (| -_- |)\n *  O\\ = /O\n * ___/`---'\\____\n * .   ' \\\\| |// `.\n * / \\\\||| : |||// \\\n * / _||||| -:- |||||- \\\n * | | \\\\\\ - /// | |\n * | \\_| ''\\---/'' | |\n * \\ .-\\__ `-` ___/-. /\n * ___`. .' /--.--\\ `. . __\n * .\"\" '< `.___\\_<|>_/___.' >'\"\".\n * | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n * \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n * `=---='\n * .............................................\n * \u4f5b\u66f0\uff1abug\u6cdb\u6ee5\uff0c\u6211\u5df2\u762b\u75ea\uff01\n";
            msg.append("\n * >>> \u81f3\u7406\u540d\u8a00\uff1a").append(sentence[CommonTools.getRandomNumber((Integer)0, (Integer)(sentence.length - 1))]);
            errorWelcome = (String)errorWelcome + "\n * " + String.valueOf(msg) + "\n";
            LOGGER.error((String)errorWelcome);
            for (int i = 0; i < ERROR_ARRAY.size(); ++i) {
                StringBuilder item = new StringBuilder();
                LOGGER.error(item.append(" * ").append(i + 1).append(". ").append(ERROR_ARRAY.get(i)).toString());
            }
            LOGGER.error("==================\u8d44\u6e90\u5f3a\u5236\u68c0\u67e5\u5b8c\u6210==================\n");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            throw new ServiceException("\u8d44\u6e90\u68c0\u67e5\u672a\u901a\u8fc7\uff0c\u7a0b\u5e8f\u5df2\u5f3a\u5236\u4e2d\u6b62");
        }
        String successWelcome = "/***\n *                    _ooOoo_\n *                   o8888888o\n *                   88\" . \"88\n *                   (| -_- |)\n *                    O\\ = /O\n *                ____/`---'\\____\n *              .   ' \\\\| |// `.\n *               / \\\\||| : |||// \\\n *             / _||||| -:- |||||- \\\n *               | | \\\\\\ - /// | |\n *             | \\_| ''\\---/'' | |\n *              \\ .-\\__ `-` ___/-. /\n *           ___`. .' /--.--\\ `. . __\n *        .\"\" '< `.___\\_<|>_/___.' >'\"\".\n *       | | : `- \\`.;`\\ _ /`;.`/ - ` : | |\n *         \\ \\ `-. \\_ __\\ /__ _/ .-` / /\n * ======`-.____`-.___\\_____/___.-`____.-'======\n *                    `=---='\n *\n * .............................................\n *          \u4f5b\u7956\u4fdd\u4f51             \u6c38\u65e0BUG\n */";
        LOGGER.info(successWelcome);
        LOGGER.info("\u5c0f\u63d0\u793a\uff1a{}", (Object)prompt[CommonTools.getRandomNumber((Integer)0, (Integer)(prompt.length - 1))]);
    }

    private int checkRes(AbstractResourceMapper<? extends AbstractResourceMapper.CommonResource> mapper) {
        Map resMap = mapper.getAllMap();
        AtomicInteger i = new AtomicInteger(1);
        AtomicInteger success = new AtomicInteger(0);
        AtomicInteger error = new AtomicInteger(0);
        int size = resMap.size();
        LOGGER.info("\u68c0\u67e5{}\u8d44\u6e90\uff0c\u5171 {} \u4e2a...", (Object)mapper.getResType(), (Object)size);
        resMap.forEach((key, value) -> {
            AbstractResourceMapper.CommonResource resource = mapper.getResource(key);
            String alias = resource.getAlias();
            String path = resource.getPath();
            try {
                if (mapper.isSupportCompile()) {
                    String source = resource.getSource();
                    Program pros = new Program(source);
                    try {
                        pros.parse();
                        success.addAndGet(1);
                    }
                    catch (RuntimeException e) {
                        String message = e.getMessage();
                        ERROR_ARRAY.add(String.valueOf(mapper.getResType()) + "\u8d44\u6e90[" + alias + "](" + path + ")\u7f16\u8bd1\u9519\u8bef\uff0c" + message);
                        error.addAndGet(1);
                    }
                } else {
                    success.addAndGet(1);
                }
            }
            catch (RuntimeException e) {
                ERROR_ARRAY.add(String.valueOf(mapper.getResType()) + "\u8d44\u6e90\u6587\u4ef6[" + alias + "]\u6307\u5411\u4e86\u4e00\u4e2a\u4e0d\u5b58\u5728\u7684\u4f4d\u7f6e\uff1a" + path);
                error.addAndGet(1);
            }
            i.addAndGet(1);
        });
        String resultMsg = String.valueOf(mapper.getResType()) + "\u8d44\u6e90\u68c0\u67e5\u5b8c\u6210\uff0c\u5171 " + size + " \u4e2a,\u6b63\u786e " + success.get() + " \u4e2a,\u9519\u8bef " + error.get() + " \u4e2a";
        if (error.get() > 0) {
            LOGGER.error(resultMsg);
        } else {
            LOGGER.info(resultMsg);
        }
        return error.get();
    }
}

