/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.file.service.FileService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/resource"})
public class FileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileController.class);
    private final FileService fileService;

    public FileController(FileService fileService) {
        this.fileService = fileService;
    }

    @Log(title="\u8d44\u6e90\u4e0a\u4f20", businessType=BusinessType.OTHER)
    @PostMapping(value={"/upload"}, produces={"application/json"})
    public R<Object> upload(@RequestParam(value="avatar") MultipartFile file, @RequestParam(value="resUploadMode") String resUploadMode, @RequestParam(value="resUploadStock") Optional<Integer> stockIdOptional, @RequestParam(value="f_operator") String operator, @RequestParam(value="pathKey") String pathKey, @RequestParam(value="formType") String formType, @RequestParam(value="useType") String useType, @RequestParam(value="bucketName", required=false, defaultValue="#{@resourceConfig.getExtraPaths()}") String bucketName) {
        LOGGER.info("\u6587\u4ef6\u4e0a\u4f20\uff0c\u6587\u4ef6\u540d\uff1a{}", (Object)file.getOriginalFilename());
        int stockId = stockIdOptional.orElse(0);
        FileService.FileUploadResult result = this.fileService.uploadFile(file, resUploadMode, stockId, operator, pathKey, formType, useType, bucketName);
        if (result.getSuccess().booleanValue()) {
            return R.ok((Object)result);
        }
        return R.fail((Object)result, (String)result.getData().toString());
    }

    @Log(title="\u8d44\u6e90\u5220\u9664", businessType=BusinessType.OTHER)
    @DeleteMapping(value={"/delete"}, produces={"application/json"})
    public R<Object> delete(Integer id, String resDeleteMode) {
        LOGGER.info("\u6587\u4ef6\u5220\u9664\uff0c\u6587\u4ef6id\uff1a{}", (Object)id);
        FileService.FileUploadResult result = this.fileService.deleteFile(id, resDeleteMode);
        if (result.getSuccess().booleanValue()) {
            return R.ok((Object)result);
        }
        return R.fail((Object)result, (String)result.getData().toString());
    }
}

