package com.af.v4.system.runtime.upgrade;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.logic.service.LogicService;
import com.af.v4.system.runtime.dto.UpgradeField;
import org.json.JSONArray;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * 升级路径执行器
 */
@Component
public abstract class UpgradePathExecutor {

    protected final LogicService logicService;
    protected final SqlService sqlService;
    protected final ApplicationUtils applicationUtils;
    protected final LiuLiConfigService liuLiConfigService;

    protected UpgradePathExecutor() {
        this.logicService = SpringUtils.getBean(LogicService.class);
        this.sqlService = SpringUtils.getBean(SqlService.class);
        this.applicationUtils = SpringUtils.getBean(ApplicationUtils.class);
        this.liuLiConfigService = SpringUtils.getBean(LiuLiConfigService.class);
    }

    @Transactional(rollbackFor = Exception.class)
    public abstract void upgrade();

    public abstract String targetVersion();

    public final int targetVersionCode() {
        return ApplicationUtils.buildVersionCode(targetVersion());
    }

    protected void removeCacheKeys(List<String> cacheKeys) {
        String namespaceName = applicationUtils.getApplicationName();
        liuLiConfigService.removeCacheKeys(namespaceName, "prod", cacheKeys);
    }

    protected void addFields (List<UpgradeField> fields) {
        for (UpgradeField field : fields) {
            String searchSql = field.getSearchSql();
            JSONArray searchResult = sqlService.querySQL("UpgradeField", searchSql);
            if (searchResult.isEmpty()) {
                String addSql = field.getAddSql();
                sqlService.execSQL("UpgradeField", addSql);
            }
        }
    }

}
