package com.af.v4.system.runtime.upgrade;

import com.af.v4.system.common.core.utils.SpringUtils;
import com.af.v4.system.common.jpa.service.SqlService;
import com.af.v4.system.common.liuli.utils.ApplicationUtils;
import com.af.v4.system.common.logic.service.LogicService;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 升级路径执行器
 */
@Component
public abstract class UpgradePathExecutor {

    protected final LogicService logicService;
    protected final SqlService sqlService;
    protected final ApplicationUtils applicationUtils;

    protected UpgradePathExecutor() {
        this.logicService = SpringUtils.getBean(LogicService.class);
        this.sqlService = SpringUtils.getBean(SqlService.class);
        this.applicationUtils = SpringUtils.getBean(ApplicationUtils.class);
    }

    @Transactional(rollbackFor = Exception.class)
    public abstract void upgrade();

    public abstract String targetVersion();

    public final int targetVersionCode() {
        return ApplicationUtils.buildVersionCode(targetVersion());
    }
}
