package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.file.service.FileService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.Optional;

/**
 * 文件控制器
 *
 * @author Mr.river
 */
@RestController
@RequestMapping("/resource")
public class FileController {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileController.class);

    private final FileService fileService;

    public FileController(FileService fileService) {
        this.fileService = fileService;
    }

    /**
     * 资源上传
     *
     * @param file          文件
     * @param resUploadMode 资源上传模式
     * @param stockIdOptional       文件仓库ID
     * @param operator      操作人
     * @param pathKey       扩展目录
     * @param formType      表单类型
     * @param useType       附件用途
     * @param bucketName    OSS BucketName, 可以为空，默认值“af-system”
     * @return 上传结果
     */
    @Log(title = "资源上传", businessType = BusinessType.OTHER)
    @PostMapping(value = "/upload", produces = MediaType.APPLICATION_JSON_VALUE)
    public R<Object> upload(
            @RequestParam("avatar") MultipartFile file,
            @RequestParam("resUploadMode") String resUploadMode,
            @RequestParam("resUploadStock") Optional<Integer> stockIdOptional,
            @RequestParam("f_operator") String operator,
            @RequestParam("pathKey") String pathKey,
            @RequestParam("formType") String formType,
            @RequestParam("useType") String useType,
            @RequestParam(value = "bucketName", required = false, defaultValue = "#{@applicationUtils.getApplicationName()}") String bucketName) {
        LOGGER.info("文件上传，文件名：{}", file.getOriginalFilename());
        int stockId = stockIdOptional.orElse(0);

        FileService.FileUploadResult result = fileService.uploadFile(file, resUploadMode, stockId, operator, pathKey, formType, useType, bucketName);
        if (result.getSuccess()) {
            return R.ok(result);
        } else {
            return R.fail(result, result.getData().toString());
        }
    }
}
