package com.af.v4.system.runtime.config;

import com.af.v4.system.runtime.interceptor.DataSourceInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 运行时拦截器配置
 */
public class WebMvcRuntimeConfig implements WebMvcConfigurer {

    @Override
    public void addInterceptors(InterceptorRegistry registry)
    {
        registry.addInterceptor(getInterceptor())
                .addPathPatterns("/**")
                .order(-9);
    }

    /**
     * 自定义拦截器
     */
    public DataSourceInterceptor getInterceptor()
    {
        return new DataSourceInterceptor();
    }
}
