/*
 * Decompiled with CFR 0.152.
 */
package com.af.v4.system.runtime.controller.extend;

import com.af.v4.system.common.core.domain.R;
import com.af.v4.system.common.excel.service.ExcelService;
import com.af.v4.system.common.jpa.service.EntityService;
import com.af.v4.system.common.liuli.config.service.LiuLiConfigService;
import com.af.v4.system.common.log.annotation.Log;
import com.af.v4.system.common.log.enums.BusinessType;
import com.af.v4.system.common.logic.service.LogicService;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/crud"})
public class CRUDFormConfigController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CRUDFormConfigController.class);
    private final EntityService entityService;
    private final LogicService logicService;
    private final LiuLiConfigService liuLiConfigService;

    public CRUDFormConfigController(EntityService entityService, LogicService logicService, LiuLiConfigService liuLiConfigService) {
        this.entityService = entityService;
        this.logicService = logicService;
        this.liuLiConfigService = liuLiConfigService;
    }

    @Log(title="\u901a\u8fc7excel\u5bfc\u5165\u6570\u636e", businessType=BusinessType.IMPORT)
    @PostMapping(value={"/importDataByExcel"}, produces={"application/json"})
    public R<Object> importDataByExcel(@RequestParam(value="file") MultipartFile file, @RequestParam(value="queryParamsName") String queryParamsName) {
        try {
            JSONObject config = this.liuLiConfigService.get(queryParamsName, Boolean.valueOf(true));
            JSONArray excelImportTemplate = config.optJSONArray("excelImportTemplate");
            if (excelImportTemplate == null || excelImportTemplate.isEmpty()) {
                return R.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u6ca1\u6709\u914d\u7f6e\u5bfc\u5165\u5217");
            }
            JSONObject apiSolt = config.optJSONObject("apiSlot");
            JSONArray titles = new JSONArray();
            JSONArray columns = new JSONArray();
            JSONArray datas = new JSONArray();
            excelImportTemplate.forEach(item -> {
                JSONObject itemObj = (JSONObject)item;
                titles.putAll(itemObj.get("title"));
                columns.putAll(itemObj.get("column"));
            });
            List dataList = ExcelService.importExcel((InputStream)file.getInputStream(), (JSONArray)titles);
            if (apiSolt != null && apiSolt.has("excelImportTemplateBefore")) {
                dataList.forEach(data -> {
                    JSONObject entity = new JSONObject();
                    for (int i = 0; i < columns.length(); ++i) {
                        entity.put(columns.getString(i), data.get(i));
                    }
                    datas.put((Object)entity);
                });
                Object result = this.logicService.run(apiSolt.getString("excelImportTemplateBefore"), new JSONObject().put("config", (Object)config).put("datas", (Object)datas));
                JSONObject resultObj = (JSONObject)result;
                if (resultObj.get("status").toString().equals("1")) {
                    return R.fail((String)resultObj.optString("msg", "\u5bfc\u5165\u5931\u8d25\uff0c\u6570\u636e\u6821\u9a8c\u5931\u8d25"));
                }
            }
            if (apiSolt != null && apiSolt.has("excelImportTemplateLogic")) {
                if (datas.isEmpty()) {
                    dataList.forEach(data -> {
                        JSONObject entity = new JSONObject();
                        for (int i = 0; i < columns.length(); ++i) {
                            entity.put(columns.getString(i), data.get(i));
                        }
                        datas.put((Object)entity);
                    });
                }
                this.logicService.run(apiSolt.getString("excelImportTemplateLogic"), new JSONObject().put("datas", (Object)datas));
            } else {
                excelImportTemplate.forEach(importTable -> {
                    JSONObject importTableObj = (JSONObject)importTable;
                    String tableName = importTableObj.getString("tableName");
                    LOGGER.info("\u5bfc\u5165\u8868\u540d\uff1a{}", (Object)tableName);
                    dataList.forEach(data -> {
                        JSONObject entity = new JSONObject();
                        for (int i = 0; i < columns.length(); ++i) {
                            entity.put(columns.getString(i), data.get(i));
                        }
                        LOGGER.info("\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)entity);
                        try {
                            this.entityService.partialSave(tableName, entity);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                });
            }
            if (apiSolt != null && apiSolt.has("excelImportTemplateAfter")) {
                this.logicService.run(apiSolt.getString("excelImportTemplateAfter"), new JSONObject().put("config", (Object)config).put("datas", (Collection)dataList));
            }
            return R.ok((Object)"\u5bfc\u5165\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            LOGGER.error("\u5bfc\u5165\u6570\u636e\u5931\u8d25", (Throwable)e);
            return R.fail((String)"\u5bfc\u5165\u6570\u636e\u5931\u8d25");
        }
    }
}

