package com.af.v4.system.runtime.interceptor;

import com.af.v4.system.common.core.context.SecurityContextHolder;
import com.af.v4.system.common.datasource.DynamicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.AsyncHandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * 清理数据源线程变量拦截器
 */
public class DataSourceInterceptor implements AsyncHandlerInterceptor {

    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceInterceptor.class);

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        DynamicDataSource.clearDataSource();
        SecurityContextHolder.remove();
    }
}
