package com.af.v4.system.runtime.controller;

import com.af.v4.system.common.datasource.DynamicDataSource;
import com.af.v4.system.common.resource.mapper.SqlMapper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * SQL控制器（兼容）
 *
 * @author Mr.river
 * @apiNote 该api存在安全隐患，仅用于保持对v3及以前版本的兼容，
 * <p>该api随时都有可能移除，请不要使用该api开发任何新业务，对于以前的旧业务，
 * 也应尽快调整为使用更加安全的LogicController或EntityController</p>
 * @see com.af.v4.system.runtime.controller.LogicController
 * @see com.af.v4.system.runtime.controller.EntityController
 */
@Deprecated(since = "1.0.0", forRemoval = true)
@RestController
@RequestMapping("/sql")
public class SQLController {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLController.class);
    private final LogicController logicController;
    private final SqlMapper sqlMapper;

    public SQLController(LogicController logicController, SqlMapper sqlMapper) {
        this.logicController = logicController;
        this.sqlMapper = sqlMapper;
    }

    /**
     * 创建参数
     *
     * @param sqlName SQL名称
     * @param values  查询参数
     * @return 创建的参数
     */
    private JSONObject createParams(String sqlName, String values) {
        JSONObject params = new JSONObject();
        JSONObject valuesJson = values != null ? new JSONObject(values) : null;
        JSONArray sums = null;
        if (valuesJson != null && valuesJson.has("sums")) {
            sums = valuesJson.optJSONArray("sums");
        }
        if (valuesJson != null && valuesJson.has("data")) {
            valuesJson = valuesJson.getJSONObject("data").put("sums", sums);
        }
        params.put("sqlName", sqlName);
        params.put("values", valuesJson);
        return params;
    }

    /**
     * 获取合计执行结果
     *
     * @param sqlName  SQL名称
     * @param values   查询参数
     * @param response response
     * @param request  request
     * @return 执行结果
     */
    @PostMapping(value = "{sqlName}/n", produces = MediaType.APPLICATION_JSON_VALUE)
    public Object queryTotal(@PathVariable("sqlName") String sqlName,
                             @RequestBody(required = false) String values,
                             HttpServletResponse response,
                             HttpServletRequest request) {
        JSONObject params = createParams(sqlName, values);
        this.setDataSourceForSQL(sqlName);
        return logicController.runByNoToken("querySQLNForV4Compatible", params.toString(), response, request);
    }

    /**
     * 根据SQL文件执行查询
     *
     * @param sqlName  SQL名称
     * @param pageNo   查询页数
     * @param pageSize 每页数量
     * @param values   查询参数
     * @param response response
     * @param request  request
     * @return 执行结果
     */
    @PostMapping(value = "{sqlName}", produces = MediaType.APPLICATION_JSON_VALUE)
    public Object query(@PathVariable("sqlName") String sqlName,
                        @RequestParam(value = "pageNo", required = false) Integer pageNo,
                        @RequestParam(value = "pageSize", required = false) Integer pageSize,
                        @RequestBody(required = false) String values,
                        HttpServletResponse response,
                        HttpServletRequest request) {
        JSONObject params = createParams(sqlName, values);
        params.put("pageNo", pageNo);
        params.put("pageSize", pageSize);
        this.setDataSourceForSQL(sqlName);
        return logicController.runByNoToken("querySQLForV4Compatible", params.toString(), response, request);
    }

    /**
     * 设置执行SQL的数据源
     *
     * @param sqlName SQL名称
     */
    private void setDataSourceForSQL(String sqlName) {
        SqlMapper.SqlResource sqlResource = sqlMapper.getResource(sqlName);
        String dataSource = sqlResource.getDataSource();
        if (dataSource != null) {
            DynamicDataSource.setDataSource(dataSource);
        }
    }
}
